/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.abtest;

import android.content.Context;
import android.text.TextUtils;
import androidx.annotation.Nullable;
import androidx.collection.ArrayMap;
import com.yy.abtest.IConfigChangedCallback;
import com.yy.abtest.IGetLayerConfigCallback;
import com.yy.abtest.IYYABTestLog;
import com.yy.abtest.YYABTestSDK;
import com.yy.appbase.AppKeysDef;
import com.yy.appbase.abtest.ABConfig;
import com.yy.appbase.abtest.ABDefine;
import com.yy.appbase.abtest.ABTestConfigStorage;
import com.yy.appbase.abtest.ABType;
import com.yy.appbase.abtest.AbTestReport;
import com.yy.appbase.abtest.IAB;
import com.yy.appbase.abtest.IGetABTestCallback;
import com.yy.appbase.abtest.IGetConfigCallback;
import com.yy.appbase.abtest.ReadAbTestConfigCallback;
import com.yy.appbase.abtest.newab.NAB;
import com.yy.appbase.envsetting.EnvSettingType;
import com.yy.appbase.envsetting.EnvSettings;
import com.yy.appbase.http.CommonHttpHeader;
import com.yy.appbase.unifyconfig.config.BackupHostConfig;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.IQueueTaskExecutor;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.SystemUtils;
import com.yy.base.utils.VersionUtil;
import com.yy.base.utils.network.NetworkUtils;
import com.yy.framework.core.INotify;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import com.yy.framework.core.NotificationDef;
import com.yy.yylite.commonbase.hiido.HiidoStatisInit;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import kotlin.jvm.functions.Function0;
import org.jetbrains.annotations.NotNull;
import org.json.JSONObject;

public class ABTestManager
implements INotify {
    private static final String TAG = "ABTestManager";
    private static volatile boolean hadInitSDK = false;
    private static volatile boolean isInitSDKing = false;
    private int mInitRetryCount = 0;
    private boolean mNetworkState;
    private ArrayMap<String, ABPendingData> mPendingConfigMap;
    private CopyOnWriteArraySet<String> mPendingReportId;
    private long mUid;
    private IQueueTaskExecutor mQueueTaskExecutor = YYTaskExecutor.createAQueueExcuter((boolean)false, (boolean)false);
    private Runnable mInitRunnable = new Runnable(){

        @Override
        public void run() {
            EnvSettingType type2;
            String country = SystemUtils.getHagoCountry();
            if (TextUtils.isEmpty((CharSequence)country) && ABTestManager.this.mInitRetryCount < 3) {
                ABTestManager.this.mInitRetryCount++;
                YYTaskExecutor.removeTask((Runnable)this);
                YYTaskExecutor.execute((Runnable)this, (long)1000L);
                return;
            }
            country = country == null ? "" : country;
            YYABTestSDK.getInstance().config().setLoger((IYYABTestLog)new ABLog());
            YYABTestSDK.getInstance().config().setUseDebugEnv(EnvSettings.instance().getAbTestEnv());
            YYABTestSDK.getInstance().config().setUseInternationalEnv(true);
            YYABTestSDK.getInstance().config().setAreaCode(country);
            YYABTestSDK.getInstance().config().setAppVersion(VersionUtil.getVersionWithoutSnpashot((Context)RuntimeContext.sApplicationContext));
            YYABTestSDK.getInstance().config().setABTestType(2);
            if ((ABTestManager.this.mUid = SettingFlags.getLongValue((String)"4c41dd1dcb783cde006fcb9744e11455")) > 0L) {
                YYABTestSDK.getInstance().config().setUid(ABTestManager.this.mUid);
            }
            if ((type2 = EnvSettings.instance().getUriSettingValue()) == EnvSettingType.Test || type2 == EnvSettingType.Dev) {
                YYABTestSDK.getInstance().config().setUrl("https://test-iab.duowan.com/api/experiment");
            } else {
                YYABTestSDK.getInstance().config().setUrl("https://iab.duowan.com/api/experiment");
            }
            String abTestUrl = BackupHostConfig.getOurSDKURI("AbTest");
            if (StringUtils.isNotEmpty((String)abTestUrl)) {
                YYABTestSDK.getInstance().config().setUrl(abTestUrl);
            }
            MLog.info((Object)ABTestManager.TAG, (String)"mInitRunnable uid: %d", (Object[])new Object[]{ABTestManager.this.mUid});
            isInitSDKing = false;
            if (RuntimeContext.isHagoPartySdk()) {
                YYABTestSDK.getInstance().setAppVersion(CommonHttpHeader.getHagoAppVerStr());
            }
            YYABTestSDK.getInstance().init(RuntimeContext.sApplicationContext, HiidoStatisInit.getHiidoAppkey(), AppKeysDef.getAbtestAppId());
            hadInitSDK = true;
            ABTestManager.this.onSdkInit();
            ABTestManager.this.updateAbConfigMap((Function0<Void>)((Function0)new Function0<Void>(){

                public Void invoke() {
                    ABTestManager.this.checkPaddingReport();
                    ABTestManager.this.mQueueTaskExecutor.execute(new Runnable(){

                        @Override
                        public void run() {
                            if (NetworkUtils.isNetworkAvailable((Context)RuntimeContext.sApplicationContext)) {
                                if (ABTestManager.this.mPendingConfigMap == null) {
                                    return;
                                }
                                for (int i = 0; i < ABTestManager.this.mPendingConfigMap.size(); ++i) {
                                    final ABPendingData pd = (ABPendingData)ABTestManager.this.mPendingConfigMap.valueAt(i);
                                    if (pd.cached) continue;
                                    String abTestId = (String)ABTestManager.this.mPendingConfigMap.keyAt(i);
                                    YYABTestSDK.getInstance().getLayerConfig(abTestId, new IGetLayerConfigCallback(){

                                        public void onCallback(final JSONObject json, final int error) {
                                            ABTestManager.this.mQueueTaskExecutor.execute(new Runnable(){

                                                @Override
                                                public void run() {
                                                    ABTestManager.this.getAbConfigFromSDK(pd, json, error);
                                                }
                                            }, 0L);
                                        }
                                    }, 5000L);
                                }
                            }
                        }
                    }, 5000L);
                    return null;
                }
            }), 0L);
        }
    };
    List<Runnable> mGetABValueCacheCache = new CopyOnWriteArrayList<Runnable>();

    private void onSdkInit() {
        for (int i = 0; i < this.mGetABValueCacheCache.size(); ++i) {
            this.mGetABValueCacheCache.get(i).run();
        }
    }

    private ABTestManager() {
    }

    public static ABTestManager getInstance() {
        return InstanceHolder.instance;
    }

    public void init() {
        MLog.info((Object)TAG, (String)"init", (Object[])new Object[0]);
        ABTestConfigStorage.getInstance().setReadConfigCallback(new ReadAbTestConfigCallback(){

            @Override
            public void onReadFinish() {
                MLog.info((Object)ABTestManager.TAG, (String)"onReadFinish", (Object[])new Object[0]);
                ABTestManager.this.initABTestSDK();
            }
        });
        this.mNetworkState = NetworkUtils.isNetworkAvailable((Context)RuntimeContext.sApplicationContext);
        if (YYTaskExecutor.isMainThread()) {
            NotificationCenter.getGlobalInstance().register(NotificationDef.N_NETWORK_STATE_CHANGE, (INotify)this);
        } else {
            YYTaskExecutor.postToMainThread(() -> NotificationCenter.getGlobalInstance().register(NotificationDef.N_NETWORK_STATE_CHANGE, (INotify)this));
        }
    }

    public void reportLayerEvent(String abTestId) {
        if (!TextUtils.isEmpty((CharSequence)abTestId)) {
            if (!hadInitSDK) {
                this.mPendingReportId = new CopyOnWriteArraySet();
                this.mPendingReportId.add(abTestId);
            } else {
                AbTestReport.INSTANCE.report(abTestId);
            }
        }
    }

    private void checkPaddingReport() {
        if (hadInitSDK && !FP.empty(this.mPendingReportId)) {
            for (String id2 : this.mPendingReportId) {
                this.mPendingReportId = new CopyOnWriteArraySet();
                this.reportLayerEvent(id2);
            }
        }
    }

    private void updateAbConfigMap(final Function0<Void> callback, long delay) {
        ABDefine.getAllAbConfigs(new IGetConfigCallback(){

            @Override
            public void onGetAllConfig(final @NotNull HashSet<ABConfig<IAB>> allAbConfigs) {
                MLog.info((Object)ABTestManager.TAG, (String)("onGetAllConfig, config size: " + allAbConfigs.size()), (Object[])new Object[0]);
                if (allAbConfigs.isEmpty()) {
                    return;
                }
                ABTestManager.this.mQueueTaskExecutor.execute(new Runnable(){

                    @Override
                    public void run() {
                        if (ABTestManager.this.mPendingConfigMap == null) {
                            ABTestManager.this.mPendingConfigMap = new ArrayMap(50);
                        }
                        Iterator iterator2 = allAbConfigs.iterator();
                        String abTestId = null;
                        while (iterator2.hasNext()) {
                            ABConfig config = (ABConfig)((Object)iterator2.next());
                            abTestId = config.getAbTestId();
                            MLog.debug((Object)ABTestManager.TAG, (String)("updateAbConfigMap abTestId:" + abTestId), (Object[])new Object[0]);
                            ABPendingData pendingData = (ABPendingData)ABTestManager.this.mPendingConfigMap.get((Object)abTestId);
                            if (pendingData == null) {
                                IConfigChangedCallback callback;
                                final ABPendingData pd = new ABPendingData();
                                pd.config = config;
                                pd.cached = false;
                                pd.callback = callback = new IConfigChangedCallback(){

                                    public void onCallback(final JSONObject json, final int errorCode) {
                                        ABTestManager.this.mQueueTaskExecutor.execute(new Runnable(){

                                            @Override
                                            public void run() {
                                                ABTestManager.this.getAbConfigFromSDK(pd, json, errorCode);
                                            }
                                        }, 0L);
                                    }
                                };
                                ABTestManager.this.mPendingConfigMap.put((Object)abTestId, (Object)pd);
                                YYABTestSDK.getInstance().addConfigChangedListener(abTestId, callback);
                                continue;
                            }
                            MLog.debug((Object)ABTestManager.TAG, (String)("updateAbConfigMap, " + abTestId + " is exist, no need addConfigChangedListener"), (Object[])new Object[0]);
                            pendingData.cached = false;
                        }
                        if (callback != null) {
                            callback.invoke();
                        }
                    }
                }, 0L);
            }
        }, delay);
    }

    public void notify(Notification notification) {
        int id2 = notification.id;
        if (id2 == NotificationDef.N_NETWORK_STATE_CHANGE) {
            boolean valid = NetworkUtils.isNetworkAvailable((Context)RuntimeContext.sApplicationContext);
            if (!this.mNetworkState && valid) {
                this.mQueueTaskExecutor.execute(new Runnable(){

                    @Override
                    public void run() {
                        ABTestManager.this.checkPaddingReport();
                        boolean needRequest = false;
                        if (ABTestManager.this.mPendingConfigMap != null) {
                            for (int i = 0; i < ABTestManager.this.mPendingConfigMap.size(); ++i) {
                                if (((ABPendingData)((ABTestManager)ABTestManager.this).mPendingConfigMap.valueAt((int)i)).cached) continue;
                                needRequest = true;
                                break;
                            }
                        }
                        if (needRequest) {
                            YYABTestSDK.getInstance().config().apply();
                        }
                    }
                }, 500L);
            }
            this.mNetworkState = valid;
        }
    }

    public void setUid(final long uid) {
        MLog.info((Object)TAG, (String)"setUid hadInitSDK: %s", (Object[])new Object[]{hadInitSDK});
        if (hadInitSDK && this.mUid != uid && uid > 0L) {
            this.mUid = uid;
            this.updateAbConfigMap(new Function0<Void>(){

                public Void invoke() {
                    String country = SystemUtils.getHagoCountry();
                    country = country == null ? "" : country;
                    YYABTestSDK.getInstance().config().setAreaCode(country);
                    YYABTestSDK.getInstance().config().setUid(uid);
                    YYABTestSDK.getInstance().config().apply();
                    return null;
                }
            }, 1000L);
        }
    }

    public void clear() {
        ABTestConfigStorage.getInstance().clear();
    }

    private void initABTestSDK() {
        MLog.info((Object)TAG, (String)"initABTestSDK hadInitSDK: %b, isInitSDKing: %b", (Object[])new Object[]{hadInitSDK, isInitSDKing});
        if (hadInitSDK || isInitSDKing) {
            return;
        }
        isInitSDKing = true;
        if (YYTaskExecutor.isMainThread()) {
            YYTaskExecutor.execute((Runnable)this.mInitRunnable);
        } else {
            this.mInitRunnable.run();
        }
    }

    public void getABTestValueByKey(final String key, final IGetABTestCallback configCallback) {
        if (!hadInitSDK) {
            this.mGetABValueCacheCache.add(new Runnable(){
                String cachekey;
                IGetABTestCallback cacheCallback;
                {
                    this.cachekey = key;
                    this.cacheCallback = configCallback;
                }

                @Override
                public void run() {
                    ABTestManager.this.getABTestValueByKey(this.cachekey, this.cacheCallback);
                }
            });
            return;
        }
        YYABTestSDK.getLayerInstance().getLayerConfig(key, new IGetLayerConfigCallback(){

            public void onCallback(JSONObject json, int error) {
                if (configCallback != null) {
                    configCallback.onCallback(json, error);
                }
            }
        }, 5000L);
    }

    private void getAbConfigFromSDK(@Nullable ABPendingData pendingData, @Nullable JSONObject json, int error) {
        MLog.debug((Object)TAG, (String)"getAbConfigFromSDK hadInitSDK: %b, configs.id: %s, json: %s, error: %d", (Object[])new Object[]{hadInitSDK, pendingData == null ? "" : pendingData.config.getAbTestId(), json == null ? "" : json.toString(), error});
        if (hadInitSDK && pendingData != null) {
            if (pendingData.ignored) {
                pendingData.ignored = false;
                return;
            }
            ABConfig<IAB> config = pendingData.config;
            if (error == 0) {
                pendingData.cached = true;
            }
            if (config.getAbType() == ABType.NEW) {
                if (json != null && json.length() > 0) {
                    config.setTest(NAB.fromValue(json));
                } else if (json != null && json.length() <= 0) {
                    config.setTestAndSave(null);
                } else {
                    config.setTestAndSave(null);
                }
            } else {
                MLog.info((Object)TAG, (String)"getAbConfigFromSDK unvalid abType: %s, testId: %s", (Object[])new Object[]{config.getAbType(), config.getAbTestId()});
            }
        }
    }

    public static String getLayerConfig(String layerId) {
        JSONObject jsonObject = YYABTestSDK.getInstance().getLayerConfig(layerId);
        return jsonObject != null ? jsonObject.toString() : "{}";
    }

    private static class ABLog
    implements IYYABTestLog {
        private ABLog() {
        }

        public void verbose(String tag, String msg) {
            MLog.verbose((Object)tag, (String)msg, (Object[])new Object[0]);
        }

        public void debug(String tag, String msg) {
        }

        public void info(String tag, String msg) {
            if (RuntimeContext.sIsDebuggable) {
                MLog.info((Object)tag, (String)msg, (Object[])new Object[0]);
            }
        }

        public void warn(String tag, String msg) {
            MLog.warn((Object)tag, (String)msg, (Object[])new Object[0]);
        }

        public void error(String tag, String msg) {
            MLog.error((Object)tag, (String)msg, (Object[])new Object[0]);
        }

        public void error(String tag, String msg, Throwable t) {
            MLog.error((Object)tag, (String)msg, (Throwable)t, (Object[])new Object[0]);
        }
    }

    private static class ABPendingData {
        public ABConfig<IAB> config;
        public boolean cached;
        public boolean ignored = true;
        public IConfigChangedCallback callback;

        private ABPendingData() {
        }
    }

    private static class InstanceHolder {
        static ABTestManager instance = new ABTestManager();

        private InstanceHolder() {
        }
    }
}

