/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.abtest;

import android.text.TextUtils;
import com.google.gson.reflect.TypeToken;
import com.yy.appbase.abtest.ABConfig;
import com.yy.appbase.abtest.ABDefine;
import com.yy.appbase.abtest.IAB;
import com.yy.appbase.abtest.IGetConfigCallback;
import com.yy.appbase.abtest.ReadAbTestConfigCallback;
import com.yy.appbase.abtest.newab.NAB;
import com.yy.appbase.abtest.newab.NABV;
import com.yy.appbase.abtest.oldab.OAB;
import com.yy.appbase.abtest.oldab.OABV;
import com.yy.base.event.kvo.KvoEventIntent;
import com.yy.base.event.kvo.KvoMethodAnnotation;
import com.yy.base.event.kvo.helper.KvoBinder;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.base.utils.YYFileUtils;
import com.yy.base.utils.filestorage.FileStorageUtils;
import com.yy.base.utils.json.JsonParser;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.io.File;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;

class ABTestConfigStorage {
    private static final String TAG = "ABTestConfigStorage";
    private static final Type JSON_TYPE_OLD = new TypeToken<Map<String, OAB>>(){}.getType();
    private static final Type JSON_TYPE_NEW = new TypeToken<Map<String, NAB>>(){}.getType();
    private final Object fileLock = new Object();
    private final Map<String, IAB> mConfigMap = new ConcurrentHashMap<String, IAB>();
    private ReadAbTestConfigCallback mCallback;
    private volatile boolean hadReadFinish;
    private long mLastWriteTime;
    private Runnable mWriteRunnable = new Runnable(){

        @Override
        public void run() {
            ABTestConfigStorage.this.writeConfig();
        }
    };
    private final KvoBinder mBinder = new KvoBinder((Object)this);

    private ABTestConfigStorage() {
        if (YYTaskExecutor.isMainThread()) {
            YYTaskExecutor.execute((Runnable)new Runnable(){

                @Override
                public void run() {
                    ABTestConfigStorage.this.readConfig();
                }
            });
        } else {
            this.readConfig();
        }
        ABDefine.getAllAbConfigs(new IGetConfigCallback(){

            @Override
            public void onGetAllConfig(@NotNull HashSet<ABConfig<IAB>> abConfigs) {
            }
        });
    }

    static ABTestConfigStorage getInstance() {
        return InstanceHolder.instance;
    }

    public void setReadConfigCallback(ReadAbTestConfigCallback callback) {
        this.mCallback = callback;
        if (this.hadReadFinish && this.mCallback != null) {
            this.mCallback.onReadFinish();
        }
    }

    @KvoMethodAnnotation(name="test", sourceClass=ABConfig.class, thread=2)
    void onUpdateTest(KvoEventIntent event) {
        if (event.isStickyNotify()) {
            return;
        }
        ABConfig config = (ABConfig)event.source();
        this.saveTest(config);
    }

    public void saveTest(ABConfig config) {
        if (!TextUtils.isEmpty((CharSequence)config.getAbTestId())) {
            if (config.isTestValid()) {
                IAB iab = this.mConfigMap.get(config.getAbTestId());
                if (iab == null || !iab.equals(config.getTestWithoutReport())) {
                    this.mConfigMap.put(config.getAbTestId(), (IAB)config.getTestWithoutReport());
                    this.checkWrite();
                }
            } else {
                this.mConfigMap.remove(config.getAbTestId());
                HiidoStatis.removeAbTestFlag((String[])new String[]{config.getAbTestId()});
                this.checkWrite();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void readConfig() {
        block20: {
            var1_1 = this.fileLock;
            // MONITORENTER : var1_1
            path = this.getSaveConfigPath();
            if (!YYFileUtils.isPathExist((String)path)) {
                MLog.error((Object)"ABTestConfigStorage", (String)"readConfig path is not exist: %s", (Object[])new Object[]{path});
                // MONITOREXIT : var1_1
                return;
            }
            ** try [egrp 2[TRYBLOCK] [5 : 63->77)] { 
lbl-1000:
            // 1 sources

            {
                content = YYFileUtils.readJsonData((String)path);
                if (!TextUtils.isEmpty((CharSequence)content)) break block20;
                // MONITOREXIT : var1_1
                if (this.mCallback != null) {
                    this.mCallback.onReadFinish();
                    this.mCallback = null;
                }
                this.hadReadFinish = true;
                return;
            }
        }
        try {
            abMapOld = (Map)JsonParser.parseJsonFile((String)path, (Type)ABTestConfigStorage.JSON_TYPE_OLD);
            abMapNew = (Map)JsonParser.parseJsonFile((String)path, (Type)ABTestConfigStorage.JSON_TYPE_NEW);
            abMap = new HashMap<String, IAB>();
            if (!FP.empty((Map)abMapOld)) {
                for (Map.Entry<K, V> ab : abMapOld.entrySet()) {
                    if (!(((OAB)ab.getValue()).getABValue() instanceof OABV) || !((OAB)ab.getValue()).getABValue().isValid()) continue;
                    abMap.put((String)ab.getKey(), (IAB)ab.getValue());
                }
            }
            if (!FP.empty((Map)abMapNew)) {
                for (Map.Entry<K, V> ab : abMapNew.entrySet()) {
                    if (!(((NAB)ab.getValue()).getABValue() instanceof NABV) || !((NAB)ab.getValue()).getABValue().isValid()) continue;
                    abMap.put((String)ab.getKey(), (IAB)ab.getValue());
                }
            }
            if (FP.empty(abMap)) {
                YYFileUtils.delete((File)new File(path));
                this.bindKvo();
            } else {
                this.initAllTest(abMap);
            }
            // MONITOREXIT : var1_1
            if (this.mCallback != null) {
                this.mCallback.onReadFinish();
                this.mCallback = null;
            }
            this.hadReadFinish = true;
            return;
        }
lbl47:
        // 3 sources

        catch (Exception e) {
            MLog.error((Object)"ABTestConfigStorage", (Throwable)e);
            this.bindKvo();
            return;
        }
        finally {
            if (this.mCallback != null) {
                this.mCallback.onReadFinish();
                this.mCallback = null;
            }
            this.hadReadFinish = true;
        }
    }

    private void bindKvo() {
        ABDefine.getAllAbConfigs(new IGetConfigCallback(){

            @Override
            public void onGetAllConfig(@NotNull HashSet<ABConfig<IAB>> abConfigs) {
                for (ABConfig<IAB> ab : abConfigs) {
                    ABTestConfigStorage.this.mBinder.singleBindSourceTo(ab.getAbTestId(), ab);
                }
            }
        });
    }

    private void initAllTest(Map<String, IAB> abMap) {
        this.mConfigMap.clear();
        this.mConfigMap.putAll(abMap);
        ABDefine.getAllAbConfigs(new IGetConfigCallback(){

            @Override
            public void onGetAllConfig(@NotNull HashSet<ABConfig<IAB>> abConfigs) {
                boolean needWrite = false;
                for (ABConfig<IAB> config : abConfigs) {
                    if (config.isTestValid()) {
                        ABTestConfigStorage.this.mConfigMap.put(config.getAbTestId(), config.getTestWithoutReport());
                        needWrite = true;
                    } else {
                        for (Map.Entry entry : ABTestConfigStorage.this.mConfigMap.entrySet()) {
                            if (!config.getAbTestId().equals(entry.getKey())) continue;
                            config.setTestAndSave((IAB)entry.getValue());
                            break;
                        }
                    }
                    ABTestConfigStorage.this.mBinder.singleBindSourceTo(config.getAbTestId(), config);
                }
                if (needWrite) {
                    ABTestConfigStorage.this.writeConfig();
                }
            }
        });
    }

    private void checkWrite() {
        YYTaskExecutor.removeTask((Runnable)this.mWriteRunnable);
        YYTaskExecutor.execute((Runnable)this.mWriteRunnable, (long)(System.currentTimeMillis() - this.mLastWriteTime > 1000L ? 0L : 1000L));
    }

    void clear() {
        this.mConfigMap.clear();
        this.writeConfig();
    }

    void writeConfig() {
        if (!MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)"writeConfig start allConfigMap: %s", (Object[])new Object[]{this.mConfigMap});
        }
        YYTaskExecutor.execute((Runnable)new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ABTestConfigStorage.this.mLastWriteTime = System.currentTimeMillis();
                try {
                    Object object = ABTestConfigStorage.this.fileLock;
                    synchronized (object) {
                        YYFileUtils.saveJsonData((String)JsonParser.toJson((Object)ABTestConfigStorage.this.mConfigMap), (String)ABTestConfigStorage.this.getSaveConfigPath());
                    }
                }
                catch (Exception e) {
                    MLog.error((Object)ABTestConfigStorage.TAG, (Throwable)e);
                }
            }
        });
    }

    private String getSaveConfigPath() {
        return FileStorageUtils.getInstance().getExternalCacheRootDir() + File.separator + "abtest.txt";
    }

    private static class InstanceHolder {
        static ABTestConfigStorage instance = new ABTestConfigStorage();

        private InstanceHolder() {
        }
    }
}

