/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.abtest;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.yy.appbase.abtest.ABDefine;
import com.yy.appbase.abtest.ABTestConfigStorage;
import com.yy.appbase.abtest.ABTestManager;
import com.yy.appbase.abtest.ABType;
import com.yy.appbase.abtest.IAB;
import com.yy.appbase.abtest.RandomAB;
import com.yy.appbase.abtest.newab.NAB;
import com.yy.base.env.RuntimeContext;
import com.yy.base.event.kvo.KvoFieldAnnotation;
import com.yy.base.event.kvo.KvoSource;
import com.yy.base.logger.MLog;
import com.yy.base.utils.FP;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.SystemUtils;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class ABConfig<T extends IAB>
extends KvoSource {
    private static final String TAG = "ABConfig";
    private String abTestId = "";
    private final Set<T> testList = new HashSet<T>();
    public static final String kvo_test = "test";
    @KvoFieldAnnotation(name="test")
    private T test;
    @Deprecated
    private T defaultTest;
    private ABType abType = ABType.NONE;

    private ABConfig() {
    }

    public static ABConfig<IAB> obtain(@NonNull String abTestId, IAB ... testList) {
        return ABConfig.obtainWithDefault(abTestId, null, testList);
    }

    public static ABConfig<IAB> obtainNew(@NonNull String abTestId) {
        return ABConfig.obtainWithDefault(abTestId, ABType.NEW, null, new IAB[0]);
    }

    @Deprecated
    public static ABConfig<IAB> obtainWithDefault(@NonNull String abTestId, @Nullable IAB defaultTest, IAB ... testList) {
        return ABConfig.obtainWithDefault(abTestId, null, defaultTest, testList);
    }

    @Deprecated
    private static ABConfig<IAB> obtainWithDefault(@NonNull String abTestId, ABType type2, @Nullable IAB defaultTest, IAB ... testList) {
        if (TextUtils.isEmpty((CharSequence)abTestId)) {
            throw new IllegalArgumentException("abTestId can not be empty!");
        }
        if (defaultTest instanceof RandomAB && FP.empty((Object[])testList)) {
            throw new IllegalArgumentException("testList can not be empty, while defaultTest is RandomAB!");
        }
        ABConfig<IAB> config = new ABConfig<IAB>();
        config.abTestId = abTestId;
        if (!FP.empty((Object[])testList)) {
            config.testList.addAll(Arrays.asList(testList));
        }
        config.defaultTest = defaultTest;
        if (type2 == null || type2 == ABType.NONE) {
            ABConfig.checkType(config);
        } else {
            config.abType = type2;
        }
        try {
            ABDefine.addAbConfig(config);
        }
        catch (IllegalArgumentException e) {
            MLog.error((Object)TAG, (Throwable)e);
        }
        return config;
    }

    private static void checkType(ABConfig<IAB> config) {
        if (config.test != null) {
            config.abType = config.test instanceof NAB ? ABType.NEW : ABType.OLD;
        }
        for (IAB ab : config.testList) {
            ABType type2;
            ABType aBType = type2 = ab instanceof NAB ? ABType.NEW : ABType.OLD;
            if (config.abType == ABType.NONE) {
                config.abType = ab instanceof NAB ? ABType.NEW : ABType.OLD;
                continue;
            }
            if (config.abType == type2) continue;
            throw new IllegalArgumentException("testList must be the same type of " + (Object)((Object)config.abType));
        }
    }

    public void setTestAndSave(T test) {
        this.setValue(kvo_test, test);
    }

    public void setLocalTest(T test) {
        if (RuntimeContext.sIsDebuggable) {
            if (test == null) {
                SettingFlags.removeKey((String)this.abTestId);
            } else {
                SettingFlags.setIntValue((String)this.abTestId, (int)ABType.LOCAL.value());
                this.setTestAndSave(test);
            }
        }
    }

    void setTest(T value) {
        if (value == null) {
            throw new IllegalArgumentException("value of abtest can not be empty!");
        }
        for (IAB ab : this.testList) {
            if (!ab.getABValue().equals(value.getABValue())) continue;
            if (TextUtils.isEmpty((CharSequence)value.getHiidoValue())) {
                value.setHiidoValue(ab.getHiidoValue());
            }
            this.setTestAndSave(value);
            break;
        }
        if (this.test == null) {
            this.setTestAndSave(value);
        }
        if (value.equals(this.test)) {
            ABTestConfigStorage.getInstance().saveTest(this);
        } else {
            this.setTestAndSave(value);
        }
    }

    void initTest(T ab) {
        if (!this.isTestValid() && ab != null) {
            this.test = ab;
        }
    }

    public boolean isTestValid() {
        return this.test != null && this.test.isValid();
    }

    public T randomTest() {
        int size = this.testList.size();
        int random = (int)(Math.random() * (double)size);
        int i = 0;
        IAB abTest = null;
        for (IAB ab : this.testList) {
            if (i == random) {
                this.setTestAndSave(ab);
                return (T)ab;
            }
            abTest = ab;
        }
        return (T)abTest;
    }

    @Nullable
    public T getTest() {
        if (SystemUtils.isShowEnvSetting()) {
            MLog.info((Object)TAG, (String)"abTestId:%s, value:%s", (Object[])new Object[]{this.abTestId, this.test != null ? this.test.toString() : ""});
        }
        this.report();
        return this.test;
    }

    @Nullable
    public T getTestWithoutReport() {
        if (RuntimeContext.sIsDebuggable) {
            MLog.debug((Object)TAG, (String)"abTestId:%s, value:%s", (Object[])new Object[]{this.abTestId, this.test != null ? this.test.toString() : ""});
        }
        return this.test;
    }

    public boolean matchA(boolean report2) {
        return this.match(report2, NAB.A);
    }

    public boolean matchB(boolean report2) {
        return this.match(report2, NAB.B);
    }

    public boolean matchC(boolean report2) {
        return this.match(report2, NAB.C);
    }

    public boolean matchD(boolean report2) {
        return this.match(report2, NAB.D);
    }

    public boolean matchE(boolean report2) {
        return this.match(report2, NAB.E);
    }

    private boolean match(boolean report2, IAB abTest) {
        Object test = null;
        test = report2 ? this.getTest() : this.getTestWithoutReport();
        return abTest != null && abTest.equals(test);
    }

    private void report() {
        if (this.test != null) {
            ABTestManager.getInstance().reportLayerEvent(this.abTestId);
        }
    }

    @Deprecated
    @NonNull
    public synchronized T getTestOrDefault() {
        if (!this.isTestValid()) {
            T ab = this.defaultTest;
            if (this.defaultTest != null) {
                if (this.defaultTest instanceof RandomAB) {
                    ab = this.randomTest();
                }
                MLog.info((Object)TAG, (String)"getTestOrDefault set default test: %s", (Object[])new Object[]{ab});
            } else {
                String msg = StringUtils.formatWitUSLocal((String)"abTestId: %s, defaultTest is null, you need to init by #obtainWithDefault() with defaultTest", (Object[])new Object[]{this.abTestId});
                if (RuntimeContext.sIsDebuggable) {
                    throw new IllegalArgumentException(msg);
                }
                ab = this.randomTest();
                MLog.error((Object)TAG, (String)"random test: %s, msg: %s", (Object[])new Object[]{ab, msg});
            }
            return ab;
        }
        return this.getTest();
    }

    public String getAbTestId() {
        return this.abTestId;
    }

    public String getHiidoValue() {
        if (!this.isTestValid()) {
            return "";
        }
        return this.test.getHiidoValue();
    }

    public String getValue(String key) {
        return this.test == null ? "" : this.test.getValue(key);
    }

    public ABType getAbType() {
        if (RuntimeContext.sIsDebuggable && SettingFlags.containKey((String)this.abTestId)) {
            int type2 = SettingFlags.getIntValue((String)this.abTestId);
            return ABType.of(type2);
        }
        return this.abType;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ABConfig) {
            return this.abTestId.equals(((ABConfig)((Object)obj)).abTestId);
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return this.abTestId.hashCode();
    }

    public String toString() {
        return "ABConfig{abTestId='" + this.abTestId + '\'' + ", test=" + this.test + '}';
    }
}

