package tv.athena.live.player.statistics.threadpool

import tv.athena.live.utils.ALog
import java.util.concurrent.ExecutorService
import java.util.concurrent.ScheduledExecutorService
import java.util.concurrent.Callable
import java.util.concurrent.Future
import java.util.concurrent.TimeUnit
import java.util.concurrent.Executors
import java.util.concurrent.FutureTask
import java.util.concurrent.RunnableFuture

/**
 * create by dengqu 2020/6/3
 */
class ThreadPool private constructor() {
    private var executorService: ExecutorService? = null
    private var singleExecutorService: ExecutorService? = null
    private var scheduledExecutorService: ScheduledExecutorService? = null
    private var taskExecutor: IYYTaskExecutor? = null
    private var singleTaskExecutor: IQueueTaskExecutor? = null
    private var spareExecutor: ScheduledExecutorService? = null
    val timer = SharedThreadTimer()

    private fun getSpareExecutor(): ScheduledExecutorService? {
        return if (spareExecutor != null) {
            spareExecutor
        } else {
            synchronized(this) {
                return if (spareExecutor != null) {
                    spareExecutor
                } else {
                    spareExecutor = Executors.newScheduledThreadPool(1)
                    spareExecutor
                }
            }
        }
    }

    fun execute(runnable: Runnable?) {
        if (taskExecutor != null) {
            try {
                taskExecutor?.execute(runnable, 0L)
            } catch (var3: Throwable) {
                getSpareExecutor()!!.execute(runnable)
            }
        } else {
            executorService!!.execute(runnable)
        }
    }

    fun executeQueue(runnable: Runnable?) {
        if (singleTaskExecutor != null) {
            try {
                singleTaskExecutor?.execute(runnable, 0L)
            } catch (var3: Throwable) {
                getSpareExecutor()!!.execute(runnable)
            }
        } else {
            singleExecutorService!!.execute(runnable)
        }
    }

    fun <T> submit(callable: Callable<T?>?): Future<T?> {
        val ftask: RunnableFuture<T?> = FutureTask(callable)
        this.execute(ftask)
        return ftask
    }

    fun <T> submitQueue(callable: Callable<T?>?): Future<T?> {
        val ftask: RunnableFuture<T?> = FutureTask(callable)
        executeQueue(ftask)
        return ftask
    }

    fun shutdownNow() {
        if (executorService != null) {
            executorService?.shutdownNow()
        }
        if (singleExecutorService != null) {
            singleExecutorService?.shutdownNow()
        }
        if (scheduledExecutorService != null) {
            scheduledExecutorService?.shutdownNow()
        }
        if (spareExecutor != null) {
            spareExecutor?.shutdownNow()
            spareExecutor = null
        }
    }

    fun shutdown() {
        if (executorService != null) {
            executorService?.shutdown()
        }
        if (singleExecutorService != null) {
            singleExecutorService?.shutdown()
        }
        if (scheduledExecutorService != null) {
            scheduledExecutorService?.shutdown()
        }
        if (spareExecutor != null) {
            spareExecutor?.shutdown()
            spareExecutor = null
        }
    }

    fun execute(run: Runnable, delayMillis: Long) {
        try {
            if (taskExecutor != null) {
                try {
                    taskExecutor?.execute(run, delayMillis)
                } catch (var5: Throwable) {
                    getSpareExecutor()!!.schedule(run, delayMillis, TimeUnit.MILLISECONDS)
                }
            } else {
                scheduledExecutorService!!.schedule(run, delayMillis, TimeUnit.MILLISECONDS)
            }
        } catch (var6: Throwable) {
            ALog.e(TAG, "execute", var6)
        }
    }

    companion object {
        private val TAG = ThreadPool::class.java.simpleName
        var pool: ThreadPool? = null
            get() {
                if (field == null) {
                    val var0: Class<*> = ThreadPool::class.java
                    synchronized(ThreadPool::class.java) {
                        if (field == null) {
                            field = ThreadPool()
                        }
                    }
                }
                return field
            }
            private set
    }

    init {
        if (ExecutorProvider.iyyTaskExecutor == null) {
            executorService = Executors.newFixedThreadPool(5)
            singleExecutorService = Executors.newSingleThreadExecutor()
            scheduledExecutorService = Executors.newScheduledThreadPool(1) { r ->
                val thread = Thread(r)
                thread.priority = 1
                thread
            }
        } else {
            taskExecutor = ExecutorProvider.iyyTaskExecutor
            singleTaskExecutor = taskExecutor!!.createAQueueExcuter()
            if (singleTaskExecutor == null) {
                singleExecutorService = Executors.newSingleThreadExecutor()
            }
        }
    }
}