/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iam.model.AccessAdvisorUsageGranularityType;
import software.amazon.awssdk.services.iam.model.ErrorDetails;
import software.amazon.awssdk.services.iam.model.IamResponse;
import software.amazon.awssdk.services.iam.model.JobStatusType;
import software.amazon.awssdk.services.iam.model.ServiceLastAccessed;
import software.amazon.awssdk.services.iam.model.ServicesLastAccessedCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetServiceLastAccessedDetailsResponse
extends IamResponse
implements ToCopyableBuilder<Builder, GetServiceLastAccessedDetailsResponse> {
    private static final SdkField<String> JOB_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JobStatus").getter(GetServiceLastAccessedDetailsResponse.getter(GetServiceLastAccessedDetailsResponse::jobStatusAsString)).setter(GetServiceLastAccessedDetailsResponse.setter(Builder::jobStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobStatus").build()}).build();
    private static final SdkField<String> JOB_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JobType").getter(GetServiceLastAccessedDetailsResponse.getter(GetServiceLastAccessedDetailsResponse::jobTypeAsString)).setter(GetServiceLastAccessedDetailsResponse.setter(Builder::jobType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobType").build()}).build();
    private static final SdkField<Instant> JOB_CREATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("JobCreationDate").getter(GetServiceLastAccessedDetailsResponse.getter(GetServiceLastAccessedDetailsResponse::jobCreationDate)).setter(GetServiceLastAccessedDetailsResponse.setter(Builder::jobCreationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobCreationDate").build()}).build();
    private static final SdkField<List<ServiceLastAccessed>> SERVICES_LAST_ACCESSED_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ServicesLastAccessed").getter(GetServiceLastAccessedDetailsResponse.getter(GetServiceLastAccessedDetailsResponse::servicesLastAccessed)).setter(GetServiceLastAccessedDetailsResponse.setter(Builder::servicesLastAccessed)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServicesLastAccessed").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ServiceLastAccessed::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> JOB_COMPLETION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("JobCompletionDate").getter(GetServiceLastAccessedDetailsResponse.getter(GetServiceLastAccessedDetailsResponse::jobCompletionDate)).setter(GetServiceLastAccessedDetailsResponse.setter(Builder::jobCompletionDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobCompletionDate").build()}).build();
    private static final SdkField<Boolean> IS_TRUNCATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IsTruncated").getter(GetServiceLastAccessedDetailsResponse.getter(GetServiceLastAccessedDetailsResponse::isTruncated)).setter(GetServiceLastAccessedDetailsResponse.setter(Builder::isTruncated)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsTruncated").build()}).build();
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Marker").getter(GetServiceLastAccessedDetailsResponse.getter(GetServiceLastAccessedDetailsResponse::marker)).setter(GetServiceLastAccessedDetailsResponse.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final SdkField<ErrorDetails> ERROR_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Error").getter(GetServiceLastAccessedDetailsResponse.getter(GetServiceLastAccessedDetailsResponse::error)).setter(GetServiceLastAccessedDetailsResponse.setter(Builder::error)).constructor(ErrorDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Error").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_STATUS_FIELD, JOB_TYPE_FIELD, JOB_CREATION_DATE_FIELD, SERVICES_LAST_ACCESSED_FIELD, JOB_COMPLETION_DATE_FIELD, IS_TRUNCATED_FIELD, MARKER_FIELD, ERROR_FIELD));
    private final String jobStatus;
    private final String jobType;
    private final Instant jobCreationDate;
    private final List<ServiceLastAccessed> servicesLastAccessed;
    private final Instant jobCompletionDate;
    private final Boolean isTruncated;
    private final String marker;
    private final ErrorDetails error;

    private GetServiceLastAccessedDetailsResponse(BuilderImpl builder) {
        super(builder);
        this.jobStatus = builder.jobStatus;
        this.jobType = builder.jobType;
        this.jobCreationDate = builder.jobCreationDate;
        this.servicesLastAccessed = builder.servicesLastAccessed;
        this.jobCompletionDate = builder.jobCompletionDate;
        this.isTruncated = builder.isTruncated;
        this.marker = builder.marker;
        this.error = builder.error;
    }

    public JobStatusType jobStatus() {
        return JobStatusType.fromValue(this.jobStatus);
    }

    public String jobStatusAsString() {
        return this.jobStatus;
    }

    public AccessAdvisorUsageGranularityType jobType() {
        return AccessAdvisorUsageGranularityType.fromValue(this.jobType);
    }

    public String jobTypeAsString() {
        return this.jobType;
    }

    public Instant jobCreationDate() {
        return this.jobCreationDate;
    }

    public boolean hasServicesLastAccessed() {
        return this.servicesLastAccessed != null && !(this.servicesLastAccessed instanceof SdkAutoConstructList);
    }

    public List<ServiceLastAccessed> servicesLastAccessed() {
        return this.servicesLastAccessed;
    }

    public Instant jobCompletionDate() {
        return this.jobCompletionDate;
    }

    public Boolean isTruncated() {
        return this.isTruncated;
    }

    public String marker() {
        return this.marker;
    }

    public ErrorDetails error() {
        return this.error;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.jobStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobCreationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.servicesLastAccessed());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobCompletionDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.isTruncated());
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.error());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetServiceLastAccessedDetailsResponse)) {
            return false;
        }
        GetServiceLastAccessedDetailsResponse other = (GetServiceLastAccessedDetailsResponse)((Object)obj);
        return Objects.equals(this.jobStatusAsString(), other.jobStatusAsString()) && Objects.equals(this.jobTypeAsString(), other.jobTypeAsString()) && Objects.equals(this.jobCreationDate(), other.jobCreationDate()) && Objects.equals(this.servicesLastAccessed(), other.servicesLastAccessed()) && Objects.equals(this.jobCompletionDate(), other.jobCompletionDate()) && Objects.equals(this.isTruncated(), other.isTruncated()) && Objects.equals(this.marker(), other.marker()) && Objects.equals(this.error(), other.error());
    }

    public String toString() {
        return ToString.builder((String)"GetServiceLastAccessedDetailsResponse").add("JobStatus", (Object)this.jobStatusAsString()).add("JobType", (Object)this.jobTypeAsString()).add("JobCreationDate", (Object)this.jobCreationDate()).add("ServicesLastAccessed", this.servicesLastAccessed()).add("JobCompletionDate", (Object)this.jobCompletionDate()).add("IsTruncated", (Object)this.isTruncated()).add("Marker", (Object)this.marker()).add("Error", (Object)this.error()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "JobStatus": {
                return Optional.ofNullable(clazz.cast(this.jobStatusAsString()));
            }
            case "JobType": {
                return Optional.ofNullable(clazz.cast(this.jobTypeAsString()));
            }
            case "JobCreationDate": {
                return Optional.ofNullable(clazz.cast(this.jobCreationDate()));
            }
            case "ServicesLastAccessed": {
                return Optional.ofNullable(clazz.cast(this.servicesLastAccessed()));
            }
            case "JobCompletionDate": {
                return Optional.ofNullable(clazz.cast(this.jobCompletionDate()));
            }
            case "IsTruncated": {
                return Optional.ofNullable(clazz.cast(this.isTruncated()));
            }
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
            case "Error": {
                return Optional.ofNullable(clazz.cast(this.error()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetServiceLastAccessedDetailsResponse, T> g) {
        return obj -> g.apply((GetServiceLastAccessedDetailsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IamResponse.BuilderImpl
    implements Builder {
        private String jobStatus;
        private String jobType;
        private Instant jobCreationDate;
        private List<ServiceLastAccessed> servicesLastAccessed = DefaultSdkAutoConstructList.getInstance();
        private Instant jobCompletionDate;
        private Boolean isTruncated;
        private String marker;
        private ErrorDetails error;

        private BuilderImpl() {
        }

        private BuilderImpl(GetServiceLastAccessedDetailsResponse model) {
            super(model);
            this.jobStatus(model.jobStatus);
            this.jobType(model.jobType);
            this.jobCreationDate(model.jobCreationDate);
            this.servicesLastAccessed(model.servicesLastAccessed);
            this.jobCompletionDate(model.jobCompletionDate);
            this.isTruncated(model.isTruncated);
            this.marker(model.marker);
            this.error(model.error);
        }

        public final String getJobStatus() {
            return this.jobStatus;
        }

        @Override
        public final Builder jobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
            return this;
        }

        @Override
        public final Builder jobStatus(JobStatusType jobStatus) {
            this.jobStatus(jobStatus == null ? null : jobStatus.toString());
            return this;
        }

        public final void setJobStatus(String jobStatus) {
            this.jobStatus = jobStatus;
        }

        public final String getJobType() {
            return this.jobType;
        }

        @Override
        public final Builder jobType(String jobType) {
            this.jobType = jobType;
            return this;
        }

        @Override
        public final Builder jobType(AccessAdvisorUsageGranularityType jobType) {
            this.jobType(jobType == null ? null : jobType.toString());
            return this;
        }

        public final void setJobType(String jobType) {
            this.jobType = jobType;
        }

        public final Instant getJobCreationDate() {
            return this.jobCreationDate;
        }

        @Override
        public final Builder jobCreationDate(Instant jobCreationDate) {
            this.jobCreationDate = jobCreationDate;
            return this;
        }

        public final void setJobCreationDate(Instant jobCreationDate) {
            this.jobCreationDate = jobCreationDate;
        }

        public final Collection<ServiceLastAccessed.Builder> getServicesLastAccessed() {
            return this.servicesLastAccessed != null ? (Collection)this.servicesLastAccessed.stream().map(ServiceLastAccessed::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder servicesLastAccessed(Collection<ServiceLastAccessed> servicesLastAccessed) {
            this.servicesLastAccessed = ServicesLastAccessedCopier.copy(servicesLastAccessed);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder servicesLastAccessed(ServiceLastAccessed ... servicesLastAccessed) {
            this.servicesLastAccessed(Arrays.asList(servicesLastAccessed));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder servicesLastAccessed(Consumer<ServiceLastAccessed.Builder> ... servicesLastAccessed) {
            this.servicesLastAccessed(Stream.of(servicesLastAccessed).map(c -> (ServiceLastAccessed)((ServiceLastAccessed.Builder)ServiceLastAccessed.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setServicesLastAccessed(Collection<ServiceLastAccessed.BuilderImpl> servicesLastAccessed) {
            this.servicesLastAccessed = ServicesLastAccessedCopier.copyFromBuilder(servicesLastAccessed);
        }

        public final Instant getJobCompletionDate() {
            return this.jobCompletionDate;
        }

        @Override
        public final Builder jobCompletionDate(Instant jobCompletionDate) {
            this.jobCompletionDate = jobCompletionDate;
            return this;
        }

        public final void setJobCompletionDate(Instant jobCompletionDate) {
            this.jobCompletionDate = jobCompletionDate;
        }

        public final Boolean getIsTruncated() {
            return this.isTruncated;
        }

        @Override
        public final Builder isTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
            return this;
        }

        public final void setIsTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final ErrorDetails.Builder getError() {
            return this.error != null ? this.error.toBuilder() : null;
        }

        @Override
        public final Builder error(ErrorDetails error) {
            this.error = error;
            return this;
        }

        public final void setError(ErrorDetails.BuilderImpl error) {
            this.error = error != null ? error.build() : null;
        }

        @Override
        public GetServiceLastAccessedDetailsResponse build() {
            return new GetServiceLastAccessedDetailsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IamResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetServiceLastAccessedDetailsResponse> {
        public Builder jobStatus(String var1);

        public Builder jobStatus(JobStatusType var1);

        public Builder jobType(String var1);

        public Builder jobType(AccessAdvisorUsageGranularityType var1);

        public Builder jobCreationDate(Instant var1);

        public Builder servicesLastAccessed(Collection<ServiceLastAccessed> var1);

        public Builder servicesLastAccessed(ServiceLastAccessed ... var1);

        public Builder servicesLastAccessed(Consumer<ServiceLastAccessed.Builder> ... var1);

        public Builder jobCompletionDate(Instant var1);

        public Builder isTruncated(Boolean var1);

        public Builder marker(String var1);

        public Builder error(ErrorDetails var1);

        default public Builder error(Consumer<ErrorDetails.Builder> error) {
            return this.error((ErrorDetails)((ErrorDetails.Builder)ErrorDetails.builder().applyMutation(error)).build());
        }
    }
}

