/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.glue.model.DevEndpointNamesCopier;
import software.amazon.awssdk.services.glue.model.GlueRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchGetDevEndpointsRequest
extends GlueRequest
implements ToCopyableBuilder<Builder, BatchGetDevEndpointsRequest> {
    private static final SdkField<List<String>> DEV_ENDPOINT_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DevEndpointNames").getter(BatchGetDevEndpointsRequest.getter(BatchGetDevEndpointsRequest::devEndpointNames)).setter(BatchGetDevEndpointsRequest.setter(Builder::devEndpointNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DevEndpointNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEV_ENDPOINT_NAMES_FIELD));
    private final List<String> devEndpointNames;

    private BatchGetDevEndpointsRequest(BuilderImpl builder) {
        super(builder);
        this.devEndpointNames = builder.devEndpointNames;
    }

    public boolean hasDevEndpointNames() {
        return this.devEndpointNames != null && !(this.devEndpointNames instanceof SdkAutoConstructList);
    }

    public List<String> devEndpointNames() {
        return this.devEndpointNames;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.devEndpointNames());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetDevEndpointsRequest)) {
            return false;
        }
        BatchGetDevEndpointsRequest other = (BatchGetDevEndpointsRequest)((Object)obj);
        return Objects.equals(this.devEndpointNames(), other.devEndpointNames());
    }

    public String toString() {
        return ToString.builder((String)"BatchGetDevEndpointsRequest").add("DevEndpointNames", this.devEndpointNames()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DevEndpointNames": {
                return Optional.ofNullable(clazz.cast(this.devEndpointNames()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchGetDevEndpointsRequest, T> g) {
        return obj -> g.apply((BatchGetDevEndpointsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlueRequest.BuilderImpl
    implements Builder {
        private List<String> devEndpointNames = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetDevEndpointsRequest model) {
            super(model);
            this.devEndpointNames(model.devEndpointNames);
        }

        public final Collection<String> getDevEndpointNames() {
            return this.devEndpointNames;
        }

        @Override
        public final Builder devEndpointNames(Collection<String> devEndpointNames) {
            this.devEndpointNames = DevEndpointNamesCopier.copy(devEndpointNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder devEndpointNames(String ... devEndpointNames) {
            this.devEndpointNames(Arrays.asList(devEndpointNames));
            return this;
        }

        public final void setDevEndpointNames(Collection<String> devEndpointNames) {
            this.devEndpointNames = DevEndpointNamesCopier.copy(devEndpointNames);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchGetDevEndpointsRequest build() {
            return new BatchGetDevEndpointsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GlueRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchGetDevEndpointsRequest> {
        public Builder devEndpointNames(Collection<String> var1);

        public Builder devEndpointNames(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

