/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.util.reflector;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.robolectric.util.PerfStatsCollector;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.ReflectorClassWriter;
import org.robolectric.util.reflector.UnsafeAccess;

public class Reflector {
    private static final boolean DEBUG = false;
    private static final AtomicInteger COUNTER = new AtomicInteger();
    private static final Map<Class<?>, Constructor<?>> cache = new ConcurrentHashMap();

    public static <T> T reflector(Class<T> iClass) {
        return Reflector.reflector(iClass, null);
    }

    public static <T> T reflector(Class<T> iClass, Object target) {
        Class<?> targetClass = Reflector.determineTargetClass(iClass);
        Constructor<Object> ctor = cache.get(iClass);
        try {
            if (ctor == null) {
                Class reflectorClass = (Class)PerfStatsCollector.getInstance().measure("createReflectorClass", () -> Reflector.createReflectorClass(iClass, targetClass));
                ctor = reflectorClass.getConstructor(targetClass);
                ctor.setAccessible(true);
            }
            cache.put(iClass, ctor);
            return (T)ctor.newInstance(target);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
    }

    private static <T> Class<?> determineTargetClass(Class<T> iClass) {
        ForType forType = iClass.getAnnotation(ForType.class);
        if (forType == null) {
            String string = String.valueOf(iClass);
            throw new IllegalArgumentException(new StringBuilder(33 + String.valueOf(string).length()).append("no @ForType annotation found for ").append(string).toString());
        }
        Class<?> targetClass = forType.value();
        if (targetClass.equals(Void.TYPE)) {
            String forClassName = forType.className();
            if (forClassName.isEmpty()) {
                String string = String.valueOf(iClass);
                throw new IllegalArgumentException(new StringBuilder(45 + String.valueOf(string).length()).append("no value or className given for @ForType for ").append(string).toString());
            }
            try {
                targetClass = Class.forName(forClassName, false, iClass.getClassLoader());
            }
            catch (ClassNotFoundException e) {
                String string = String.valueOf(iClass);
                throw new IllegalArgumentException(new StringBuilder(37 + String.valueOf(string).length()).append("failed to resolve @ForType class for ").append(string).toString(), e);
            }
        }
        return targetClass;
    }

    private static <T> Class<? extends T> createReflectorClass(Class<T> iClass, Class<?> targetClass) {
        String string = iClass.getName();
        int n = COUNTER.getAndIncrement();
        String reflectorClassName = new StringBuilder(22 + String.valueOf(string).length()).append(string).append("$$Reflector").append(n).toString();
        byte[] bytecode = Reflector.getBytecode(iClass, targetClass, reflectorClassName);
        Class<?> proxyClass = Reflector.defineViaUnsafe(iClass, reflectorClassName, bytecode);
        return proxyClass.asSubclass(iClass);
    }

    private static <T> Class<?> defineViaUnsafe(Class<T> iClass, String reflectorClassName, byte[] bytecode) {
        return UnsafeAccess.defineClass(iClass, reflectorClassName, bytecode);
    }

    private static <T> Class<?> defineViaNewClassLoader(Class<T> iClass, String reflectorClassName, final byte[] bytecode) {
        Class<?> proxyClass;
        ClassLoader classLoader = new ClassLoader(iClass.getClassLoader()){

            @Override
            protected Class<?> findClass(String name) throws ClassNotFoundException {
                return this.defineClass(name, bytecode, 0, bytecode.length);
            }
        };
        try {
            proxyClass = classLoader.loadClass(reflectorClassName);
        }
        catch (ClassNotFoundException e) {
            throw new AssertionError((Object)e);
        }
        return proxyClass;
    }

    private static <T> byte[] getBytecode(Class<T> iClass, Class<?> targetClass, String reflectorClassName) {
        ReflectorClassWriter writer = new ReflectorClassWriter(iClass, targetClass, reflectorClassName);
        writer.write();
        return writer.toByteArray();
    }
}

