/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.annotation.SuppressLint;
import android.content.res.AssetManager;
import android.graphics.FontFamily;
import android.graphics.Typeface;
import android.util.ArrayMap;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.Shadows;
import org.robolectric.annotation.HiddenApi;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.annotation.Resetter;
import org.robolectric.res.Fs;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.shadows.ShadowAssetManager;
import org.robolectric.util.ReflectionHelpers;

@Implements(value=Typeface.class, looseSignatures=true)
@SuppressLint(value={"NewApi"})
public class ShadowTypeface {
    private static final Map<Long, FontDesc> FONTS = Collections.synchronizedMap(new HashMap());
    private static final AtomicLong nextFontId = new AtomicLong(1L);
    private FontDesc description;

    @HiddenApi
    @Implementation
    protected void __constructor__(int fontId) {
        this.description = ShadowTypeface.findById(fontId);
    }

    @HiddenApi
    @Implementation
    protected void __constructor__(long fontId) {
        this.description = ShadowTypeface.findById(fontId);
    }

    @Implementation
    protected static void __staticInitializer__() {
        Shadow.directInitialize(Typeface.class);
        if (RuntimeEnvironment.getApiLevel() > 30) {
            Typeface.loadPreinstalledSystemFontMap();
        }
    }

    @Implementation(minSdk=28)
    protected static Typeface create(Typeface family, int weight, boolean italic) {
        if (family == null) {
            return ShadowTypeface.createUnderlyingTypeface(null, weight);
        }
        ShadowTypeface shadowTypeface = (ShadowTypeface)Shadow.extract((Object)family);
        return ShadowTypeface.createUnderlyingTypeface(shadowTypeface.getFontDescription().getFamilyName(), weight);
    }

    @Implementation
    protected static Typeface create(String familyName, int style) {
        return ShadowTypeface.createUnderlyingTypeface(familyName, style);
    }

    @Implementation
    protected static Typeface create(Typeface family, int style) {
        if (family == null) {
            return ShadowTypeface.createUnderlyingTypeface(null, style);
        }
        ShadowTypeface shadowTypeface = (ShadowTypeface)Shadow.extract((Object)family);
        return ShadowTypeface.createUnderlyingTypeface(shadowTypeface.getFontDescription().getFamilyName(), style);
    }

    @Implementation
    protected static Typeface createFromAsset(AssetManager mgr, String path) {
        ShadowAssetManager shadowAssetManager = (ShadowAssetManager)Shadow.extract((Object)mgr);
        Collection<Path> assetDirs = shadowAssetManager.getAllAssetDirs();
        for (Path assetDir : assetDirs) {
            Path[] files;
            Path assetFile = assetDir.resolve(path);
            if (Files.exists(assetFile, new LinkOption[0])) {
                return ShadowTypeface.createUnderlyingTypeface(path, 0);
            }
            try {
                files = Fs.listFiles((Path)assetDir, f -> f.getFileName().toString().startsWith(path));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            if (files.length == 0) continue;
            return ShadowTypeface.createUnderlyingTypeface(path, 0);
        }
        String string2 = String.valueOf(path);
        throw new RuntimeException(string2.length() != 0 ? "Font asset not found ".concat(string2) : new String("Font asset not found "));
    }

    @Implementation(minSdk=26, maxSdk=28)
    protected static Typeface createFromResources(AssetManager mgr, String path, int cookie) {
        return ShadowTypeface.createUnderlyingTypeface(path, 0);
    }

    @Implementation(minSdk=26)
    protected static Typeface createFromResources(Object entry, Object mgr, Object path) {
        return ShadowTypeface.createUnderlyingTypeface((String)path, 0);
    }

    @Implementation
    protected static Typeface createFromFile(File path) {
        String familyName = path.toPath().getFileName().toString();
        return ShadowTypeface.createUnderlyingTypeface(familyName, 0);
    }

    @Implementation
    protected static Typeface createFromFile(String path) {
        return ShadowTypeface.createFromFile(new File(path));
    }

    @Implementation
    protected int getStyle() {
        return this.description.getStyle();
    }

    @Implementation
    public boolean equals(Object o) {
        if (o instanceof Typeface) {
            Typeface other = (Typeface)o;
            return Objects.equals(this.getFontDescription(), Shadows.shadowOf(other).getFontDescription());
        }
        return false;
    }

    @Implementation
    public int hashCode() {
        return this.getFontDescription().hashCode();
    }

    @HiddenApi
    @Implementation(minSdk=21)
    protected static Typeface createFromFamilies(Object families) {
        return null;
    }

    @HiddenApi
    @Implementation(minSdk=21, maxSdk=25)
    protected static Typeface createFromFamiliesWithDefault(Object families) {
        return null;
    }

    @Implementation(minSdk=26, maxSdk=27)
    protected static Typeface createFromFamiliesWithDefault(Object families, Object weight, Object italic) {
        return ShadowTypeface.createUnderlyingTypeface("fake-font", 0);
    }

    @Implementation(minSdk=28)
    protected static Typeface createFromFamiliesWithDefault(Object families, Object fallbackName, Object weight, Object italic) {
        return ShadowTypeface.createUnderlyingTypeface((String)fallbackName, 0);
    }

    @Implementation(minSdk=28, maxSdk=28)
    protected static void buildSystemFallback(String xmlPath, String fontDir, ArrayMap<String, Typeface> fontMap, ArrayMap<String, FontFamily[]> fallbackMap) {
        fontMap.put((Object)"sans-serif", (Object)ShadowTypeface.createUnderlyingTypeface("sans-serif", 0));
    }

    @Implementation(minSdk=21, maxSdk=27)
    protected static void init() {
    }

    @HiddenApi
    @Implementation(minSdk=29, maxSdk=30)
    public static void initSystemDefaultTypefaces(Object systemFontMap, Object fallbacks, Object aliases) {
    }

    @Resetter
    public static synchronized void reset() {
        FONTS.clear();
    }

    protected static Typeface createUnderlyingTypeface(String familyName, int style) {
        long thisFontId = nextFontId.getAndIncrement();
        FONTS.put(thisFontId, new FontDesc(familyName, style));
        if (RuntimeEnvironment.getApiLevel() >= 21) {
            return (Typeface)ReflectionHelpers.callConstructor(Typeface.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Long.TYPE, (Object)thisFontId)});
        }
        return (Typeface)ReflectionHelpers.callConstructor(Typeface.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)((int)thisFontId))});
    }

    private static synchronized FontDesc findById(long fontId) {
        if (FONTS.containsKey(fontId)) {
            return FONTS.get(fontId);
        }
        throw new RuntimeException(new StringBuilder(37).append("Unknown font id: ").append(fontId).toString());
    }

    @Implementation(minSdk=26, maxSdk=30)
    protected static long nativeCreateFromArray(long[] familyArray, int weight, int italic) {
        long thisFontId = nextFontId.getAndIncrement();
        FONTS.put(thisFontId, new FontDesc(null, weight));
        return thisFontId;
    }

    public FontDesc getFontDescription() {
        return this.description;
    }

    @Implementation(minSdk=31)
    protected static void nativeForceSetStaticFinalField(String fieldname, Typeface typeface) {
        ReflectionHelpers.setStaticField(Typeface.class, (String)fieldname, (Object)typeface);
    }

    @Implementation(minSdk=31)
    protected static long nativeCreateFromArray(long[] familyArray, long fallbackTypeface, int weight, int italic) {
        return ShadowTypeface.nativeCreateFromArray(familyArray, weight, italic);
    }

    @Implements(value=Typeface.Builder.class, minSdk=29)
    public static class ShadowBuilder {
        @RealObject
        Typeface.Builder realBuilder;

        @Implementation
        protected Typeface build() {
            String path = (String)ReflectionHelpers.getField((Object)this.realBuilder, (String)"mPath");
            return ShadowTypeface.createUnderlyingTypeface(path, 0);
        }
    }

    public static class FontDesc {
        public final String familyName;
        public final int style;

        public FontDesc(String familyName, int style) {
            this.familyName = familyName;
            this.style = style;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof FontDesc)) {
                return false;
            }
            FontDesc fontDesc = (FontDesc)o;
            if (this.style != fontDesc.style) {
                return false;
            }
            return !(this.familyName != null ? !this.familyName.equals(fontDesc.familyName) : fontDesc.familyName != null);
        }

        public int hashCode() {
            int result = this.familyName != null ? this.familyName.hashCode() : 0;
            result = 31 * result + this.style;
            return result;
        }

        public String getFamilyName() {
            return this.familyName;
        }

        public int getStyle() {
            return this.style;
        }
    }
}

