/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.content.ClipData;
import android.content.ClipDescription;
import android.content.ClipboardManager;
import java.util.Collection;
import java.util.concurrent.CopyOnWriteArrayList;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.util.ReflectionHelpers;
import org.robolectric.util.reflector.Direct;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;

@Implements(value=ClipboardManager.class)
public class ShadowClipboardManager {
    @RealObject
    private ClipboardManager realClipboardManager;
    private final Collection<ClipboardManager.OnPrimaryClipChangedListener> listeners = new CopyOnWriteArrayList<ClipboardManager.OnPrimaryClipChangedListener>();
    private ClipData clip;

    @Implementation
    protected void setPrimaryClip(ClipData clip) {
        if (RuntimeEnvironment.getApiLevel() >= 24) {
            if (clip != null) {
                clip.prepareToLeaveProcess(true);
            }
        } else if (RuntimeEnvironment.getApiLevel() >= 18 && clip != null) {
            ReflectionHelpers.callInstanceMethod(ClipData.class, (Object)clip, (String)"prepareToLeaveProcess", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]);
        }
        this.clip = clip;
        for (ClipboardManager.OnPrimaryClipChangedListener listener : this.listeners) {
            listener.onPrimaryClipChanged();
        }
    }

    @Implementation
    protected ClipData getPrimaryClip() {
        return this.clip;
    }

    @Implementation
    protected ClipDescription getPrimaryClipDescription() {
        return this.clip == null ? null : this.clip.getDescription();
    }

    @Implementation
    protected boolean hasPrimaryClip() {
        return this.clip != null;
    }

    @Implementation
    protected void addPrimaryClipChangedListener(ClipboardManager.OnPrimaryClipChangedListener listener) {
        this.listeners.add(listener);
    }

    @Implementation
    protected void removePrimaryClipChangedListener(ClipboardManager.OnPrimaryClipChangedListener listener) {
        this.listeners.remove(listener);
    }

    @Implementation
    protected void setText(CharSequence text) {
        this.setPrimaryClip(ClipData.newPlainText(null, (CharSequence)text));
    }

    @Implementation
    protected boolean hasText() {
        CharSequence text = ((ClipboardManagerReflector)Reflector.reflector(ClipboardManagerReflector.class, (Object)this.realClipboardManager)).getText();
        return text != null && text.length() > 0;
    }

    @ForType(value=ClipboardManager.class)
    static interface ClipboardManagerReflector {
        @Direct
        public CharSequence getText();
    }
}

