/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.appwidget.AppWidgetHost;
import android.appwidget.AppWidgetHostView;
import android.appwidget.AppWidgetProviderInfo;
import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.RemoteViews;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.shadows.ShadowViewGroup;

@Implements(value=AppWidgetHostView.class)
public class ShadowAppWidgetHostView
extends ShadowViewGroup {
    @RealObject
    private AppWidgetHostView appWidgetHostView;
    private int appWidgetId;
    private AppWidgetProviderInfo appWidgetInfo;
    private AppWidgetHost host;
    private View view;

    @Implementation
    protected void setAppWidget(int appWidgetId, AppWidgetProviderInfo info) {
        this.appWidgetId = appWidgetId;
        this.appWidgetInfo = info;
    }

    @Implementation
    protected int getAppWidgetId() {
        return this.appWidgetId;
    }

    @Implementation
    protected AppWidgetProviderInfo getAppWidgetInfo() {
        return this.appWidgetInfo;
    }

    @Implementation
    protected void updateAppWidget(RemoteViews remoteViews) {
        if (this.view != null) {
            this.realViewGroup.removeView(this.view);
        }
        Context context = this.appWidgetHostView.getContext();
        this.view = LayoutInflater.from((Context)context).inflate(remoteViews.getLayoutId(), null);
        remoteViews.reapply(context, this.view);
        this.realViewGroup.addView(this.view);
    }

    public AppWidgetHost getHost() {
        return this.host;
    }

    public void setHost(AppWidgetHost host) {
        this.host = host;
    }
}

