/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.view.View;
import android.view.accessibility.AccessibilityNodeInfo;
import android.view.accessibility.AccessibilityRecord;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.util.reflector.Direct;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;

@Implements(value=AccessibilityRecord.class)
public class ShadowAccessibilityRecord {
    @RealObject
    private AccessibilityRecord realRecord;
    public static final int NO_VIRTUAL_ID = -1;
    private View sourceRoot;
    private int virtualDescendantId;
    private AccessibilityNodeInfo sourceNode;
    private int windowId = -1;

    @Implementation
    protected void init(AccessibilityRecord model) {
        ShadowAccessibilityRecord modelShadow = (ShadowAccessibilityRecord)Shadow.extract((Object)model);
        this.sourceRoot = modelShadow.sourceRoot;
        this.virtualDescendantId = modelShadow.virtualDescendantId;
        this.sourceNode = modelShadow.sourceNode;
        this.windowId = modelShadow.windowId;
        ((AccessibilityRecordReflector)Reflector.reflector(AccessibilityRecordReflector.class, (Object)this.realRecord)).init(model);
    }

    @Implementation
    protected void setSource(View root, int virtualDescendantId) {
        this.sourceRoot = root;
        this.virtualDescendantId = virtualDescendantId;
        ((AccessibilityRecordReflector)Reflector.reflector(AccessibilityRecordReflector.class, (Object)this.realRecord)).setSource(root, virtualDescendantId);
    }

    @Implementation
    protected void setSource(View root) {
        this.sourceRoot = root;
        this.virtualDescendantId = -1;
        ((AccessibilityRecordReflector)Reflector.reflector(AccessibilityRecordReflector.class, (Object)this.realRecord)).setSource(root);
    }

    public void setSourceNode(AccessibilityNodeInfo node) {
        this.sourceNode = node;
    }

    @Implementation
    protected AccessibilityNodeInfo getSource() {
        if (this.sourceNode == null) {
            return null;
        }
        return AccessibilityNodeInfo.obtain((AccessibilityNodeInfo)this.sourceNode);
    }

    public void setWindowId(int id2) {
        this.windowId = id2;
    }

    @Implementation
    protected int getWindowId() {
        return this.windowId;
    }

    public View getSourceRoot() {
        return this.sourceRoot;
    }

    public int getVirtualDescendantId() {
        return this.virtualDescendantId;
    }

    @ForType(value=AccessibilityRecord.class)
    static interface AccessibilityRecordReflector {
        @Direct
        public void setSource(View var1, int var2);

        @Direct
        public void setSource(View var1);

        @Direct
        public void init(AccessibilityRecord var1);
    }
}

