/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.res;

import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.robolectric.res.ResName;

public class AttributeResource {
    public static final String ANDROID_NS = "http://schemas.android.com/apk/res/android";
    public static final String ANDROID_RES_NS_PREFIX = "http://schemas.android.com/apk/res/";
    public static final String RES_AUTO_NS_URI = "http://schemas.android.com/apk/res-auto";
    public static final String NULL_VALUE = "@null";
    public static final String EMPTY_VALUE = "@empty";
    public static final Pattern IS_RESOURCE_REFERENCE = Pattern.compile("^\\s*@");
    @Nonnull
    public final ResName resName;
    @Nonnull
    public final String value;
    @Nonnull
    public final String trimmedValue;
    @Nonnull
    public final String contextPackageName;
    private final Integer referenceResId;

    public AttributeResource(@Nonnull ResName resName, @Nonnull String value, @Nonnull String contextPackageName) {
        this(resName, value, contextPackageName, null);
    }

    public AttributeResource(@Nonnull ResName resName, @Nonnull String value, @Nonnull String contextPackageName, Integer referenceResId) {
        this.referenceResId = referenceResId;
        if (!resName.type.equals("attr")) {
            String string = resName.getFullyQualifiedName();
            throw new IllegalStateException(new StringBuilder(13 + String.valueOf(string).length()).append("\"").append(string).append("\" unexpected").toString());
        }
        this.resName = resName;
        this.value = value;
        this.trimmedValue = value.trim();
        this.contextPackageName = contextPackageName;
    }

    public boolean isResourceReference() {
        return AttributeResource.isResourceReference(this.trimmedValue);
    }

    @Nonnull
    public ResName getResourceReference() {
        if (!this.isResourceReference()) {
            String string = String.valueOf(this);
            throw new RuntimeException(new StringBuilder(26 + String.valueOf(string).length()).append("not a resource reference: ").append(string).toString());
        }
        return ResName.qualifyResName(AttributeResource.deref(this.trimmedValue).replace("+", ""), this.contextPackageName, "style");
    }

    public boolean isStyleReference() {
        return AttributeResource.isStyleReference(this.trimmedValue);
    }

    public ResName getStyleReference() {
        if (!this.isStyleReference()) {
            String string = String.valueOf(this);
            throw new RuntimeException(new StringBuilder(23 + String.valueOf(string).length()).append("not a style reference: ").append(string).toString());
        }
        return ResName.qualifyResName(this.value.substring(1), this.contextPackageName, "attr");
    }

    public boolean isNull() {
        return NULL_VALUE.equals(this.trimmedValue);
    }

    public boolean isEmpty() {
        return EMPTY_VALUE.equals(this.trimmedValue);
    }

    public String toString() {
        String string = String.valueOf(this.resName);
        String string2 = this.value;
        String string3 = this.contextPackageName;
        return new StringBuilder(51 + String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(string3).length()).append("Attribute{name='").append(string).append('\'').append(", value='").append(string2).append('\'').append(", contextPackageName='").append(string3).append('\'').append('}').toString();
    }

    public static boolean isResourceReference(String value) {
        return IS_RESOURCE_REFERENCE.matcher(value).find() && !AttributeResource.isNull(value);
    }

    @Nonnull
    public static ResName getResourceReference(String value, String defPackage, String defType) {
        if (!AttributeResource.isResourceReference(value)) {
            String string = String.valueOf(value);
            throw new IllegalArgumentException(string.length() != 0 ? "not a resource reference: ".concat(string) : new String("not a resource reference: "));
        }
        return ResName.qualifyResName(AttributeResource.deref(value).replace("+", ""), defPackage, defType);
    }

    @Nonnull
    private static String deref(@Nonnull String value) {
        return value.substring(value.indexOf(64) + 1);
    }

    public static boolean isStyleReference(String value) {
        return value.startsWith("?");
    }

    public static ResName getStyleReference(String value, String defPackage, String defType) {
        if (!AttributeResource.isStyleReference(value)) {
            String string = String.valueOf(value);
            throw new IllegalArgumentException(string.length() != 0 ? "not a style reference: ".concat(string) : new String("not a style reference: "));
        }
        return ResName.qualifyResName(value.substring(1), defPackage, defType);
    }

    public static boolean isNull(String value) {
        return NULL_VALUE.equals(value);
    }

    public static boolean isEmpty(String value) {
        return EMPTY_VALUE.equals(value);
    }

    public Integer getReferenceResId() {
        return this.referenceResId;
    }
}

