/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.pluginapi.perf;

public class Metric {
    private final String name;
    private int count;
    private long elapsedNs;
    private long minNs;
    private long maxNs;
    private final boolean success;

    public Metric(String name, int count, int elapsedNs, boolean success) {
        this.name = name;
        this.count = count;
        this.elapsedNs = elapsedNs;
        this.success = success;
    }

    public Metric(String name, boolean success) {
        this(name, 0, 0, success);
    }

    public String getName() {
        return this.name;
    }

    public int getCount() {
        return this.count;
    }

    public long getElapsedNs() {
        return this.elapsedNs;
    }

    public long getMinNs() {
        return this.minNs;
    }

    public long getMaxNs() {
        return this.maxNs;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public void record(long elapsedNs) {
        if (this.count == 0 || elapsedNs < this.minNs) {
            this.minNs = elapsedNs;
        }
        if (elapsedNs > this.maxNs) {
            this.maxNs = elapsedNs;
        }
        this.elapsedNs += elapsedNs;
        ++this.count;
    }

    public void incrementCount() {
        ++this.count;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Metric metric = (Metric)o;
        if (this.success != metric.success) {
            return false;
        }
        return this.name != null ? this.name.equals(metric.name) : metric.name == null;
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.success ? 1 : 0);
        return result;
    }

    public String toString() {
        String string = this.name;
        int n = this.count;
        long l = this.minNs;
        long l2 = this.maxNs;
        long l3 = this.elapsedNs;
        boolean bl = this.success;
        return new StringBuilder(137 + String.valueOf(string).length()).append("Metric{name='").append(string).append('\'').append(", count=").append(n).append(", minNs=").append(l).append(", maxNs=").append(l2).append(", elapsedNs=").append(l3).append(", success=").append(bl).append('}').toString();
    }
}

