/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.persist.nontx;

import com.google.common.base.Preconditions;
import com.google.protobuf.ByteString;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.projectnessie.versioned.BranchName;
import org.projectnessie.versioned.GetNamedRefsParams;
import org.projectnessie.versioned.Hash;
import org.projectnessie.versioned.Key;
import org.projectnessie.versioned.NamedRef;
import org.projectnessie.versioned.ReferenceAlreadyExistsException;
import org.projectnessie.versioned.ReferenceConflictException;
import org.projectnessie.versioned.ReferenceInfo;
import org.projectnessie.versioned.ReferenceNotFoundException;
import org.projectnessie.versioned.TagName;
import org.projectnessie.versioned.VersionStoreException;
import org.projectnessie.versioned.persist.adapter.CommitAttempt;
import org.projectnessie.versioned.persist.adapter.CommitLogEntry;
import org.projectnessie.versioned.persist.adapter.ContentAndState;
import org.projectnessie.versioned.persist.adapter.ContentId;
import org.projectnessie.versioned.persist.adapter.ContentIdAndBytes;
import org.projectnessie.versioned.persist.adapter.ContentIdWithType;
import org.projectnessie.versioned.persist.adapter.DatabaseAdapterConfig;
import org.projectnessie.versioned.persist.adapter.Difference;
import org.projectnessie.versioned.persist.adapter.KeyFilterPredicate;
import org.projectnessie.versioned.persist.adapter.KeyWithType;
import org.projectnessie.versioned.persist.adapter.spi.AbstractDatabaseAdapter;
import org.projectnessie.versioned.persist.adapter.spi.DatabaseAdapterUtil;
import org.projectnessie.versioned.persist.adapter.spi.TryLoopState;
import org.projectnessie.versioned.persist.nontx.NonTransactionalDatabaseAdapterConfig;
import org.projectnessie.versioned.persist.nontx.NonTransactionalOperationContext;
import org.projectnessie.versioned.persist.serialize.AdapterTypes;
import org.projectnessie.versioned.persist.serialize.ProtoSerialization;

public abstract class NonTransactionalDatabaseAdapter<CONFIG extends NonTransactionalDatabaseAdapterConfig>
extends AbstractDatabaseAdapter<NonTransactionalOperationContext, CONFIG> {
    protected NonTransactionalDatabaseAdapter(CONFIG config) {
        super(config);
    }

    public Hash hashOnReference(NamedRef namedReference, Optional<Hash> hashOnReference) throws ReferenceNotFoundException {
        return this.hashOnRef(NonTransactionalOperationContext.NON_TRANSACTIONAL_OPERATION_CONTEXT, namedReference, hashOnReference);
    }

    public Map<Key, ContentAndState<ByteString>> values(Hash commit, Collection<Key> keys, KeyFilterPredicate keyFilter) throws ReferenceNotFoundException {
        return this.fetchValues(NonTransactionalOperationContext.NON_TRANSACTIONAL_OPERATION_CONTEXT, commit, keys, keyFilter);
    }

    public Stream<CommitLogEntry> commitLog(Hash offset) throws ReferenceNotFoundException {
        return this.readCommitLogStream(NonTransactionalOperationContext.NON_TRANSACTIONAL_OPERATION_CONTEXT, offset);
    }

    public ReferenceInfo<ByteString> namedRef(String ref, GetNamedRefsParams params) throws ReferenceNotFoundException {
        Preconditions.checkNotNull((Object)params, (Object)"Parameter for GetNamedRefsParams must not be null");
        AdapterTypes.GlobalStatePointer pointer = this.fetchGlobalPointer(NonTransactionalOperationContext.NON_TRANSACTIONAL_OPERATION_CONTEXT);
        ReferenceInfo<ByteString> refHead = NonTransactionalDatabaseAdapter.referenceHead(pointer, ref);
        Hash defaultBranchHead = this.namedRefsDefaultBranchHead(params, pointer);
        Stream<ReferenceInfo<ByteString>> refs = Stream.of(refHead);
        return (ReferenceInfo)this.namedRefsFilterAndEnhance(NonTransactionalOperationContext.NON_TRANSACTIONAL_OPERATION_CONTEXT, params, defaultBranchHead, refs).findFirst().orElseThrow(() -> DatabaseAdapterUtil.referenceNotFound((String)ref));
    }

    public Stream<ReferenceInfo<ByteString>> namedRefs(GetNamedRefsParams params) throws ReferenceNotFoundException {
        Preconditions.checkNotNull((Object)params, (Object)"Parameter for GetNamedRefsParams must not be null.");
        Preconditions.checkArgument((boolean)NonTransactionalDatabaseAdapter.namedRefsAnyRetrieves((GetNamedRefsParams)params), (Object)"Must retrieve branches or tags or both.");
        AdapterTypes.GlobalStatePointer pointer = this.fetchGlobalPointer(NonTransactionalOperationContext.NON_TRANSACTIONAL_OPERATION_CONTEXT);
        if (pointer == null) {
            return Stream.empty();
        }
        Hash defaultBranchHead = this.namedRefsDefaultBranchHead(params, pointer);
        Stream<ReferenceInfo> refs = pointer.getNamedReferencesMap().entrySet().stream().map(r -> ReferenceInfo.of((Hash)Hash.of((ByteString)((AdapterTypes.RefPointer)r.getValue()).getHash()), (NamedRef)NonTransactionalDatabaseAdapter.toNamedRef(((AdapterTypes.RefPointer)r.getValue()).getType(), (String)r.getKey())));
        return this.namedRefsFilterAndEnhance(NonTransactionalOperationContext.NON_TRANSACTIONAL_OPERATION_CONTEXT, params, defaultBranchHead, refs);
    }

    public Stream<KeyWithType> keys(Hash commit, KeyFilterPredicate keyFilter) throws ReferenceNotFoundException {
        return this.keysForCommitEntry(NonTransactionalOperationContext.NON_TRANSACTIONAL_OPERATION_CONTEXT, commit, keyFilter);
    }

    public Hash merge(Hash from, BranchName toBranch, Optional<Hash> expectedHead) throws ReferenceNotFoundException, ReferenceConflictException {
        try {
            return this.casOpLoop((NamedRef)toBranch, CasOpVariant.COMMIT, (ctx, pointer, branchCommits, newKeyLists) -> {
                Hash toHead = NonTransactionalDatabaseAdapter.branchHead(pointer, (NamedRef)toBranch);
                long timeInMicros = this.commitTimeInMicros();
                toHead = this.mergeAttempt(ctx, timeInMicros, from, toBranch, expectedHead, toHead, branchCommits, newKeyLists);
                Hash newGlobalHead = this.writeGlobalCommit(ctx, timeInMicros, Hash.of((ByteString)pointer.getGlobalId()), Collections.emptyList());
                return this.updateNamedRef((NamedRef)toBranch, pointer, toHead, newGlobalHead);
            }, () -> DatabaseAdapterUtil.mergeConflictMessage((String)"Retry-failure", (Hash)from, (BranchName)toBranch, (Optional)expectedHead));
        }
        catch (RuntimeException | ReferenceConflictException | ReferenceNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Hash transplant(BranchName targetBranch, Optional<Hash> expectedHead, List<Hash> sequenceToTransplant) throws ReferenceNotFoundException, ReferenceConflictException {
        try {
            return this.casOpLoop((NamedRef)targetBranch, CasOpVariant.COMMIT, (ctx, pointer, branchCommits, newKeyLists) -> {
                Hash targetHead = NonTransactionalDatabaseAdapter.branchHead(pointer, (NamedRef)targetBranch);
                long timeInMicros = this.commitTimeInMicros();
                targetHead = this.transplantAttempt(ctx, timeInMicros, targetBranch, expectedHead, targetHead, sequenceToTransplant, branchCommits, newKeyLists);
                Hash newGlobalHead = this.writeGlobalCommit(ctx, timeInMicros, Hash.of((ByteString)pointer.getGlobalId()), Collections.emptyList());
                return this.updateNamedRef((NamedRef)targetBranch, pointer, targetHead, newGlobalHead);
            }, () -> DatabaseAdapterUtil.transplantConflictMessage((String)"Retry-failure", (BranchName)targetBranch, (Optional)expectedHead, (List)sequenceToTransplant));
        }
        catch (RuntimeException | ReferenceConflictException | ReferenceNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Hash commit(CommitAttempt commitAttempt) throws ReferenceConflictException, ReferenceNotFoundException {
        try {
            return this.casOpLoop((NamedRef)commitAttempt.getCommitToBranch(), CasOpVariant.COMMIT, (ctx, pointer, x, newKeyLists) -> {
                Hash branchHead = NonTransactionalDatabaseAdapter.branchHead(pointer, (NamedRef)commitAttempt.getCommitToBranch());
                long timeInMicros = this.commitTimeInMicros();
                CommitLogEntry newBranchCommit = this.commitAttempt(ctx, timeInMicros, branchHead, commitAttempt, newKeyLists);
                Hash newGlobalHead = this.writeGlobalCommit(ctx, timeInMicros, Hash.of((ByteString)pointer.getGlobalId()), commitAttempt.getGlobal().entrySet().stream().map(e -> ContentIdAndBytes.of((ContentId)((ContentId)e.getKey()), (byte)0, (ByteString)((ByteString)e.getValue()))).collect(Collectors.toList()));
                return this.updateNamedRef((NamedRef)commitAttempt.getCommitToBranch(), pointer, newBranchCommit.getHash(), newGlobalHead);
            }, () -> DatabaseAdapterUtil.commitConflictMessage((String)"Retry-Failure", (BranchName)commitAttempt.getCommitToBranch(), (Optional)commitAttempt.getExpectedHead()));
        }
        catch (RuntimeException | ReferenceConflictException | ReferenceNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Hash create(NamedRef ref, Hash target) throws ReferenceAlreadyExistsException, ReferenceNotFoundException {
        try {
            return this.casOpLoop(ref, CasOpVariant.REF_UPDATE, (ctx, pointer, branchCommits, newKeyLists) -> {
                if (pointer.getNamedReferencesMap().containsKey(ref.getName())) {
                    throw DatabaseAdapterUtil.referenceAlreadyExists((NamedRef)ref);
                }
                Hash hash = target;
                if (hash == null) {
                    hash = NO_ANCESTOR;
                }
                this.validateHashExists(ctx, hash);
                Hash newGlobalHead = this.noopGlobalLogEntry(ctx, pointer);
                return this.updateNamedRef(ref, pointer, hash, newGlobalHead);
            }, () -> DatabaseAdapterUtil.createConflictMessage((String)"Retry-Failure", (NamedRef)ref, (Hash)target));
        }
        catch (RuntimeException | ReferenceAlreadyExistsException | ReferenceNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void delete(NamedRef reference, Optional<Hash> expectedHead) throws ReferenceNotFoundException, ReferenceConflictException {
        try {
            this.casOpLoop(reference, CasOpVariant.DELETE_REF, (ctx, pointer, branchCommits, newKeyLists) -> {
                DatabaseAdapterUtil.verifyExpectedHash((Hash)NonTransactionalDatabaseAdapter.branchHead(pointer, reference), (NamedRef)reference, (Optional)expectedHead);
                Hash newGlobalHead = this.noopGlobalLogEntry(ctx, pointer);
                AdapterTypes.GlobalStatePointer.Builder newPointer = AdapterTypes.GlobalStatePointer.newBuilder().setGlobalId(newGlobalHead.asBytes());
                newPointer.putAllNamedReferences(pointer.getNamedReferencesMap());
                newPointer.removeNamedReferences(reference.getName());
                return newPointer.build();
            }, () -> DatabaseAdapterUtil.deleteConflictMessage((String)"Retry-Failure", (NamedRef)reference, (Optional)expectedHead));
        }
        catch (RuntimeException | ReferenceConflictException | ReferenceNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void assign(NamedRef assignee, Optional<Hash> expectedHead, Hash assignTo) throws ReferenceNotFoundException, ReferenceConflictException {
        try {
            this.casOpLoop(assignee, CasOpVariant.REF_UPDATE, (ctx, pointer, branchCommits, newKeyLists) -> {
                DatabaseAdapterUtil.verifyExpectedHash((Hash)NonTransactionalDatabaseAdapter.branchHead(pointer, assignee), (NamedRef)assignee, (Optional)expectedHead);
                this.validateHashExists(ctx, assignTo);
                Hash newGlobalHead = this.noopGlobalLogEntry(ctx, pointer);
                return this.updateNamedRef(assignee, pointer, assignTo, newGlobalHead);
            }, () -> DatabaseAdapterUtil.assignConflictMessage((String)"Retry-Failure", (NamedRef)assignee, (Optional)expectedHead, (Hash)assignTo));
        }
        catch (RuntimeException | ReferenceConflictException | ReferenceNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Stream<Difference> diff(Hash from, Hash to, KeyFilterPredicate keyFilter) throws ReferenceNotFoundException {
        return this.buildDiff(NonTransactionalOperationContext.NON_TRANSACTIONAL_OPERATION_CONTEXT, from, to, keyFilter);
    }

    public void initializeRepo(String defaultBranchName) {
        NonTransactionalOperationContext ctx = NonTransactionalOperationContext.NON_TRANSACTIONAL_OPERATION_CONTEXT;
        if (this.fetchGlobalPointer(ctx) == null) {
            Hash globalHead;
            try {
                long timeInMicros = this.commitTimeInMicros();
                globalHead = this.writeGlobalCommit(ctx, timeInMicros, NO_ANCESTOR, Collections.emptyList());
            }
            catch (ReferenceConflictException e) {
                throw new RuntimeException(e);
            }
            this.unsafeWriteGlobalPointer(ctx, AdapterTypes.GlobalStatePointer.newBuilder().setGlobalId(globalHead.asBytes()).putNamedReferences(defaultBranchName, AdapterTypes.RefPointer.newBuilder().setType(AdapterTypes.RefPointer.Type.Branch).setHash(NO_ANCESTOR.asBytes()).build()).build());
        }
    }

    public Stream<ContentIdWithType> globalKeys(ToIntFunction<ByteString> contentTypeExtractor) {
        NonTransactionalOperationContext ctx = NonTransactionalOperationContext.NON_TRANSACTIONAL_OPERATION_CONTEXT;
        AdapterTypes.GlobalStatePointer pointer = this.fetchGlobalPointer(ctx);
        if (pointer == null) {
            return Stream.empty();
        }
        return this.globalLogFetcher(ctx, Hash.of((ByteString)pointer.getGlobalId())).flatMap(e -> e.getPutsList().stream()).map(ProtoSerialization::protoToContentIdAndBytes).map(ContentIdAndBytes::asIdWithType).distinct();
    }

    public Optional<ContentIdAndBytes> globalContent(ContentId contentId, ToIntFunction<ByteString> contentTypeExtractor) {
        NonTransactionalOperationContext ctx = NonTransactionalOperationContext.NON_TRANSACTIONAL_OPERATION_CONTEXT;
        AdapterTypes.GlobalStatePointer pointer = this.fetchGlobalPointer(ctx);
        if (pointer == null) {
            return Optional.empty();
        }
        return this.globalLogFetcher(ctx, Hash.of((ByteString)pointer.getGlobalId())).flatMap(e -> e.getPutsList().stream()).map(ProtoSerialization::protoToContentIdAndBytes).filter(entry -> contentId.equals(entry.getContentId())).map(cb -> ContentIdAndBytes.of((ContentId)cb.getContentId(), (byte)((byte)contentTypeExtractor.applyAsInt(cb.getValue())), (ByteString)cb.getValue())).findFirst();
    }

    public Stream<ContentIdAndBytes> globalContent(Set<ContentId> keys, ToIntFunction<ByteString> contentTypeExtractor) {
        NonTransactionalOperationContext ctx = NonTransactionalOperationContext.NON_TRANSACTIONAL_OPERATION_CONTEXT;
        AdapterTypes.GlobalStatePointer pointer = this.fetchGlobalPointer(ctx);
        if (pointer == null) {
            return Stream.empty();
        }
        HashSet<ContentId> remaining = new HashSet<ContentId>(keys);
        Stream<AdapterTypes.GlobalStateLogEntry> stream = this.globalLogFetcher(ctx, Hash.of((ByteString)pointer.getGlobalId()));
        return DatabaseAdapterUtil.takeUntilIncludeLast(stream, x -> remaining.isEmpty()).flatMap(e -> e.getPutsList().stream()).map(ProtoSerialization::protoToContentIdAndBytes).filter(kct -> remaining.remove(kct.getContentId()));
    }

    protected AdapterTypes.GlobalStatePointer updateNamedRef(NamedRef target, AdapterTypes.GlobalStatePointer pointer, Hash toHead, Hash newGlobalHead) {
        AdapterTypes.GlobalStatePointer.Builder newPointer = AdapterTypes.GlobalStatePointer.newBuilder().setGlobalId(newGlobalHead.asBytes());
        newPointer.putAllNamedReferences(pointer.getNamedReferencesMap());
        newPointer.putNamedReferences(target.getName(), AdapterTypes.RefPointer.newBuilder().setType(this.protoTypeForRef(target)).setHash(toHead.asBytes()).build());
        return newPointer.build();
    }

    protected AdapterTypes.RefPointer.Type protoTypeForRef(NamedRef target) {
        AdapterTypes.RefPointer.Type type;
        if (target instanceof BranchName) {
            type = AdapterTypes.RefPointer.Type.Branch;
        } else if (target instanceof TagName) {
            type = AdapterTypes.RefPointer.Type.Tag;
        } else {
            throw new IllegalArgumentException(target.getClass().getSimpleName());
        }
        return type;
    }

    protected static NamedRef toNamedRef(AdapterTypes.RefPointer.Type type, String name) {
        switch (type) {
            case Branch: {
                return BranchName.of((String)name);
            }
            case Tag: {
                return TagName.of((String)name);
            }
        }
        throw new IllegalArgumentException(type.name());
    }

    protected Hash hashOnRef(NonTransactionalOperationContext ctx, NamedRef reference, Optional<Hash> hashOnRef) throws ReferenceNotFoundException {
        return this.hashOnRef(ctx, reference, hashOnRef, this.fetchGlobalPointer(ctx));
    }

    protected Hash hashOnRef(NonTransactionalOperationContext ctx, NamedRef reference, Optional<Hash> hashOnRef, AdapterTypes.GlobalStatePointer pointer) throws ReferenceNotFoundException {
        return this.hashOnRef(ctx, reference, hashOnRef, NonTransactionalDatabaseAdapter.branchHead(pointer, reference));
    }

    protected Hash casOpLoop(NamedRef ref, CasOpVariant opVariant, CasOp casOp, Supplier<String> retryErrorMessage) throws VersionStoreException {
        NonTransactionalOperationContext ctx = NonTransactionalOperationContext.NON_TRANSACTIONAL_OPERATION_CONTEXT;
        try (TryLoopState tryState = TryLoopState.newTryLoopState(retryErrorMessage, (DatabaseAdapterConfig)this.config);){
            while (true) {
                Hash branchHead;
                AdapterTypes.GlobalStatePointer pointer;
                if ((pointer = this.fetchGlobalPointer(ctx)) == null) {
                    throw DatabaseAdapterUtil.referenceNotFound((NamedRef)ref);
                }
                HashSet<Hash> individualCommits = new HashSet<Hash>();
                HashSet<Hash> individualKeyLists = new HashSet<Hash>();
                AdapterTypes.GlobalStatePointer newPointer = casOp.apply(ctx, pointer, individualCommits::add, individualKeyLists::add);
                if (newPointer.getGlobalId().equals((Object)pointer.getGlobalId())) {
                    Hash hash = tryState.success(NonTransactionalDatabaseAdapter.branchHead(pointer, ref));
                    return hash;
                }
                Hash hash = branchHead = opVariant.deleteRef ? null : NonTransactionalDatabaseAdapter.branchHead(newPointer, ref);
                if (pointer.getGlobalId().equals((Object)newPointer.getGlobalId())) {
                    throw DatabaseAdapterUtil.hashCollisionDetected();
                }
                if (this.globalPointerCas(ctx, pointer, newPointer)) {
                    Hash hash2 = tryState.success(branchHead);
                    return hash2;
                }
                if (opVariant.commitOp) {
                    if (branchHead != null) {
                        individualCommits.add(branchHead);
                    }
                    this.cleanUpCommitCas(ctx, Hash.of((ByteString)newPointer.getGlobalId()), individualCommits, individualKeyLists);
                }
                tryState.retry();
            }
        }
    }

    protected abstract void writeGlobalCommit(NonTransactionalOperationContext var1, AdapterTypes.GlobalStateLogEntry var2) throws ReferenceConflictException;

    protected abstract void unsafeWriteGlobalPointer(NonTransactionalOperationContext var1, AdapterTypes.GlobalStatePointer var2);

    protected Hash writeGlobalCommit(NonTransactionalOperationContext ctx, long timeInMicros, Hash parentHash, List<ContentIdAndBytes> globals) throws ReferenceConflictException {
        AdapterTypes.GlobalStateLogEntry currentEntry = this.fetchFromGlobalLog(ctx, parentHash);
        Stream<Hash> newParents = Stream.of(parentHash);
        if (currentEntry != null) {
            newParents = Stream.concat(newParents, currentEntry.getParentsList().stream().limit(((NonTransactionalDatabaseAdapterConfig)this.config).getParentsPerGlobalCommit() - 1).map(Hash::of));
        }
        Hash hash = DatabaseAdapterUtil.randomHash();
        AdapterTypes.GlobalStateLogEntry.Builder entry = AdapterTypes.GlobalStateLogEntry.newBuilder().setCreatedTime(timeInMicros).setId(hash.asBytes());
        newParents.forEach(p -> entry.addParents(p.asBytes()));
        globals.forEach(g -> entry.addPuts(ProtoSerialization.toProto((ContentIdAndBytes)g)));
        this.writeGlobalCommit(ctx, entry.build());
        return hash;
    }

    protected abstract boolean globalPointerCas(NonTransactionalOperationContext var1, AdapterTypes.GlobalStatePointer var2, AdapterTypes.GlobalStatePointer var3);

    protected abstract void cleanUpCommitCas(NonTransactionalOperationContext var1, Hash var2, Set<Hash> var3, Set<Hash> var4);

    protected Hash noopGlobalLogEntry(NonTransactionalOperationContext ctx, AdapterTypes.GlobalStatePointer pointer) throws ReferenceConflictException {
        return this.writeGlobalCommit(ctx, this.commitTimeInMicros(), Hash.of((ByteString)pointer.getGlobalId()), Collections.emptyList());
    }

    protected static Hash branchHead(AdapterTypes.GlobalStatePointer pointer, NamedRef ref) throws ReferenceNotFoundException {
        if (pointer == null) {
            throw DatabaseAdapterUtil.referenceNotFound((NamedRef)ref);
        }
        AdapterTypes.RefPointer branchHead = (AdapterTypes.RefPointer)pointer.getNamedReferencesMap().get(ref.getName());
        if (branchHead == null || !ref.equals(NonTransactionalDatabaseAdapter.toNamedRef(branchHead.getType(), ref.getName()))) {
            throw DatabaseAdapterUtil.referenceNotFound((NamedRef)ref);
        }
        return Hash.of((ByteString)branchHead.getHash());
    }

    protected static ReferenceInfo<ByteString> referenceHead(AdapterTypes.GlobalStatePointer pointer, String ref) throws ReferenceNotFoundException {
        if (pointer == null) {
            throw DatabaseAdapterUtil.referenceNotFound((String)ref);
        }
        AdapterTypes.RefPointer head = (AdapterTypes.RefPointer)pointer.getNamedReferencesMap().get(ref);
        if (head == null) {
            throw DatabaseAdapterUtil.referenceNotFound((String)ref);
        }
        return ReferenceInfo.of((Hash)Hash.of((ByteString)head.getHash()), (NamedRef)NonTransactionalDatabaseAdapter.toNamedRef(head.getType(), ref));
    }

    private Hash namedRefsDefaultBranchHead(GetNamedRefsParams params, AdapterTypes.GlobalStatePointer pointer) throws ReferenceNotFoundException {
        if (NonTransactionalDatabaseAdapter.namedRefsRequiresBaseReference((GetNamedRefsParams)params)) {
            Preconditions.checkNotNull((Object)params.getBaseReference(), (Object)"Base reference name missing.");
            return NonTransactionalDatabaseAdapter.branchHead(pointer, params.getBaseReference());
        }
        return null;
    }

    protected abstract AdapterTypes.GlobalStatePointer fetchGlobalPointer(NonTransactionalOperationContext var1);

    protected Map<ContentId, ByteString> fetchGlobalStates(NonTransactionalOperationContext ctx, Set<ContentId> contentIds) {
        if (contentIds.isEmpty()) {
            return Collections.emptyMap();
        }
        HashSet<ContentId> remainingIds = new HashSet<ContentId>(contentIds);
        AdapterTypes.GlobalStatePointer pointer = this.fetchGlobalPointer(ctx);
        if (pointer == null) {
            return Collections.emptyMap();
        }
        Hash globalHead = Hash.of((ByteString)pointer.getGlobalId());
        Stream<AdapterTypes.GlobalStateLogEntry> log = this.globalLogFetcher(ctx, globalHead);
        return DatabaseAdapterUtil.takeUntilExcludeLast(log, x -> remainingIds.isEmpty()).flatMap(e -> e.getPutsList().stream()).filter(put -> remainingIds.remove(ContentId.of((String)put.getContentId().getId()))).collect(Collectors.toMap(e -> ContentId.of((String)e.getContentId().getId()), AdapterTypes.ContentIdWithBytes::getValue));
    }

    private Stream<AdapterTypes.GlobalStateLogEntry> globalLogFetcher(NonTransactionalOperationContext ctx, Hash initialId) {
        AdapterTypes.GlobalStateLogEntry initial = this.fetchFromGlobalLog(ctx, initialId);
        if (initial == null) {
            throw new RuntimeException(new ReferenceNotFoundException(String.format("Global log entry '%s' not does not exist.", initialId.asString())));
        }
        Spliterator split = this.logFetcher(ctx, initial, this::fetchPageFromGlobalLog, e -> e.getParentsList().stream().map(Hash::of).collect(Collectors.toList()));
        return StreamSupport.stream(split, false);
    }

    protected abstract AdapterTypes.GlobalStateLogEntry fetchFromGlobalLog(NonTransactionalOperationContext var1, Hash var2);

    protected abstract List<AdapterTypes.GlobalStateLogEntry> fetchPageFromGlobalLog(NonTransactionalOperationContext var1, List<Hash> var2);

    static enum CasOpVariant {
        COMMIT(false, true),
        REF_UPDATE(false, false),
        DELETE_REF(true, false);

        final boolean deleteRef;
        final boolean commitOp;

        private CasOpVariant(boolean deleteRef, boolean commitOp) {
            this.deleteRef = deleteRef;
            this.commitOp = commitOp;
        }
    }

    @FunctionalInterface
    public static interface CasOp {
        public AdapterTypes.GlobalStatePointer apply(NonTransactionalOperationContext var1, AdapterTypes.GlobalStatePointer var2, Consumer<Hash> var3, Consumer<Hash> var4) throws VersionStoreException;
    }
}

