/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.persist.nontx;

import com.google.common.base.MoreObjects;
import com.google.common.primitives.Longs;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.time.Clock;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.versioned.persist.adapter.DatabaseAdapterConfig;
import org.projectnessie.versioned.persist.nontx.AdjustableNonTransactionalDatabaseAdapterConfig;
import org.projectnessie.versioned.persist.nontx.NonTransactionalDatabaseAdapterConfig;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="AdjustableNonTransactionalDatabaseAdapterConfig", generator="Immutables")
@Immutable
public final class ImmutableAdjustableNonTransactionalDatabaseAdapterConfig
implements AdjustableNonTransactionalDatabaseAdapterConfig {
    private final String repositoryId;
    private final int parentsPerCommit;
    private final int keyListDistance;
    private final int maxKeyListSize;
    private final long commitTimeout;
    private final int commitRetries;
    private final Clock clock;
    private final int parentsPerGlobalCommit;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableAdjustableNonTransactionalDatabaseAdapterConfig(Builder builder) {
        if (builder.repositoryId != null) {
            this.initShim.repositoryId(builder.repositoryId);
        }
        if (builder.parentsPerCommitIsSet()) {
            this.initShim.parentsPerCommit(builder.parentsPerCommit);
        }
        if (builder.keyListDistanceIsSet()) {
            this.initShim.keyListDistance(builder.keyListDistance);
        }
        if (builder.maxKeyListSizeIsSet()) {
            this.initShim.maxKeyListSize(builder.maxKeyListSize);
        }
        if (builder.commitTimeoutIsSet()) {
            this.initShim.commitTimeout(builder.commitTimeout);
        }
        if (builder.commitRetriesIsSet()) {
            this.initShim.commitRetries(builder.commitRetries);
        }
        if (builder.clock != null) {
            this.initShim.clock(builder.clock);
        }
        if (builder.parentsPerGlobalCommitIsSet()) {
            this.initShim.parentsPerGlobalCommit(builder.parentsPerGlobalCommit);
        }
        this.repositoryId = this.initShim.getRepositoryId();
        this.parentsPerCommit = this.initShim.getParentsPerCommit();
        this.keyListDistance = this.initShim.getKeyListDistance();
        this.maxKeyListSize = this.initShim.getMaxKeyListSize();
        this.commitTimeout = this.initShim.getCommitTimeout();
        this.commitRetries = this.initShim.getCommitRetries();
        this.clock = this.initShim.getClock();
        this.parentsPerGlobalCommit = this.initShim.getParentsPerGlobalCommit();
        this.initShim = null;
    }

    private ImmutableAdjustableNonTransactionalDatabaseAdapterConfig(String repositoryId, int parentsPerCommit, int keyListDistance, int maxKeyListSize, long commitTimeout, int commitRetries, Clock clock, int parentsPerGlobalCommit) {
        this.repositoryId = repositoryId;
        this.parentsPerCommit = parentsPerCommit;
        this.keyListDistance = keyListDistance;
        this.maxKeyListSize = maxKeyListSize;
        this.commitTimeout = commitTimeout;
        this.commitRetries = commitRetries;
        this.clock = clock;
        this.parentsPerGlobalCommit = parentsPerGlobalCommit;
        this.initShim = null;
    }

    private String getRepositoryIdInitialize() {
        return AdjustableNonTransactionalDatabaseAdapterConfig.super.getRepositoryId();
    }

    private int getParentsPerCommitInitialize() {
        return AdjustableNonTransactionalDatabaseAdapterConfig.super.getParentsPerCommit();
    }

    private int getKeyListDistanceInitialize() {
        return AdjustableNonTransactionalDatabaseAdapterConfig.super.getKeyListDistance();
    }

    private int getMaxKeyListSizeInitialize() {
        return AdjustableNonTransactionalDatabaseAdapterConfig.super.getMaxKeyListSize();
    }

    private long getCommitTimeoutInitialize() {
        return AdjustableNonTransactionalDatabaseAdapterConfig.super.getCommitTimeout();
    }

    private int getCommitRetriesInitialize() {
        return AdjustableNonTransactionalDatabaseAdapterConfig.super.getCommitRetries();
    }

    private Clock getClockInitialize() {
        return AdjustableNonTransactionalDatabaseAdapterConfig.super.getClock();
    }

    private int getParentsPerGlobalCommitInitialize() {
        return AdjustableNonTransactionalDatabaseAdapterConfig.super.getParentsPerGlobalCommit();
    }

    public String getRepositoryId() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getRepositoryId() : this.repositoryId;
    }

    public int getParentsPerCommit() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getParentsPerCommit() : this.parentsPerCommit;
    }

    public int getKeyListDistance() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getKeyListDistance() : this.keyListDistance;
    }

    public int getMaxKeyListSize() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getMaxKeyListSize() : this.maxKeyListSize;
    }

    public long getCommitTimeout() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getCommitTimeout() : this.commitTimeout;
    }

    public int getCommitRetries() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getCommitRetries() : this.commitRetries;
    }

    public Clock getClock() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getClock() : this.clock;
    }

    @Override
    public int getParentsPerGlobalCommit() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getParentsPerGlobalCommit() : this.parentsPerGlobalCommit;
    }

    public final ImmutableAdjustableNonTransactionalDatabaseAdapterConfig withRepositoryId(String value) {
        String newValue = Objects.requireNonNull(value, "repositoryId");
        if (this.repositoryId.equals(newValue)) {
            return this;
        }
        return new ImmutableAdjustableNonTransactionalDatabaseAdapterConfig(newValue, this.parentsPerCommit, this.keyListDistance, this.maxKeyListSize, this.commitTimeout, this.commitRetries, this.clock, this.parentsPerGlobalCommit);
    }

    public final ImmutableAdjustableNonTransactionalDatabaseAdapterConfig withParentsPerCommit(int value) {
        if (this.parentsPerCommit == value) {
            return this;
        }
        return new ImmutableAdjustableNonTransactionalDatabaseAdapterConfig(this.repositoryId, value, this.keyListDistance, this.maxKeyListSize, this.commitTimeout, this.commitRetries, this.clock, this.parentsPerGlobalCommit);
    }

    public final ImmutableAdjustableNonTransactionalDatabaseAdapterConfig withKeyListDistance(int value) {
        if (this.keyListDistance == value) {
            return this;
        }
        return new ImmutableAdjustableNonTransactionalDatabaseAdapterConfig(this.repositoryId, this.parentsPerCommit, value, this.maxKeyListSize, this.commitTimeout, this.commitRetries, this.clock, this.parentsPerGlobalCommit);
    }

    public final ImmutableAdjustableNonTransactionalDatabaseAdapterConfig withMaxKeyListSize(int value) {
        if (this.maxKeyListSize == value) {
            return this;
        }
        return new ImmutableAdjustableNonTransactionalDatabaseAdapterConfig(this.repositoryId, this.parentsPerCommit, this.keyListDistance, value, this.commitTimeout, this.commitRetries, this.clock, this.parentsPerGlobalCommit);
    }

    public final ImmutableAdjustableNonTransactionalDatabaseAdapterConfig withCommitTimeout(long value) {
        if (this.commitTimeout == value) {
            return this;
        }
        return new ImmutableAdjustableNonTransactionalDatabaseAdapterConfig(this.repositoryId, this.parentsPerCommit, this.keyListDistance, this.maxKeyListSize, value, this.commitRetries, this.clock, this.parentsPerGlobalCommit);
    }

    public final ImmutableAdjustableNonTransactionalDatabaseAdapterConfig withCommitRetries(int value) {
        if (this.commitRetries == value) {
            return this;
        }
        return new ImmutableAdjustableNonTransactionalDatabaseAdapterConfig(this.repositoryId, this.parentsPerCommit, this.keyListDistance, this.maxKeyListSize, this.commitTimeout, value, this.clock, this.parentsPerGlobalCommit);
    }

    public final ImmutableAdjustableNonTransactionalDatabaseAdapterConfig withClock(Clock value) {
        if (this.clock == value) {
            return this;
        }
        Clock newValue = Objects.requireNonNull(value, "clock");
        return new ImmutableAdjustableNonTransactionalDatabaseAdapterConfig(this.repositoryId, this.parentsPerCommit, this.keyListDistance, this.maxKeyListSize, this.commitTimeout, this.commitRetries, newValue, this.parentsPerGlobalCommit);
    }

    @Override
    public final ImmutableAdjustableNonTransactionalDatabaseAdapterConfig withParentsPerGlobalCommit(int value) {
        if (this.parentsPerGlobalCommit == value) {
            return this;
        }
        return new ImmutableAdjustableNonTransactionalDatabaseAdapterConfig(this.repositoryId, this.parentsPerCommit, this.keyListDistance, this.maxKeyListSize, this.commitTimeout, this.commitRetries, this.clock, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableAdjustableNonTransactionalDatabaseAdapterConfig && this.equalTo((ImmutableAdjustableNonTransactionalDatabaseAdapterConfig)another);
    }

    private boolean equalTo(ImmutableAdjustableNonTransactionalDatabaseAdapterConfig another) {
        return this.repositoryId.equals(another.repositoryId) && this.parentsPerCommit == another.parentsPerCommit && this.keyListDistance == another.keyListDistance && this.maxKeyListSize == another.maxKeyListSize && this.commitTimeout == another.commitTimeout && this.commitRetries == another.commitRetries && this.clock.equals(another.clock) && this.parentsPerGlobalCommit == another.parentsPerGlobalCommit;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.repositoryId.hashCode();
        h += (h << 5) + this.parentsPerCommit;
        h += (h << 5) + this.keyListDistance;
        h += (h << 5) + this.maxKeyListSize;
        h += (h << 5) + Longs.hashCode((long)this.commitTimeout);
        h += (h << 5) + this.commitRetries;
        h += (h << 5) + this.clock.hashCode();
        h += (h << 5) + this.parentsPerGlobalCommit;
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"AdjustableNonTransactionalDatabaseAdapterConfig").omitNullValues().add("repositoryId", (Object)this.repositoryId).add("parentsPerCommit", this.parentsPerCommit).add("keyListDistance", this.keyListDistance).add("maxKeyListSize", this.maxKeyListSize).add("commitTimeout", this.commitTimeout).add("commitRetries", this.commitRetries).add("clock", (Object)this.clock).add("parentsPerGlobalCommit", this.parentsPerGlobalCommit).toString();
    }

    public static ImmutableAdjustableNonTransactionalDatabaseAdapterConfig copyOf(AdjustableNonTransactionalDatabaseAdapterConfig instance) {
        if (instance instanceof ImmutableAdjustableNonTransactionalDatabaseAdapterConfig) {
            return (ImmutableAdjustableNonTransactionalDatabaseAdapterConfig)instance;
        }
        return ImmutableAdjustableNonTransactionalDatabaseAdapterConfig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="AdjustableNonTransactionalDatabaseAdapterConfig", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long OPT_BIT_PARENTS_PER_COMMIT = 1L;
        private static final long OPT_BIT_KEY_LIST_DISTANCE = 2L;
        private static final long OPT_BIT_MAX_KEY_LIST_SIZE = 4L;
        private static final long OPT_BIT_COMMIT_TIMEOUT = 8L;
        private static final long OPT_BIT_COMMIT_RETRIES = 16L;
        private static final long OPT_BIT_PARENTS_PER_GLOBAL_COMMIT = 32L;
        private long optBits;
        @Nullable
        private String repositoryId;
        private int parentsPerCommit;
        private int keyListDistance;
        private int maxKeyListSize;
        private long commitTimeout;
        private int commitRetries;
        @Nullable
        private Clock clock;
        private int parentsPerGlobalCommit;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(DatabaseAdapterConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(NonTransactionalDatabaseAdapterConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(AdjustableNonTransactionalDatabaseAdapterConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            DatabaseAdapterConfig instance;
            if (object instanceof DatabaseAdapterConfig) {
                instance = (DatabaseAdapterConfig)object;
                this.maxKeyListSize(instance.getMaxKeyListSize());
                this.commitTimeout(instance.getCommitTimeout());
                this.repositoryId(instance.getRepositoryId());
                this.keyListDistance(instance.getKeyListDistance());
                this.parentsPerCommit(instance.getParentsPerCommit());
                this.clock(instance.getClock());
                this.commitRetries(instance.getCommitRetries());
            }
            if (object instanceof NonTransactionalDatabaseAdapterConfig) {
                instance = (NonTransactionalDatabaseAdapterConfig)object;
                this.parentsPerGlobalCommit(instance.getParentsPerGlobalCommit());
            }
        }

        @CanIgnoreReturnValue
        public final Builder repositoryId(String repositoryId) {
            this.repositoryId = Objects.requireNonNull(repositoryId, "repositoryId");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder parentsPerCommit(int parentsPerCommit) {
            this.parentsPerCommit = parentsPerCommit;
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder keyListDistance(int keyListDistance) {
            this.keyListDistance = keyListDistance;
            this.optBits |= 2L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder maxKeyListSize(int maxKeyListSize) {
            this.maxKeyListSize = maxKeyListSize;
            this.optBits |= 4L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder commitTimeout(long commitTimeout) {
            this.commitTimeout = commitTimeout;
            this.optBits |= 8L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder commitRetries(int commitRetries) {
            this.commitRetries = commitRetries;
            this.optBits |= 0x10L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder clock(Clock clock) {
            this.clock = Objects.requireNonNull(clock, "clock");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder parentsPerGlobalCommit(int parentsPerGlobalCommit) {
            this.parentsPerGlobalCommit = parentsPerGlobalCommit;
            this.optBits |= 0x20L;
            return this;
        }

        public ImmutableAdjustableNonTransactionalDatabaseAdapterConfig build() {
            return new ImmutableAdjustableNonTransactionalDatabaseAdapterConfig(this);
        }

        private boolean parentsPerCommitIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean keyListDistanceIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean maxKeyListSizeIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean commitTimeoutIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private boolean commitRetriesIsSet() {
            return (this.optBits & 0x10L) != 0L;
        }

        private boolean parentsPerGlobalCommitIsSet() {
            return (this.optBits & 0x20L) != 0L;
        }
    }

    @Generated(from="AdjustableNonTransactionalDatabaseAdapterConfig", generator="Immutables")
    private final class InitShim {
        private byte repositoryIdBuildStage = 0;
        private String repositoryId;
        private byte parentsPerCommitBuildStage = 0;
        private int parentsPerCommit;
        private byte keyListDistanceBuildStage = 0;
        private int keyListDistance;
        private byte maxKeyListSizeBuildStage = 0;
        private int maxKeyListSize;
        private byte commitTimeoutBuildStage = 0;
        private long commitTimeout;
        private byte commitRetriesBuildStage = 0;
        private int commitRetries;
        private byte clockBuildStage = 0;
        private Clock clock;
        private byte parentsPerGlobalCommitBuildStage = 0;
        private int parentsPerGlobalCommit;

        private InitShim() {
        }

        String getRepositoryId() {
            if (this.repositoryIdBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.repositoryIdBuildStage == 0) {
                this.repositoryIdBuildStage = (byte)-1;
                this.repositoryId = Objects.requireNonNull(ImmutableAdjustableNonTransactionalDatabaseAdapterConfig.this.getRepositoryIdInitialize(), "repositoryId");
                this.repositoryIdBuildStage = 1;
            }
            return this.repositoryId;
        }

        void repositoryId(String repositoryId) {
            this.repositoryId = repositoryId;
            this.repositoryIdBuildStage = 1;
        }

        int getParentsPerCommit() {
            if (this.parentsPerCommitBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.parentsPerCommitBuildStage == 0) {
                this.parentsPerCommitBuildStage = (byte)-1;
                this.parentsPerCommit = ImmutableAdjustableNonTransactionalDatabaseAdapterConfig.this.getParentsPerCommitInitialize();
                this.parentsPerCommitBuildStage = 1;
            }
            return this.parentsPerCommit;
        }

        void parentsPerCommit(int parentsPerCommit) {
            this.parentsPerCommit = parentsPerCommit;
            this.parentsPerCommitBuildStage = 1;
        }

        int getKeyListDistance() {
            if (this.keyListDistanceBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.keyListDistanceBuildStage == 0) {
                this.keyListDistanceBuildStage = (byte)-1;
                this.keyListDistance = ImmutableAdjustableNonTransactionalDatabaseAdapterConfig.this.getKeyListDistanceInitialize();
                this.keyListDistanceBuildStage = 1;
            }
            return this.keyListDistance;
        }

        void keyListDistance(int keyListDistance) {
            this.keyListDistance = keyListDistance;
            this.keyListDistanceBuildStage = 1;
        }

        int getMaxKeyListSize() {
            if (this.maxKeyListSizeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.maxKeyListSizeBuildStage == 0) {
                this.maxKeyListSizeBuildStage = (byte)-1;
                this.maxKeyListSize = ImmutableAdjustableNonTransactionalDatabaseAdapterConfig.this.getMaxKeyListSizeInitialize();
                this.maxKeyListSizeBuildStage = 1;
            }
            return this.maxKeyListSize;
        }

        void maxKeyListSize(int maxKeyListSize) {
            this.maxKeyListSize = maxKeyListSize;
            this.maxKeyListSizeBuildStage = 1;
        }

        long getCommitTimeout() {
            if (this.commitTimeoutBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.commitTimeoutBuildStage == 0) {
                this.commitTimeoutBuildStage = (byte)-1;
                this.commitTimeout = ImmutableAdjustableNonTransactionalDatabaseAdapterConfig.this.getCommitTimeoutInitialize();
                this.commitTimeoutBuildStage = 1;
            }
            return this.commitTimeout;
        }

        void commitTimeout(long commitTimeout) {
            this.commitTimeout = commitTimeout;
            this.commitTimeoutBuildStage = 1;
        }

        int getCommitRetries() {
            if (this.commitRetriesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.commitRetriesBuildStage == 0) {
                this.commitRetriesBuildStage = (byte)-1;
                this.commitRetries = ImmutableAdjustableNonTransactionalDatabaseAdapterConfig.this.getCommitRetriesInitialize();
                this.commitRetriesBuildStage = 1;
            }
            return this.commitRetries;
        }

        void commitRetries(int commitRetries) {
            this.commitRetries = commitRetries;
            this.commitRetriesBuildStage = 1;
        }

        Clock getClock() {
            if (this.clockBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.clockBuildStage == 0) {
                this.clockBuildStage = (byte)-1;
                this.clock = Objects.requireNonNull(ImmutableAdjustableNonTransactionalDatabaseAdapterConfig.this.getClockInitialize(), "clock");
                this.clockBuildStage = 1;
            }
            return this.clock;
        }

        void clock(Clock clock) {
            this.clock = clock;
            this.clockBuildStage = 1;
        }

        int getParentsPerGlobalCommit() {
            if (this.parentsPerGlobalCommitBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.parentsPerGlobalCommitBuildStage == 0) {
                this.parentsPerGlobalCommitBuildStage = (byte)-1;
                this.parentsPerGlobalCommit = ImmutableAdjustableNonTransactionalDatabaseAdapterConfig.this.getParentsPerGlobalCommitInitialize();
                this.parentsPerGlobalCommitBuildStage = 1;
            }
            return this.parentsPerGlobalCommit;
        }

        void parentsPerGlobalCommit(int parentsPerGlobalCommit) {
            this.parentsPerGlobalCommit = parentsPerGlobalCommit;
            this.parentsPerGlobalCommitBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.repositoryIdBuildStage == -1) {
                attributes.add("repositoryId");
            }
            if (this.parentsPerCommitBuildStage == -1) {
                attributes.add("parentsPerCommit");
            }
            if (this.keyListDistanceBuildStage == -1) {
                attributes.add("keyListDistance");
            }
            if (this.maxKeyListSizeBuildStage == -1) {
                attributes.add("maxKeyListSize");
            }
            if (this.commitTimeoutBuildStage == -1) {
                attributes.add("commitTimeout");
            }
            if (this.commitRetriesBuildStage == -1) {
                attributes.add("commitRetries");
            }
            if (this.clockBuildStage == -1) {
                attributes.add("clock");
            }
            if (this.parentsPerGlobalCommitBuildStage == -1) {
                attributes.add("parentsPerGlobalCommit");
            }
            return "Cannot build AdjustableNonTransactionalDatabaseAdapterConfig, attribute initializers form cycle " + attributes;
        }
    }
}

