/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.units.ethereum;

import com.google.common.base.Preconditions;
import java.math.BigInteger;
import org.apache.tuweni.units.bigints.BaseUInt256Value;
import org.apache.tuweni.units.bigints.UInt256;

public final class Wei
extends BaseUInt256Value<Wei> {
    private static final int MAX_CONSTANT = 64;
    private static final BigInteger BI_MAX_CONSTANT = BigInteger.valueOf(64L);
    private static final UInt256 UINT256_MAX_CONSTANT = UInt256.valueOf(64L);
    private static Wei[] CONSTANTS = new Wei[65];

    private Wei(UInt256 bytes) {
        super(bytes, Wei::new);
    }

    public static Wei valueOf(UInt256 value) {
        if (value.compareTo(UINT256_MAX_CONSTANT) <= 0) {
            return CONSTANTS[value.intValue()];
        }
        return new Wei(value);
    }

    private Wei(long value) {
        super(value, Wei::new);
    }

    public static Wei valueOf(long value) {
        Preconditions.checkArgument((value >= 0L ? 1 : 0) != 0, (Object)"Argument must be positive");
        if (value <= 64L) {
            return CONSTANTS[(int)value];
        }
        return new Wei(value);
    }

    private Wei(BigInteger value) {
        super(value, Wei::new);
    }

    public static Wei valueOf(BigInteger value) {
        Preconditions.checkArgument((value.signum() >= 0 ? 1 : 0) != 0, (Object)"Argument must be positive");
        if (value.compareTo(BI_MAX_CONSTANT) <= 0) {
            return CONSTANTS[value.intValue()];
        }
        return new Wei(value);
    }

    static {
        Wei.CONSTANTS[0] = new Wei(UInt256.ZERO);
        for (int i = 1; i <= 64; ++i) {
            Wei.CONSTANTS[i] = new Wei(i);
        }
    }
}

