/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.units.ethereum;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.math.BigInteger;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.bytes.MutableBytes;
import org.apache.tuweni.units.bigints.UInt256;
import org.apache.tuweni.units.ethereum.Wei;

public final class Gas {
    private static final int MAX_CONSTANT = 64;
    private static final BigInteger BI_MAX_CONSTANT = BigInteger.valueOf(64L);
    private static final UInt256 UINT256_MAX_CONSTANT = UInt256.valueOf(64L);
    private static Gas[] CONSTANTS = new Gas[65];
    private final long value;

    private Gas(long value) {
        this.value = value;
    }

    public static Gas valueOf(UInt256 value) {
        if (value.compareTo(UINT256_MAX_CONSTANT) <= 0) {
            return CONSTANTS[value.intValue()];
        }
        if (!value.fitsLong()) {
            throw new IllegalArgumentException("Gas value cannot be larger than 2^63 - 1");
        }
        return new Gas(value.toLong());
    }

    public static Gas valueOf(long value) {
        Preconditions.checkArgument((value >= 0L ? 1 : 0) != 0, (Object)"Argument must be positive");
        if (value <= 64L) {
            return CONSTANTS[(int)value];
        }
        return new Gas(value);
    }

    public static Gas valueOf(BigInteger value) {
        Preconditions.checkArgument((value.signum() >= 0 ? 1 : 0) != 0, (Object)"Argument must be positive");
        if (value.compareTo(BI_MAX_CONSTANT) <= 0) {
            return CONSTANTS[value.intValue()];
        }
        try {
            return new Gas(value.longValueExact());
        }
        catch (ArithmeticException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    public Wei priceFor(Wei gasPrice) {
        return Wei.valueOf(gasPrice.toUInt256().multiply(this.value).toUInt256());
    }

    public Gas add(Gas other) {
        return Gas.valueOf(Math.addExact(this.value, other.value));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Gas)) {
            return false;
        }
        Gas gas = (Gas)o;
        return this.value == gas.value;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.value});
    }

    public String toString() {
        return "Gas{value=" + this.value + "}";
    }

    public long toLong() {
        return this.value;
    }

    public Bytes toBytes() {
        MutableBytes bytes = MutableBytes.create((int)8);
        bytes.setLong(0, this.value);
        return bytes;
    }

    public Bytes toMinimalBytes() {
        return Bytes.minimalBytes((long)this.value);
    }

    public int compareTo(long other) {
        return Long.compare(this.value, other);
    }

    static {
        Gas.CONSTANTS[0] = new Gas(0L);
        for (int i = 1; i <= 64; ++i) {
            Gas.CONSTANTS[i] = new Gas(i);
        }
    }
}

