/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.units.bigints;

import com.google.common.collect.DiscreteDomain;
import org.apache.tuweni.units.bigints.UInt384;

public final class UInt384Domain
extends DiscreteDomain<UInt384> {
    public UInt384 next(UInt384 value) {
        return value.add(1L);
    }

    public UInt384 previous(UInt384 value) {
        return value.subtract(1L);
    }

    public long distance(UInt384 start, UInt384 end) {
        UInt384 distance;
        boolean negativeDistance = start.compareTo(end) < 0;
        UInt384 uInt384 = distance = negativeDistance ? end.subtract(start) : start.subtract(end);
        if (!distance.fitsLong()) {
            return negativeDistance ? Long.MIN_VALUE : Long.MAX_VALUE;
        }
        long distanceLong = distance.toLong();
        return negativeDistance ? -distanceLong : distanceLong;
    }

    public UInt384 minValue() {
        return UInt384.MIN_VALUE;
    }

    public UInt384 maxValue() {
        return UInt384.MAX_VALUE;
    }
}

