/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.units.bigints;

import com.google.common.collect.DiscreteDomain;
import java.util.function.Function;
import org.apache.tuweni.units.bigints.UInt256;
import org.apache.tuweni.units.bigints.UInt256Value;

public final class UInt256ValueDomain<T extends UInt256Value<T>>
extends DiscreteDomain<T> {
    private final T minValue;
    private final T maxValue;

    public UInt256ValueDomain(Function<UInt256, T> ctor) {
        this.minValue = (UInt256Value)ctor.apply(UInt256.MIN_VALUE);
        this.maxValue = (UInt256Value)ctor.apply(UInt256.MAX_VALUE);
    }

    public T next(T value) {
        return value.add(1L);
    }

    public T previous(T value) {
        return value.subtract(1L);
    }

    public long distance(T start, T end) {
        T distance;
        boolean negativeDistance = start.compareTo(end) < 0;
        T t = distance = negativeDistance ? end.subtract(start) : start.subtract(end);
        if (!distance.fitsLong()) {
            return negativeDistance ? Long.MIN_VALUE : Long.MAX_VALUE;
        }
        long distanceLong = distance.toLong();
        return negativeDistance ? -distanceLong : distanceLong;
    }

    public T minValue() {
        return this.minValue;
    }

    public T maxValue() {
        return this.maxValue;
    }
}

