/*
 * Decompiled with CFR 0.152.
 */
package net.ltgt.gradle.errorprone;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Objects;
import javax.annotation.Nullable;
import net.ltgt.gradle.errorprone.ErrorProneBasePlugin;
import net.ltgt.gradle.errorprone.ErrorProneToolChain;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.tasks.TaskInputs;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.jvm.toolchain.JavaToolChain;

public class ErrorPronePlugin
implements Plugin<Project> {
    private static final Method taskGetInputs = ErrorPronePlugin.getMethod(Task.class, "getInputs", new Class[0]);
    private static final Method taskInputsFiles = ErrorPronePlugin.getMethod(TaskInputs.class, "files", Object[].class);
    @Nullable
    private static final Method withNormalizer;
    @Nullable
    private static final Class<?> classpathNormalizer;

    public void apply(Project project) {
        project.getPluginManager().apply(ErrorProneBasePlugin.class);
        ErrorProneToolChain toolChain = ErrorProneToolChain.create(project);
        project.getTasks().withType(JavaCompile.class).all(task -> {
            task.setToolChain((JavaToolChain)toolChain);
            this.taskGetInputsFiles((JavaCompile)task, toolChain.getConfiguration());
        });
    }

    private void taskGetInputsFiles(JavaCompile task, Configuration configuration) {
        try {
            Object inputs = taskInputsFiles.invoke(taskGetInputs.invoke((Object)task, new Object[0]), new Object[]{new Object[]{configuration}});
            if (withNormalizer != null) {
                withNormalizer.invoke(inputs, classpathNormalizer);
            }
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    @Nullable
    private static Class<?> classForName(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    private static Method getMethod(Class<?> clazz, String methodName, Class<?> ... parameterTypes) {
        try {
            return clazz.getMethod(methodName, parameterTypes);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        classpathNormalizer = ErrorPronePlugin.classForName("org.gradle.api.tasks.ClasspathNormalizer");
        if (classpathNormalizer != null) {
            Class<?> taskInputFilePropertyBuilder = Objects.requireNonNull(ErrorPronePlugin.classForName("org.gradle.api.tasks.TaskInputFilePropertyBuilder"));
            withNormalizer = ErrorPronePlugin.getMethod(taskInputFilePropertyBuilder, "withNormalizer", Class.class);
        } else {
            withNormalizer = null;
        }
    }
}

