/*
 * Decompiled with CFR 0.152.
 */
package io.realm.transformer.build;

import com.android.build.api.transform.DirectoryInput;
import com.android.build.api.transform.Format;
import com.android.build.api.transform.JarInput;
import com.android.build.api.transform.Transform;
import com.android.build.api.transform.TransformInput;
import com.android.build.api.transform.TransformOutputProvider;
import com.google.common.io.Files;
import io.realm.transformer.BytecodeModifier;
import io.realm.transformer.ManagedClassPool;
import io.realm.transformer.ProjectMetaData;
import io.realm.transformer.RealmTransformerKt;
import io.realm.transformer.build.BuildTemplate;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import javassist.ClassPool;
import javassist.CtClass;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\b&\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010)\u001a\u00020*2\u0006\u0010\t\u001a\u00020+H\u0002J2\u0010,\u001a\u00020*2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110-2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H$J\u0006\u00100\u001a\u00020*J\u0016\u00100\u001a\u00020*2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0002J$\u00101\u001a\u00020*2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a022\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u001a02H$J\u001c\u00103\u001a\b\u0012\u0004\u0012\u00020\u001f0-2\f\u00104\u001a\b\u0012\u0004\u0012\u00020\u001a02H$J\u0018\u00105\u001a\u0002062\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u00107\u001a\u000208H\u0004J\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u001f02J\u0006\u00109\u001a\u00020:J\u0006\u0010;\u001a\u00020*J\u0016\u0010<\u001a\u00020*2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H&J\u0014\u0010=\u001a\u00020*2\f\u0010>\u001a\b\u0012\u0004\u0012\u00020\u00110-J\b\u0010?\u001a\u00020*H&J\u0006\u0010@\u001a\u00020*R\u001a\u0010\t\u001a\u00020\nX\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR \u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR$\u0010\u001d\u001a\u0012\u0012\u0004\u0012\u00020\u001f0\u001ej\b\u0012\u0004\u0012\u00020\u001f` X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u001a\u0010%\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010\u001cR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(\u00a8\u0006A"}, d2={"Lio/realm/transformer/build/BuildTemplate;", "", "metadata", "Lio/realm/transformer/ProjectMetaData;", "outputProvider", "Lcom/android/build/api/transform/TransformOutputProvider;", "transform", "Lcom/android/build/api/transform/Transform;", "(Lio/realm/transformer/ProjectMetaData;Lcom/android/build/api/transform/TransformOutputProvider;Lcom/android/build/api/transform/Transform;)V", "classPool", "Lio/realm/transformer/ManagedClassPool;", "getClassPool", "()Lio/realm/transformer/ManagedClassPool;", "setClassPool", "(Lio/realm/transformer/ManagedClassPool;)V", "inputs", "", "Lcom/android/build/api/transform/TransformInput;", "getInputs", "()Ljava/util/Collection;", "setInputs", "(Ljava/util/Collection;)V", "getMetadata", "()Lio/realm/transformer/ProjectMetaData;", "outputClassNames", "", "", "getOutputClassNames", "()Ljava/util/Set;", "outputModelClasses", "Ljava/util/ArrayList;", "Ljavassist/CtClass;", "Lkotlin/collections/ArrayList;", "getOutputModelClasses", "()Ljava/util/ArrayList;", "getOutputProvider", "()Lcom/android/build/api/transform/TransformOutputProvider;", "outputReferencedClassNames", "getOutputReferencedClassNames", "getTransform", "()Lcom/android/build/api/transform/Transform;", "addBootClassesToClassPool", "", "Ljavassist/ClassPool;", "categorizeClassNames", "", "directoryFiles", "referencedFiles", "copyResourceFiles", "filterForModelClasses", "", "findModelClasses", "classNames", "getOutputFile", "Ljava/io/File;", "format", "Lcom/android/build/api/transform/Format;", "hasNoOutput", "", "markMediatorsAsTransformed", "prepareOutputClasses", "prepareReferencedClasses", "referencedInputs", "transformDirectAccessToModelFields", "transformModelClasses", "realm-transformer"})
public abstract class BuildTemplate {
    @NotNull
    private final ProjectMetaData metadata;
    @NotNull
    private final TransformOutputProvider outputProvider;
    @NotNull
    private final Transform transform;
    protected Collection<TransformInput> inputs;
    protected ManagedClassPool classPool;
    @NotNull
    private final Set<String> outputClassNames;
    @NotNull
    private final Set<String> outputReferencedClassNames;
    @NotNull
    private final ArrayList<CtClass> outputModelClasses;

    public BuildTemplate(@NotNull ProjectMetaData metadata, @NotNull TransformOutputProvider outputProvider, @NotNull Transform transform) {
        Intrinsics.checkNotNullParameter((Object)metadata, (String)"metadata");
        Intrinsics.checkNotNullParameter((Object)outputProvider, (String)"outputProvider");
        Intrinsics.checkNotNullParameter((Object)transform, (String)"transform");
        this.metadata = metadata;
        this.outputProvider = outputProvider;
        this.transform = transform;
        boolean bl = false;
        this.outputClassNames = new HashSet();
        bl = false;
        this.outputReferencedClassNames = new HashSet();
        bl = false;
        this.outputModelClasses = new ArrayList();
    }

    @NotNull
    public final ProjectMetaData getMetadata() {
        return this.metadata;
    }

    @NotNull
    public final TransformOutputProvider getOutputProvider() {
        return this.outputProvider;
    }

    @NotNull
    public final Transform getTransform() {
        return this.transform;
    }

    @NotNull
    protected final Collection<TransformInput> getInputs() {
        Collection<TransformInput> collection = this.inputs;
        if (collection != null) {
            return collection;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"inputs");
        return null;
    }

    protected final void setInputs(@NotNull Collection<TransformInput> collection) {
        Intrinsics.checkNotNullParameter(collection, (String)"<set-?>");
        this.inputs = collection;
    }

    @NotNull
    protected final ManagedClassPool getClassPool() {
        ManagedClassPool managedClassPool = this.classPool;
        if (managedClassPool != null) {
            return managedClassPool;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"classPool");
        return null;
    }

    protected final void setClassPool(@NotNull ManagedClassPool managedClassPool) {
        Intrinsics.checkNotNullParameter((Object)managedClassPool, (String)"<set-?>");
        this.classPool = managedClassPool;
    }

    @NotNull
    protected final Set<String> getOutputClassNames() {
        return this.outputClassNames;
    }

    @NotNull
    protected final Set<String> getOutputReferencedClassNames() {
        return this.outputReferencedClassNames;
    }

    @NotNull
    protected final ArrayList<CtClass> getOutputModelClasses() {
        return this.outputModelClasses;
    }

    public abstract void prepareOutputClasses(@NotNull Collection<TransformInput> var1);

    protected abstract void categorizeClassNames(@NotNull Collection<? extends TransformInput> var1, @NotNull Set<String> var2, @NotNull Set<String> var3);

    public final boolean hasNoOutput() {
        return this.outputClassNames.isEmpty();
    }

    public final void prepareReferencedClasses(@NotNull Collection<? extends TransformInput> referencedInputs) {
        Intrinsics.checkNotNullParameter(referencedInputs, (String)"referencedInputs");
        this.categorizeClassNames(referencedInputs, this.outputReferencedClassNames, this.outputReferencedClassNames);
        this.setClassPool(new ManagedClassPool(this.getInputs(), referencedInputs));
        this.addBootClassesToClassPool(this.getClassPool());
        RealmTransformerKt.getLogger().debug(Intrinsics.stringPlus((String)"ClassPool contains Realm classes: ", (Object)(this.getClassPool().getOrNull("io.realm.RealmList") != null ? 1 : 0)));
        this.filterForModelClasses(this.outputClassNames, this.outputReferencedClassNames);
    }

    protected abstract void filterForModelClasses(@NotNull Set<String> var1, @NotNull Set<String> var2);

    /*
     * WARNING - void declaration
     */
    public final void markMediatorsAsTransformed() {
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        String it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        CtClass ctClass = this.getClassPool().get("io.realm.internal.RealmProxyMediator");
        Intrinsics.checkNotNullExpressionValue((Object)ctClass, (String)"classPool.get(\"io.realm.\u2026rnal.RealmProxyMediator\")");
        CtClass baseProxyMediator = ctClass;
        Pattern pattern = Pattern.compile("^io\\.realm\\.[^.]+Mediator$");
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(\"^io\\\\.realm\\\\.[^.]+Mediator$\")");
        Pattern mediatorPattern = pattern;
        Iterable iterable = this.outputClassNames;
        boolean $i$f$filter = false;
        Iterator iterator = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            if (!mediatorPattern.matcher(it).find()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            CtClass ctClass2 = this.getClassPool().getCtClass(it);
            collection.add(ctClass2);
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (CtClass)element$iv$iv;
            boolean bl = false;
            if (!it.getSuperclass().equals((Object)baseProxyMediator)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Collection proxyMediatorClasses = (List)destination$iv$iv;
        RealmTransformerKt.getLogger().debug(Intrinsics.stringPlus((String)"Proxy Mediator Classes: ", (Object)CollectionsKt.joinToString$default((Iterable)proxyMediatorClasses, (CharSequence)",", null, null, (int)0, null, (Function1)markMediatorsAsTransformed.1.INSTANCE, (int)30, null)));
        Iterable $this$forEach$iv = proxyMediatorClasses;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CtClass it2 = (CtClass)element$iv;
            boolean bl = false;
            BytecodeModifier.Companion.overrideTransformedMarker(it2);
        }
    }

    public final void transformModelClasses() {
        Iterable $this$forEach$iv = this.outputModelClasses;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CtClass it = (CtClass)element$iv;
            boolean bl = false;
            RealmTransformerKt.getLogger().debug(Intrinsics.stringPlus((String)"Modify model class: ", (Object)it.getName()));
            BytecodeModifier.Companion.addRealmAccessors(it);
            BytecodeModifier.Companion.addRealmProxyInterface(it, this.getClassPool());
            BytecodeModifier.Companion.callInjectObjectContextFromConstructors(it);
        }
    }

    public abstract void transformDirectAccessToModelFields();

    public final void copyResourceFiles() {
        this.copyResourceFiles(this.getInputs());
        this.getClassPool().close();
    }

    private final void copyResourceFiles(Collection<TransformInput> inputs) {
        Iterable $this$forEach$iv = inputs;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object dest;
            boolean bl;
            int n;
            String string;
            File file;
            boolean $i$f$forEach2;
            Object $this$forEach$iv2;
            String dirPath;
            TransformInput input = (TransformInput)element$iv;
            boolean bl2 = false;
            Collection collection = input.getDirectoryInputs();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"input.directoryInputs");
            Iterable $this$forEach$iv3 = collection;
            boolean $i$f$forEach3 = false;
            for (Object element$iv2 : $this$forEach$iv3) {
                DirectoryInput directory = (DirectoryInput)element$iv2;
                boolean bl3 = false;
                Object object = directory.getFile().getAbsolutePath();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"directory.file.absolutePath");
                dirPath = object;
                object = directory.getFile();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"directory.file");
                $this$forEach$iv2 = (Sequence)FilesKt.walkTopDown((File)object);
                $i$f$forEach2 = false;
                for (Object element$iv3 : $this$forEach$iv2) {
                    file = (File)element$iv3;
                    boolean bl4 = false;
                    if (!file.isFile()) continue;
                    String string2 = file.getAbsolutePath();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"file.absolutePath");
                    if (StringsKt.endsWith$default((String)string2, (String)".class", (boolean)false, (int)2, null)) continue;
                    RealmTransformerKt.getLogger().debug(Intrinsics.stringPlus((String)"  Copying resource file: ", (Object)file));
                    File file2 = this.getOutputFile(this.getOutputProvider(), Format.DIRECTORY);
                    string = file.getAbsolutePath();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.absolutePath");
                    n = dirPath.length();
                    bl = false;
                    String string3 = string.substring(n);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
                    dest = new File(file2, string3);
                    ((File)dest).getParentFile().mkdirs();
                    Files.copy((File)file, (File)dest);
                }
            }
            $this$forEach$iv3 = input.getJarInputs();
            Intrinsics.checkNotNullExpressionValue((Object)$this$forEach$iv3, (String)"input.jarInputs");
            $i$f$forEach3 = false;
            for (Object element$iv2 : $this$forEach$iv3) {
                JarInput jar = (JarInput)element$iv2;
                boolean bl5 = false;
                RealmTransformerKt.getLogger().debug(Intrinsics.stringPlus((String)"Found JAR file: ", (Object)jar.getFile().getAbsolutePath()));
                $this$forEach$iv2 = jar.getFile().getAbsolutePath();
                Intrinsics.checkNotNullExpressionValue((Object)$this$forEach$iv2, (String)"jar.file.absolutePath");
                dirPath = $this$forEach$iv2;
                $this$forEach$iv2 = jar.getFile();
                Intrinsics.checkNotNullExpressionValue((Object)$this$forEach$iv2, (String)"jar.file");
                $this$forEach$iv2 = (Sequence)FilesKt.walkTopDown((File)$this$forEach$iv2);
                $i$f$forEach2 = false;
                for (Object element$iv3 : $this$forEach$iv2) {
                    file = (File)element$iv3;
                    boolean bl6 = false;
                    if (!file.isFile()) continue;
                    dest = file.getAbsolutePath();
                    Intrinsics.checkNotNullExpressionValue((Object)dest, (String)"file.absolutePath");
                    if (!StringsKt.endsWith$default((String)dest, (String)".jar", (boolean)false, (int)2, null)) continue;
                    RealmTransformerKt.getLogger().debug(Intrinsics.stringPlus((String)"  Copying jar file: ", (Object)file));
                    File file3 = this.getOutputFile(this.getOutputProvider(), Format.JAR);
                    string = file.getAbsolutePath();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.absolutePath");
                    n = dirPath.length();
                    bl = false;
                    String string4 = string.substring(n);
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).substring(startIndex)");
                    dest = new File(file3, string4);
                    ((File)dest).getParentFile().mkdirs();
                    Files.copy((File)file, (File)dest);
                }
            }
        }
    }

    @NotNull
    protected final File getOutputFile(@NotNull TransformOutputProvider outputProvider, @NotNull Format format) {
        Intrinsics.checkNotNullParameter((Object)outputProvider, (String)"outputProvider");
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        File file = outputProvider.getContentLocation("realm", this.transform.getInputTypes(), this.transform.getScopes(), format);
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"outputProvider.getConten\u2026transform.scopes, format)");
        return file;
    }

    private final void addBootClassesToClassPool(ClassPool classPool) {
        try {
            Iterable $this$forEach$iv = this.metadata.getBootClassPath();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                File it = (File)element$iv;
                boolean bl = false;
                String string = it.getAbsolutePath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.absolutePath");
                String path = string;
                RealmTransformerKt.getLogger().debug("Add boot class " + path + " to class pool.");
                classPool.appendClassPath(path);
            }
        }
        catch (Exception e) {
            RealmTransformerKt.getLogger().debug("Cannot get bootClasspath caused by: ", (Throwable)e);
        }
    }

    @NotNull
    public final Set<CtClass> getOutputModelClasses() {
        return CollectionsKt.toSet((Iterable)this.outputModelClasses);
    }

    @NotNull
    protected abstract Collection<CtClass> findModelClasses(@NotNull Set<String> var1);
}

