/*
 * Decompiled with CFR 0.152.
 */
package io.realm.gradle;

import java.util.LinkedHashMap;
import java.util.Map;
import org.gradle.api.tasks.Input;

public class RealmPluginExtension {
    public static final String KEY_SYNC_ENABLED = "syncEnabled";
    public static final String KEY_KOTLIN_EXTENSIONS_ENABLED = "kotlinExtensionsEnabled";
    private boolean syncEnabled;
    private boolean kotlinExtensionsEnabled;
    private Map<String, PropertyChangedListener> listeners = new LinkedHashMap<String, PropertyChangedListener>();

    @Input
    public boolean isSyncEnabled() {
        return this.syncEnabled;
    }

    public void setSyncEnabled(boolean syncEnabled) {
        this.syncEnabled = syncEnabled;
        this.notifyChange(KEY_SYNC_ENABLED, syncEnabled);
    }

    @Input
    public boolean isKotlinExtensionsEnabled() {
        return this.kotlinExtensionsEnabled;
    }

    public void setKotlinExtensionsEnabled(boolean kotlinExtensionsEnabled) {
        this.kotlinExtensionsEnabled = kotlinExtensionsEnabled;
        this.notifyChange(KEY_KOTLIN_EXTENSIONS_ENABLED, kotlinExtensionsEnabled);
    }

    public void addPropertyListener(String property, PropertyChangedListener listener) {
        this.listeners.put(property, listener);
    }

    private void notifyChange(String key, Object value) {
        PropertyChangedListener listener = this.listeners.get(key);
        if (listener != null) {
            listener.onChange(value);
        }
    }

    public static interface PropertyChangedListener<T> {
        public void onChange(T var1);
    }
}

