/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.chat;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.hyphenate.EMCallBack;
import com.hyphenate.chat.EMBase;
import com.hyphenate.chat.EMChatThread;
import com.hyphenate.chat.EMClient;
import com.hyphenate.chat.EMCmdMessageBody;
import com.hyphenate.chat.EMCombineMessageBody;
import com.hyphenate.chat.EMCustomMessageBody;
import com.hyphenate.chat.EMImageMessageBody;
import com.hyphenate.chat.EMLocationMessageBody;
import com.hyphenate.chat.EMMessageBody;
import com.hyphenate.chat.EMMessagePinInfo;
import com.hyphenate.chat.EMMessageReaction;
import com.hyphenate.chat.EMNormalFileMessageBody;
import com.hyphenate.chat.EMSessionManager;
import com.hyphenate.chat.EMTextMessageBody;
import com.hyphenate.chat.EMVideoMessageBody;
import com.hyphenate.chat.EMVoiceMessageBody;
import com.hyphenate.chat.adapter.EMACallback;
import com.hyphenate.chat.adapter.EMAMessageReaction;
import com.hyphenate.chat.adapter.EMAThreadInfo;
import com.hyphenate.chat.adapter.message.EMACmdMessageBody;
import com.hyphenate.chat.adapter.message.EMACombineMessageBody;
import com.hyphenate.chat.adapter.message.EMACustomMessageBody;
import com.hyphenate.chat.adapter.message.EMAFileMessageBody;
import com.hyphenate.chat.adapter.message.EMAImageMessageBody;
import com.hyphenate.chat.adapter.message.EMALocationMessageBody;
import com.hyphenate.chat.adapter.message.EMAMessage;
import com.hyphenate.chat.adapter.message.EMAMessageBody;
import com.hyphenate.chat.adapter.message.EMAMessagePinInfo;
import com.hyphenate.chat.adapter.message.EMATextMessageBody;
import com.hyphenate.chat.adapter.message.EMAVideoMessageBody;
import com.hyphenate.chat.adapter.message.EMAVoiceMessageBody;
import com.hyphenate.exceptions.HyphenateException;
import com.hyphenate.util.EMFileHelper;
import com.hyphenate.util.EMLog;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class EMMessage
extends EMBase<EMAMessage>
implements Parcelable,
Cloneable {
    static final String ATTR_ENCRYPTED = "isencrypted";
    private static final String TAG = "msg";
    public static final Parcelable.Creator<EMMessage> CREATOR = new Parcelable.Creator<EMMessage>(){

        /*
         * WARNING - void declaration
         */
        public EMMessage createFromParcel(Parcel in) {
            EMMessage eMMessage;
            Object object = null;
            EMMessage eMMessage2 = eMMessage;
            try {
                void var1_1;
                eMMessage = new EMMessage((Parcel)var1_1);
                object = eMMessage2;
            }
            catch (HyphenateException hyphenateException) {
                hyphenateException.printStackTrace();
            }
            return object;
        }

        public EMMessage[] newArray(int size) {
            return new EMMessage[size];
        }
    };
    EMMessageBody body;
    EMCallbackHolder messageStatusCallBack;

    /*
     * WARNING - void declaration
     */
    public EMMessage(EMAMessage message) {
        void var1_1;
        this.emaObject = var1_1;
    }

    public static EMMessage createSendMessage(Type type) {
        int n = ChatType.Chat.ordinal();
        EMAMessage eMAMessage = EMAMessage.createSendMessage(EMMessage.self(), "", null, n);
        return new EMMessage(eMAMessage);
    }

    public static EMMessage createReceiveMessage(Type type) {
        int n = ChatType.Chat.ordinal();
        EMAMessage eMAMessage = EMAMessage.createReceiveMessage("", EMMessage.self(), null, n);
        EMMessage eMMessage = new EMMessage(eMAMessage);
        eMMessage.setTo(EMSessionManager.getInstance().currentUser.getUsername());
        return eMMessage;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static EMMessage createTxtSendMessage(String content, String username) {
        if (content.length() > 0) {
            void var1_1;
            String string;
            EMMessage eMMessage = EMMessage.createSendMessage(Type.TXT);
            eMMessage.addBody(new EMTextMessageBody(string));
            eMMessage.setTo((String)var1_1);
            return eMMessage;
        }
        EMLog.e(TAG, "text content size must be greater than 0");
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static EMMessage createTextSendMessage(String content, String username) {
        if (content.length() > 0) {
            void var1_1;
            String string;
            EMMessage eMMessage = EMMessage.createSendMessage(Type.TXT);
            eMMessage.addBody(new EMTextMessageBody(string));
            eMMessage.setTo((String)var1_1);
            return eMMessage;
        }
        EMLog.e(TAG, "text content size must be greater than 0");
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static EMMessage createVoiceSendMessage(String filePath, int timeLength, String username) {
        void var2_2;
        void var1_1;
        String string;
        return EMMessage.createVoiceSendMessage(EMFileHelper.getInstance().formatInUri(string), (int)var1_1, (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static EMMessage createVoiceSendMessage(Uri filePath, int timeLength, String username) {
        void var2_2;
        void var1_1;
        Uri uri;
        if (!EMFileHelper.getInstance().isFileExist(uri)) {
            EMLog.e(TAG, "voice file does not exist");
            return null;
        }
        EMMessage eMMessage = EMMessage.createSendMessage(Type.VOICE);
        eMMessage.addBody(new EMVoiceMessageBody(uri, (int)var1_1));
        eMMessage.setTo((String)var2_2);
        return eMMessage;
    }

    /*
     * WARNING - void declaration
     */
    public static EMMessage createImageSendMessage(String filePath, boolean sendOriginalImage, String username) {
        void var2_2;
        void var1_1;
        String string;
        return EMMessage.createImageSendMessage(EMFileHelper.getInstance().formatInUri(string), (boolean)var1_1, (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static EMMessage createImageSendMessage(Uri imgUri, boolean sendOriginalImage, String username) {
        void var1_1;
        void var2_2;
        Uri uri;
        if (!EMFileHelper.getInstance().isFileExist(uri)) {
            EMLog.e(TAG, "image file does not exsit");
            return null;
        }
        EMMessage eMMessage = EMMessage.createSendMessage(Type.IMAGE);
        eMMessage.setTo((String)var2_2);
        EMImageMessageBody eMImageMessageBody = new EMImageMessageBody(uri);
        eMImageMessageBody.setSendOriginalImage((boolean)var1_1);
        eMMessage.addBody(eMImageMessageBody);
        return eMMessage;
    }

    /*
     * WARNING - void declaration
     */
    public static EMMessage createVideoSendMessage(String videofilePath, String imageThumbPath, int timeLength, String username) {
        void var3_3;
        void var2_2;
        void var1_1;
        String string;
        return EMMessage.createVideoSendMessage(EMFileHelper.getInstance().formatInUri(string), EMFileHelper.getInstance().formatInUri((String)var1_1), (int)var2_2, (String)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public static EMMessage createVideoSendMessage(Uri videofilePath, String imageThumbPath, int timeLength, String username) {
        void var3_3;
        void var2_2;
        void var1_1;
        return EMMessage.createVideoSendMessage(videofilePath, EMFileHelper.getInstance().formatInUri((String)var1_1), (int)var2_2, (String)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public static EMMessage createVideoSendMessage(Uri videofilePath, Uri imageThumbPath, int timeLength, String username) {
        void var2_2;
        void var1_1;
        void var3_3;
        Uri uri;
        if (!EMFileHelper.getInstance().isFileExist(uri)) {
            EMLog.e(TAG, "video file does not exist");
            return null;
        }
        EMMessage eMMessage = EMMessage.createSendMessage(Type.VIDEO);
        eMMessage.setTo((String)var3_3);
        long l = EMFileHelper.getInstance().getFileLength(uri);
        eMMessage.addBody(new EMVideoMessageBody(uri, (Uri)var1_1, (int)var2_2, l));
        return eMMessage;
    }

    /*
     * WARNING - void declaration
     */
    public static EMMessage createLocationSendMessage(double latitude, double longitude, String locationAddress, String buildingName, String username) {
        void var6_4;
        void var5_3;
        void var2_1;
        double d2;
        void var4_2;
        EMMessage eMMessage = EMMessage.createSendMessage(Type.LOCATION);
        eMMessage.addBody(new EMLocationMessageBody((String)var4_2, d2, (double)var2_1, (String)var5_3));
        eMMessage.setTo((String)var6_4);
        return eMMessage;
    }

    /*
     * WARNING - void declaration
     */
    public static EMMessage createLocationSendMessage(double latitude, double longitude, String locationAddress, String username) {
        void var5_3;
        void var2_1;
        double d2;
        void var4_2;
        EMMessage eMMessage = EMMessage.createSendMessage(Type.LOCATION);
        eMMessage.addBody(new EMLocationMessageBody((String)var4_2, d2, (double)var2_1));
        eMMessage.setTo((String)var5_3);
        return eMMessage;
    }

    /*
     * WARNING - void declaration
     */
    public static EMMessage createFileSendMessage(String filePath, String username) {
        void var1_1;
        String string;
        return EMMessage.createFileSendMessage(EMFileHelper.getInstance().formatInUri(string), (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static EMMessage createFileSendMessage(Uri filePath, String username) {
        void var1_1;
        Uri uri;
        if (!EMFileHelper.getInstance().isFileExist(uri)) {
            EMLog.e(TAG, "file does not exist");
            return null;
        }
        EMMessage eMMessage = EMMessage.createSendMessage(Type.FILE);
        eMMessage.setTo((String)var1_1);
        eMMessage.addBody(new EMNormalFileMessageBody(uri));
        return eMMessage;
    }

    /*
     * WARNING - void declaration
     */
    public static EMMessage createCombinedSendMessage(String title, String summary, String compatibleText, List<String> messageIdList, String userId) {
        void var3_3;
        void var2_2;
        void var1_1;
        String string;
        void var4_4;
        EMMessage eMMessage = EMMessage.createSendMessage(Type.COMBINE);
        eMMessage.setTo((String)var4_4);
        eMMessage.addBody(new EMCombineMessageBody(string, (String)var1_1, (String)var2_2, (List<String>)var3_3));
        return eMMessage;
    }

    static String self() {
        String string = EMClient.getInstance().getCurrentUser();
        if (string == null) {
            string = EMSessionManager.getInstance().getLastLoginUser();
        }
        return string;
    }

    private EMMessage(Parcel in) throws HyphenateException {
        Parcel parcel = in;
        String string = parcel.readString();
        long l = parcel.readLong();
        EMMessage eMMessage = EMClient.getInstance().chatManager().getMessage(l);
        if (eMMessage == null && (eMMessage = EMClient.getInstance().chatManager().getMessage(string)) == null) {
            throw new HyphenateException("EMMessage constructed from parcel failed");
        }
        this.emaObject = eMMessage.emaObject;
    }

    public Status status() {
        Object this_ = Status.CREATE;
        switch (3.$SwitchMap$com$hyphenate$chat$adapter$message$EMAMessage$EMAMessageStatus[((EMAMessage)this_.emaObject)._status().ordinal()]) {
            default: {
                break;
            }
            case 4: {
                this_ = Status.INPROGRESS;
                break;
            }
            case 3: {
                this_ = Status.FAIL;
                break;
            }
            case 2: {
                this_ = Status.SUCCESS;
            }
            case 1: 
        }
        return this_;
    }

    /*
     * WARNING - void declaration
     */
    public void setStatus(Status status) {
        void var1_1;
        EMAMessage.EMAMessageStatus eMAMessageStatus = EMAMessage.EMAMessageStatus.SUCCESS;
        switch (3.$SwitchMap$com$hyphenate$chat$EMMessage$Status[var1_1.ordinal()]) {
            default: {
                break;
            }
            case 4: {
                eMAMessageStatus = EMAMessage.EMAMessageStatus.DELIVERING;
                break;
            }
            case 3: {
                eMAMessageStatus = EMAMessage.EMAMessageStatus.FAIL;
                break;
            }
            case 1: {
                eMAMessageStatus = EMAMessage.EMAMessageStatus.NEW;
            }
            case 2: 
        }
        ((EMAMessage)this.emaObject).setStatus(eMAMessageStatus.ordinal());
    }

    public Type getType() {
        List<EMAMessageBody> this_ = ((EMAMessage)((EMBase)((Object)this_)).emaObject).bodies();
        if (this_.size() > 0) {
            Type type;
            int n = ((EMAMessageBody)this_.get(0)).type();
            if (n == (type = Type.TXT).ordinal()) {
                return type;
            }
            type = Type.IMAGE;
            if (n == type.ordinal()) {
                return type;
            }
            type = Type.CMD;
            if (n == type.ordinal()) {
                return type;
            }
            type = Type.FILE;
            if (n == type.ordinal()) {
                return type;
            }
            type = Type.VIDEO;
            if (n == type.ordinal()) {
                return type;
            }
            type = Type.VOICE;
            if (n == type.ordinal()) {
                return type;
            }
            type = Type.LOCATION;
            if (n == type.ordinal()) {
                return type;
            }
            type = Type.CUSTOM;
            if (n == type.ordinal()) {
                return type;
            }
            Type type2 = Type.COMBINE;
            if (n == type2.ordinal()) {
                return type2;
            }
        }
        return Type.TXT;
    }

    public synchronized EMMessageBody getBody() {
        List<EMAMessageBody> list = this.body;
        if (list != null) {
            return list;
        }
        list = ((EMAMessage)this.emaObject).bodies();
        if (list.size() > 0) {
            if ((list = (EMAMessageBody)list.get(0)) instanceof EMATextMessageBody) {
                this.body = new EMTextMessageBody((EMATextMessageBody)((Object)list));
            } else if (list instanceof EMACmdMessageBody) {
                this.body = new EMCmdMessageBody((EMACmdMessageBody)((Object)list));
            } else if (list instanceof EMAVideoMessageBody) {
                this.body = new EMVideoMessageBody((EMAVideoMessageBody)((Object)list));
            } else if (list instanceof EMAVoiceMessageBody) {
                this.body = new EMVoiceMessageBody((EMAVoiceMessageBody)((Object)list));
            } else if (list instanceof EMAImageMessageBody) {
                this.body = new EMImageMessageBody((EMAImageMessageBody)((Object)list));
            } else if (list instanceof EMACombineMessageBody) {
                this.body = new EMCombineMessageBody((EMACombineMessageBody)((Object)list));
            } else if (list instanceof EMALocationMessageBody) {
                this.body = new EMLocationMessageBody((EMALocationMessageBody)((Object)list));
            } else if (list instanceof EMAFileMessageBody) {
                this.body = new EMNormalFileMessageBody((EMAFileMessageBody)((Object)list));
            } else if (list instanceof EMACustomMessageBody) {
                this.body = new EMCustomMessageBody((EMACustomMessageBody)((Object)list));
            }
            return this.body;
        }
        return null;
    }

    public long getMsgTime() {
        return ((EMAMessage)this.emaObject).timeStamp();
    }

    /*
     * WARNING - void declaration
     */
    public void setMsgTime(long msgTime) {
        void var1_1;
        ((EMAMessage)this.emaObject).setTimeStamp((long)var1_1);
    }

    public long localTime() {
        return ((EMAMessage)this.emaObject).getLocalTime();
    }

    /*
     * WARNING - void declaration
     */
    public void setLocalTime(long serverTime) {
        void var1_1;
        ((EMAMessage)this.emaObject).setLocalTime((long)var1_1);
    }

    public boolean isNeedGroupAck() {
        return ((EMAMessage)this.emaObject).isNeedGroupAck();
    }

    /*
     * WARNING - void declaration
     */
    public void setIsNeedGroupAck(boolean need) {
        void var1_1;
        ((EMAMessage)this.emaObject).setIsNeedGroupAck((boolean)var1_1);
    }

    public int groupAckCount() {
        return ((EMAMessage)this.emaObject).groupAckCount();
    }

    /*
     * WARNING - void declaration
     */
    public void setGroupAckCount(int count) {
        void var1_1;
        ((EMAMessage)this.emaObject).setGroupAckCount((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setIsChatThreadMessage(boolean isChatThreadMessage) {
        void var1_1;
        ((EMAMessage)this.emaObject).setIsChatThreadMessage((boolean)var1_1);
    }

    public boolean isChatThreadMessage() {
        return ((EMAMessage)this.emaObject).isChatThreadMessage();
    }

    public EMChatThread getChatThread() {
        EMAThreadInfo this_ = ((EMAMessage)((EMBase)((Object)this_)).emaObject).getChatThread();
        if (this_ == null) {
            return null;
        }
        return new EMChatThread(this_);
    }

    /*
     * WARNING - void declaration
     */
    public void setBody(EMMessageBody body) {
        void var1_1;
        if (this.body != var1_1) {
            EMMessage eMMessage = this;
            eMMessage.body = var1_1;
            ((EMAMessage)eMMessage.emaObject).clearBodies();
            ((EMAMessage)eMMessage.emaObject).addBody((EMAMessageBody)var1_1.emaObject);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void addBody(EMMessageBody body) {
        void var1_1;
        this.body = var1_1;
        ((EMAMessage)this.emaObject).addBody((EMAMessageBody)var1_1.emaObject);
    }

    public String getFrom() {
        return ((EMAMessage)this.emaObject).from();
    }

    /*
     * WARNING - void declaration
     */
    public void setFrom(String from) {
        void var1_1;
        ((EMAMessage)this.emaObject).setFrom((String)var1_1);
        if (!EMMessage.self().equals(var1_1) && this.getTo() != null && this.getTo() != "" && this.getTo().equals(EMMessage.self())) {
            ((EMAMessage)this.emaObject).setConversationId((String)var1_1);
        }
    }

    public String getRecaller() {
        return ((EMAMessage)this.emaObject).getRecaller();
    }

    /*
     * WARNING - void declaration
     */
    public void setTo(String to) {
        void var1_1;
        EMMessage eMMessage = this;
        ((EMAMessage)eMMessage.emaObject).setTo((String)var1_1);
        ((EMAMessage)eMMessage.emaObject).setConversationId((String)var1_1);
    }

    public String getTo() {
        return ((EMAMessage)this.emaObject).to();
    }

    public String getMsgId() {
        return ((EMAMessage)this.emaObject).msgId();
    }

    /*
     * WARNING - void declaration
     */
    public void setMsgId(String msgId) {
        void var1_1;
        ((EMAMessage)this.emaObject).setMsgId((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    synchronized void setInnerCallback(EMCallBack callback) {
        void var1_1;
        EMCallbackHolder eMCallbackHolder = this.messageStatusCallBack;
        if (eMCallbackHolder != null) {
            eMCallbackHolder.innerCallback = var1_1;
        } else {
            EMCallbackHolder eMCallbackHolder2;
            eMCallbackHolder = eMCallbackHolder2;
            eMCallbackHolder(null);
            this.messageStatusCallBack = eMCallbackHolder;
            eMCallbackHolder2.innerCallback = var1_1;
        }
        EMMessage eMMessage = this;
        eMMessage.setCallback(eMMessage.messageStatusCallBack);
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void setMessageStatusCallback(EMCallBack callback) {
        void var1_1;
        EMCallbackHolder eMCallbackHolder = this.messageStatusCallBack;
        if (eMCallbackHolder != null) {
            eMCallbackHolder.update((EMCallBack)var1_1);
        } else {
            EMCallbackHolder eMCallbackHolder2;
            eMCallbackHolder = eMCallbackHolder2;
            eMCallbackHolder2 = new EMCallbackHolder((EMCallBack)var1_1);
            this.messageStatusCallBack = eMCallbackHolder;
        }
        EMMessage eMMessage = this;
        eMMessage.setCallback(eMMessage.messageStatusCallBack);
    }

    /*
     * WARNING - void declaration
     */
    void setCallback(EMCallbackHolder holder) {
        void var1_1;
        ((EMAMessage)this.emaObject).setCallback(new EMACallback(new EMCallBack(){
            final /* synthetic */ EMCallbackHolder val$holder;
            final /* synthetic */ EMMessage this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.val$holder = eMCallbackHolder;
            }

            @Override
            public void onSuccess() {
                EMCallBack this_ = this_.val$holder;
                if (this_ != null) {
                    ((EMCallbackHolder)this_).onSuccess();
                }
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public void onProgress(int progress, String status) {
                EMCallBack this_ = this_.val$holder;
                if (this_ != null) {
                    void var2_2;
                    void var1_1;
                    ((EMCallbackHolder)this_).onProgress((int)var1_1, (String)var2_2);
                }
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public void onError(int code, String error) {
                EMCallBack this_ = this_.val$holder;
                if (this_ != null) {
                    void var2_2;
                    void var1_1;
                    ((EMCallbackHolder)this_).onError((int)var1_1, (String)var2_2);
                }
            }
        }));
    }

    void makeCallbackStrong() {
        EMCallbackHolder this_ = ((EMMessage)((Object)this_)).messageStatusCallBack;
        if (this_ != null) {
            this_.makeItStrong();
        }
    }

    public String toString() {
        return "msg{from:" + this.getFrom() + ", to:" + this.getTo() + " body:" + this.getBody();
    }

    /*
     * WARNING - void declaration
     */
    public void setAttribute(String attribute, boolean value) {
        void var1_1;
        if (attribute != null && !var1_1.equals("")) {
            void var2_2;
            ((EMAMessage)this.emaObject).setAttribute((String)var1_1, (boolean)var2_2);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setAttribute(String attribute, int value) {
        void var1_1;
        if (attribute != null && !var1_1.equals("")) {
            void var2_2;
            ((EMAMessage)this.emaObject).setAttribute((String)var1_1, (int)var2_2);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setAttribute(String attribute, long value) {
        void var1_1;
        if (attribute != null && !var1_1.equals("")) {
            void var2_2;
            ((EMAMessage)this.emaObject).setAttribute((String)var1_1, (long)var2_2);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setAttribute(String attribute, float value) {
        void var1_1;
        if (attribute != null && !var1_1.equals("")) {
            void var2_2;
            ((EMAMessage)this.emaObject).setAttribute((String)var1_1, (float)var2_2);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setAttribute(String attribute, double value) {
        void var1_1;
        if (attribute != null && !var1_1.equals("")) {
            void var2_2;
            ((EMAMessage)this.emaObject).setAttribute((String)var1_1, (double)var2_2);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setAttribute(String attribute, JSONObject value) {
        void var1_1;
        if (attribute != null && !var1_1.equals("")) {
            void var2_2;
            ((EMAMessage)this.emaObject).setJsonAttribute((String)var1_1, var2_2.toString());
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setAttribute(String attribute, JSONArray value) {
        void var1_1;
        if (attribute != null && !var1_1.equals("")) {
            void var2_2;
            ((EMAMessage)this.emaObject).setJsonAttribute((String)var1_1, var2_2.toString());
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setAttribute(String attribute, String value) {
        void var1_1;
        if (attribute != null && !var1_1.equals("")) {
            void var2_2;
            ((EMAMessage)this.emaObject).setAttribute((String)var1_1, (String)var2_2);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public boolean getBooleanAttribute(String attribute) throws HyphenateException {
        void var1_1;
        if (attribute != null && !var1_1.equals("")) {
            AtomicBoolean atomicBoolean;
            EMMessage eMMessage = atomicBoolean2;
            AtomicBoolean atomicBoolean2 = atomicBoolean;
            atomicBoolean = new AtomicBoolean();
            if (((EMAMessage)eMMessage.emaObject).getBooleanAttribute((String)var1_1, false, atomicBoolean2)) {
                return atomicBoolean2.get();
            }
            throw new HyphenateException(1, "attribute " + (String)var1_1 + " not found");
        }
        throw new HyphenateException(1, "attribute " + (String)var1_1 + " can not be null or empty");
    }

    /*
     * WARNING - void declaration
     */
    public boolean getBooleanAttribute(String attribute, boolean defaultValue) {
        void var2_2;
        void var1_1;
        if (attribute != null && !var1_1.equals("")) {
            AtomicBoolean atomicBoolean;
            EMMessage eMMessage = atomicBoolean2;
            AtomicBoolean atomicBoolean2 = atomicBoolean;
            atomicBoolean = new AtomicBoolean();
            if (!((EMAMessage)eMMessage.emaObject).getBooleanAttribute((String)var1_1, false, atomicBoolean2)) {
                return (boolean)var2_2;
            }
            return atomicBoolean2.get();
        }
        return (boolean)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public int getIntAttribute(String attribute, int defaultValue) {
        void var2_2;
        void var1_1;
        if (attribute != null && !var1_1.equals("")) {
            AtomicInteger atomicInteger;
            EMMessage eMMessage = atomicInteger2;
            AtomicInteger atomicInteger2 = atomicInteger;
            atomicInteger = new AtomicInteger();
            if (!((EMAMessage)eMMessage.emaObject).getIntAttribute((String)var1_1, -1, atomicInteger2)) {
                return (int)var2_2;
            }
            return atomicInteger2.intValue();
        }
        return (int)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public long getLongAttribute(String attribute, long defaultValue) {
        void var2_2;
        void var1_1;
        if (attribute != null && !var1_1.equals("")) {
            AtomicLong atomicLong;
            EMMessage eMMessage = atomicLong2;
            AtomicLong atomicLong2 = atomicLong;
            atomicLong = new AtomicLong();
            if (!((EMAMessage)eMMessage.emaObject).getLongAttribute((String)var1_1, -1L, atomicLong2)) {
                return (long)var2_2;
            }
            return atomicLong2.longValue();
        }
        return (long)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public float getFloatAttribute(String attribute, float defaultValue) {
        void var2_2;
        void var1_1;
        if (attribute != null && !var1_1.equals("")) {
            AtomicReference atomicReference;
            EMMessage eMMessage = atomicReference2;
            AtomicReference atomicReference2 = atomicReference;
            atomicReference = new AtomicReference();
            if (!((EMAMessage)eMMessage.emaObject).getFloatAttribute((String)var1_1, (float)var2_2, atomicReference2)) {
                return (float)var2_2;
            }
            return ((Float)atomicReference2.get()).floatValue();
        }
        return (float)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public double getDoubleAttribute(String attribute, double defaultValue) {
        void var2_2;
        void var1_1;
        if (attribute != null && !var1_1.equals("")) {
            AtomicReference atomicReference;
            EMMessage eMMessage = atomicReference2;
            AtomicReference atomicReference2 = atomicReference;
            atomicReference = new AtomicReference();
            if (!((EMAMessage)eMMessage.emaObject).getDoubleAttribute((String)var1_1, (double)var2_2, atomicReference2)) {
                return (double)var2_2;
            }
            return (Double)atomicReference2.get();
        }
        return (double)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public int getIntAttribute(String attribute) throws HyphenateException {
        void var1_1;
        if (attribute != null && !var1_1.equals("")) {
            AtomicInteger atomicInteger;
            EMMessage eMMessage = atomicInteger2;
            AtomicInteger atomicInteger2 = atomicInteger;
            atomicInteger = new AtomicInteger();
            if (((EMAMessage)eMMessage.emaObject).getIntAttribute((String)var1_1, -1, atomicInteger2)) {
                return atomicInteger2.intValue();
            }
            throw new HyphenateException(1, "attribute " + (String)var1_1 + " not found");
        }
        throw new HyphenateException(1, "attribute " + (String)var1_1 + " can not be null or empty");
    }

    /*
     * WARNING - void declaration
     */
    public long getLongAttribute(String attribute) throws HyphenateException {
        void var1_1;
        if (attribute != null && !var1_1.equals("")) {
            AtomicLong atomicLong;
            EMMessage eMMessage = atomicLong2;
            AtomicLong atomicLong2 = atomicLong;
            atomicLong = new AtomicLong();
            if (((EMAMessage)eMMessage.emaObject).getLongAttribute((String)var1_1, -1L, atomicLong2)) {
                return atomicLong2.longValue();
            }
            throw new HyphenateException(1, "attribute " + (String)var1_1 + " not found");
        }
        throw new HyphenateException(1, "attribute " + (String)var1_1 + " can not be null or empty");
    }

    /*
     * WARNING - void declaration
     */
    public float getFloatAttribute(String attribute) throws HyphenateException {
        void var1_1;
        if (attribute != null && !var1_1.equals("")) {
            AtomicReference atomicReference;
            EMMessage eMMessage = atomicReference2;
            AtomicReference atomicReference2 = atomicReference;
            atomicReference = new AtomicReference();
            if (((EMAMessage)eMMessage.emaObject).getFloatAttribute((String)var1_1, -1.0f, atomicReference2)) {
                return ((Float)atomicReference2.get()).floatValue();
            }
            throw new HyphenateException(1, "attribute " + (String)var1_1 + " not found");
        }
        throw new HyphenateException(1, "attribute " + (String)var1_1 + " can not be null or empty");
    }

    /*
     * WARNING - void declaration
     */
    public double getDoubleAttribute(String attribute) throws HyphenateException {
        void var1_1;
        if (attribute != null && !var1_1.equals("")) {
            AtomicReference atomicReference;
            EMMessage eMMessage = atomicReference2;
            AtomicReference atomicReference2 = atomicReference;
            atomicReference = new AtomicReference();
            if (((EMAMessage)eMMessage.emaObject).getDoubleAttribute((String)var1_1, -1.0, atomicReference2)) {
                return (Double)atomicReference2.get();
            }
            throw new HyphenateException(1, "attribute " + (String)var1_1 + " not found");
        }
        throw new HyphenateException(1, "attribute " + (String)var1_1 + " can not be null or empty");
    }

    /*
     * WARNING - void declaration
     */
    public String getStringAttribute(String attribute) throws HyphenateException {
        void var1_1;
        if (attribute != null && !var1_1.equals("")) {
            StringBuilder stringBuilder;
            EMMessage eMMessage = stringBuilder2;
            StringBuilder stringBuilder2 = stringBuilder;
            stringBuilder = new StringBuilder();
            if (((EMAMessage)eMMessage.emaObject).getStringAttribute((String)var1_1, "", stringBuilder2)) {
                return stringBuilder2.toString();
            }
            throw new HyphenateException(1, "attribute " + (String)var1_1 + " not found");
        }
        throw new HyphenateException(1, "attribute " + (String)var1_1 + " can not be null or empty");
    }

    /*
     * WARNING - void declaration
     */
    public String getStringAttribute(String attribute, String defaultValue) {
        void var2_2;
        void var1_1;
        if (attribute != null && !var1_1.equals("")) {
            StringBuilder stringBuilder;
            EMMessage eMMessage = stringBuilder2;
            StringBuilder stringBuilder2 = stringBuilder;
            stringBuilder = new StringBuilder();
            if (!((EMAMessage)eMMessage.emaObject).getStringAttribute((String)var1_1, "", stringBuilder2)) {
                return var2_2;
            }
            return stringBuilder2.toString();
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public JSONObject getJSONObjectAttribute(String attribute) throws HyphenateException {
        void var1_2;
        if (attribute != null && !var1_2.equals("")) {
            StringBuilder stringBuilder;
            EMMessage eMMessage = stringBuilder2;
            StringBuilder stringBuilder2 = stringBuilder;
            stringBuilder = new StringBuilder();
            if (((EMAMessage)eMMessage.emaObject).getJsonAttribute((String)var1_2, "{}", stringBuilder2)) {
                try {
                    return new JSONObject(stringBuilder2.toString());
                }
                catch (JSONException jSONException) {
                    throw new HyphenateException(1, jSONException.getMessage());
                }
            }
            throw new HyphenateException(1, "attribute " + (String)var1_2 + " not found");
        }
        throw new HyphenateException(1, "attribute " + (String)var1_2 + " can not be null or empty");
    }

    /*
     * WARNING - void declaration
     */
    public JSONArray getJSONArrayAttribute(String attribute) throws HyphenateException {
        void var1_2;
        if (attribute != null && !var1_2.equals("")) {
            StringBuilder stringBuilder;
            EMMessage eMMessage = stringBuilder2;
            StringBuilder stringBuilder2 = stringBuilder;
            stringBuilder = new StringBuilder();
            if (((EMAMessage)eMMessage.emaObject).getJsonAttribute((String)var1_2, "[]", stringBuilder2)) {
                try {
                    return new JSONArray(stringBuilder2.toString());
                }
                catch (JSONException jSONException) {
                    throw new HyphenateException(1, jSONException.getMessage());
                }
            }
            throw new HyphenateException(1, "attribute " + (String)var1_2 + " not found");
        }
        throw new HyphenateException(1, "attribute " + (String)var1_2 + " can not be null or empty");
    }

    public ChatType getChatType() {
        Object this_ = ((EMAMessage)this_.emaObject).chatType();
        ChatType chatType = ChatType.Chat;
        if (this_ != EMAMessage.EMAChatType.SINGLE) {
            chatType = this_ == EMAMessage.EMAChatType.GROUP ? ChatType.GroupChat : ChatType.ChatRoom;
        }
        return chatType;
    }

    /*
     * WARNING - void declaration
     */
    public void setChatType(ChatType chatType) {
        EMAMessage.EMAChatType eMAChatType = EMAMessage.EMAChatType.SINGLE;
        if (chatType != ChatType.Chat) {
            void var1_1;
            eMAChatType = var1_1 == ChatType.GroupChat ? EMAMessage.EMAChatType.GROUP : EMAMessage.EMAChatType.CHATROOM;
        }
        ((EMAMessage)this.emaObject).setChatType(eMAChatType);
    }

    public int describeContents() {
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    public void writeToParcel(Parcel out, int flags) {
        void var1_1;
        var1_1.writeString(this.getMsgId());
        out.writeLong(((EMAMessage)this.emaObject).getNativeHandler());
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    public boolean isAcked() {
        return ((EMAMessage)this.emaObject).isAcked();
    }

    /*
     * WARNING - void declaration
     */
    public void setAcked(boolean isAcked) {
        void var1_1;
        ((EMAMessage)this.emaObject).setIsAcked((boolean)var1_1);
    }

    public boolean isDelivered() {
        return ((EMAMessage)this.emaObject).isDeliverAcked();
    }

    /*
     * WARNING - void declaration
     */
    public void setDelivered(boolean isDelivered) {
        void var1_1;
        ((EMAMessage)this.emaObject).setIsDeliverAcked((boolean)var1_1);
    }

    public boolean isUnread() {
        return ((EMAMessage)this.emaObject).isRead() ^ true;
    }

    /*
     * WARNING - void declaration
     */
    public void setUnread(boolean unread) {
        void var1_1;
        EMLog.d(TAG, "setUnread unread: " + (boolean)var1_1 + " msgId: " + this.getMsgId());
        ((EMAMessage)this.emaObject).setIsRead((var1_1 ^ 1) != 0);
    }

    public boolean isListened() {
        return ((EMAMessage)this.emaObject).isListened();
    }

    /*
     * WARNING - void declaration
     */
    public void setListened(boolean isListened) {
        void var1_1;
        ((EMAMessage)this.emaObject).setListened((boolean)var1_1);
    }

    public String getUserName() {
        return this.getFrom() != null && this.getFrom().equals(EMClient.getInstance().getCurrentUser()) ? this.getTo() : this.getFrom();
    }

    /*
     * WARNING - void declaration
     */
    public void setDeliverAcked(boolean isDeliverAcked) {
        void var1_1;
        ((EMAMessage)this.emaObject).setIsDeliverAcked((boolean)var1_1);
    }

    public int progress() {
        return ((EMAMessage)this.emaObject).progress();
    }

    /*
     * WARNING - void declaration
     */
    public void setProgress(int progress) {
        void var1_1;
        ((EMAMessage)this.emaObject).setProgress((int)var1_1);
    }

    public Direct direct() {
        if (((EMAMessage)this.emaObject).direction() == EMAMessage.EMADirection.SEND) {
            return Direct.SEND;
        }
        return Direct.RECEIVE;
    }

    /*
     * WARNING - void declaration
     */
    public void setDirection(Direct dir) {
        void var1_1;
        ((EMAMessage)this.emaObject).setDirection(var1_1.ordinal());
    }

    public String conversationId() {
        return ((EMAMessage)this.emaObject).conversationId();
    }

    public Map<String, Object> ext() {
        return ((EMAMessage)this.emaObject).ext();
    }

    public Map<String, Object> getAttributes() {
        return ((EMAMessage)this.emaObject).getAttributes();
    }

    public List<EMMessageReaction> getMessageReaction() {
        Object this_ = ((EMAMessage)((EMBase)this_).emaObject).reactionList();
        if (this_.size() > 0) {
            ArrayList<EMMessageReaction> arrayList;
            ArrayList<EMMessageReaction> arrayList2 = arrayList;
            arrayList = new ArrayList<EMMessageReaction>(this_.size());
            this_ = this_.iterator();
            while (this_.hasNext()) {
                EMAMessageReaction eMAMessageReaction = (EMAMessageReaction)this_.next();
                arrayList2.add(new EMMessageReaction(eMAMessageReaction));
            }
            return arrayList2;
        }
        return null;
    }

    public boolean isOnlineState() {
        return ((EMAMessage)this.emaObject).isOnlineState();
    }

    /*
     * WARNING - void declaration
     */
    public void setPriority(EMChatRoomMessagePriority priority) {
        void var1_1;
        ((EMAMessage)this.emaObject).setPriority((EMChatRoomMessagePriority)var1_1);
    }

    public boolean isDeliverOnlineOnly() {
        return ((EMAMessage)this.emaObject).isDeliverOnlineOnly();
    }

    /*
     * WARNING - void declaration
     */
    public void deliverOnlineOnly(boolean onlineOnly) {
        void var1_1;
        ((EMAMessage)this.emaObject).deliverOnlineOnly((boolean)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setReceiverList(List<String> receiverList) {
        void var1_1;
        ((EMAMessage)this.emaObject).setReceiverList((List<String>)var1_1);
    }

    public List<String> receiverList() {
        return ((EMAMessage)this.emaObject).receiverList();
    }

    public boolean isBroadcast() {
        return ((EMAMessage)this.emaObject).isBroadcast();
    }

    public boolean isContentReplaced() {
        return ((EMAMessage)this.emaObject).isContentReplaced();
    }

    public EMMessagePinInfo pinnedInfo() {
        EMAMessagePinInfo this_ = ((EMAMessage)((EMBase)((Object)this_)).emaObject).pinedInfo();
        if (this_ != null) {
            return new EMMessagePinInfo(this_);
        }
        return null;
    }

    public static enum Status {
        SUCCESS,
        FAIL,
        INPROGRESS,
        CREATE;

    }

    public static enum Type {
        TXT,
        IMAGE,
        VIDEO,
        LOCATION,
        VOICE,
        FILE,
        CMD,
        CUSTOM,
        COMBINE;

    }

    public static enum ChatType {
        Chat,
        GroupChat,
        ChatRoom;

    }

    static class EMCallbackHolder
    implements EMCallBack {
        private EMCallBack strong;
        private WeakReference<EMCallBack> weak;
        EMCallBack innerCallback = null;

        /*
         * WARNING - void declaration
         */
        EMCallbackHolder(EMCallBack callback) {
            void var1_1;
            WeakReference<void> weakReference;
            WeakReference<void> this_ = weakReference;
            weakReference = new WeakReference<void>(var1_1);
            v1.weak = this_;
        }

        /*
         * WARNING - void declaration
         */
        synchronized void update(EMCallBack callback) {
            WeakReference<void> weakReference;
            void var1_1;
            if (((EMCallbackHolder)((Object)this_)).strong != null) {
                ((EMCallbackHolder)((Object)this_)).strong = var1_1;
                return;
            }
            EMCallbackHolder eMCallbackHolder = this_;
            WeakReference<void> this_ = weakReference;
            weakReference = new WeakReference<void>(var1_1);
            eMCallbackHolder.weak = this_;
        }

        synchronized void makeItStrong() {
            if (this.strong != null) {
                return;
            }
            WeakReference<EMCallBack> weakReference = this.weak;
            if (weakReference != null && weakReference.get() != null) {
                this.strong = (EMCallBack)this.weak.get();
            }
        }

        synchronized void release() {
            if (this.strong == null) {
                return;
            }
            EMCallbackHolder eMCallbackHolder = this;
            eMCallbackHolder.weak = new WeakReference<EMCallBack>(this.strong);
            eMCallbackHolder.strong = null;
        }

        synchronized EMCallBack getRef() {
            EMCallBack eMCallBack = ((EMCallbackHolder)((Object)this_)).strong;
            if (eMCallBack != null) {
                return eMCallBack;
            }
            WeakReference<EMCallBack> this_ = ((EMCallbackHolder)((Object)this_)).weak;
            if (this_ != null) {
                if ((this_ = (EMCallBack)this_.get()) == null) {
                    EMLog.d(EMMessage.TAG, "getRef weak:" + this_);
                }
                return this_;
            }
            return null;
        }

        @Override
        public void onSuccess() {
            EMCallBack eMCallBack = this.innerCallback;
            if (eMCallBack != null) {
                eMCallBack.onSuccess();
            }
            if ((eMCallBack = this.getRef()) != null) {
                eMCallBack.onSuccess();
                this.release();
            } else {
                EMLog.d(EMMessage.TAG, "CallbackHolder getRef: null");
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void onError(int code, String error) {
            void var2_2;
            void var1_1;
            EMCallBack eMCallBack = this.innerCallback;
            if (eMCallBack != null) {
                eMCallBack.onError((int)var1_1, (String)var2_2);
            }
            if ((eMCallBack = this.getRef()) != null) {
                eMCallBack.onError((int)var1_1, (String)var2_2);
                this.release();
            } else {
                EMLog.d(EMMessage.TAG, "CallbackHolder getRef: null");
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void onProgress(int progress, String status) {
            void var2_2;
            void var1_1;
            EMCallBack eMCallBack = ((EMCallbackHolder)this).innerCallback;
            if (eMCallBack != null) {
                eMCallBack.onProgress((int)var1_1, (String)var2_2);
            }
            if ((this = ((EMCallbackHolder)this).getRef()) != null) {
                this.onProgress((int)var1_1, (String)var2_2);
            }
        }
    }

    public static enum Direct {
        SEND,
        RECEIVE;

    }

    public static enum EMChatRoomMessagePriority {
        PriorityHigh,
        PriorityNormal,
        PriorityLow;

    }
}

