package com.hyphenate.chat.adapter;

import java.util.List;

public class EMATranslateManager extends EMABase {

    public boolean updateTranslation(EMATranslateResult result){
        return nativeUpdateTranslation(result);
    }

    public EMATranslateResult getTranslationResultByMsgId(String msgId){
        return nativeGetTranslationResultByMsgId(msgId);
    }

    public List<EMATranslateResult> loadTranslateResults(int count){
        return nativeLoadTranslateResults(count);
    }

    public boolean removeTranslationsByMsgId(List<String> msgIds){
        return nativeRemoveTranslationsByMsgId(msgIds);
    }

    public boolean removeTranslationsByConversationId(String conversationId){
        return nativeRemoveTranslationsByConversationId(conversationId);
    }

    public boolean removeAllTranslations(){
        return nativeRemoveAllTranslations();
    }

    native boolean nativeUpdateTranslation(EMATranslateResult result);

    native EMATranslateResult nativeGetTranslationResultByMsgId(String msgId);

    native List<EMATranslateResult> nativeLoadTranslateResults(int count);

    native boolean nativeRemoveTranslationsByMsgId(List<String> msgIds);

    native boolean nativeRemoveTranslationsByConversationId(String conversationId);

    native boolean nativeRemoveAllTranslations();
}
