/*
 *  * EaseMob CONFIDENTIAL
 * __________________
 * Copyright (C) 2017 EaseMob Technologies. All rights reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of EaseMob Technologies.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from EaseMob Technologies.
 */
package com.hyphenate.chat.adapter;

import com.hyphenate.chat.EMCursorResult;
import com.hyphenate.chat.adapter.message.EMAMessage;

import java.util.List;
import java.util.Map;

public class EMAThreadManager extends EMABase {

    /**
      * \brief Add a listener to group manager.
      *
      * @param listener A thread manager listener.
      * @return NA
      */
    public void addListener(EMAThreadManagerListener listener) {
    	nativeAddListener(listener);
    }
    native void nativeAddListener(EMAThreadManagerListener listener);

    /**
      * \brief Remove a listener.
      *
      * @param listener  A thread manager listener.
      * @return NA
      */
    public void removeListener(EMAThreadManagerListener listener) {
    	nativeRemoveListener(listener);
	}
    native void nativeRemoveListener(EMAThreadManagerListener listener);

    public EMAThreadInfo createThread(String parentId, String messageId, String threadName, EMAError error) {
        return nativeCreateThread(parentId, messageId, threadName, error);
    }

    native EMAThreadInfo nativeCreateThread(String parentId, String messageId, String threadName, EMAError error);

    /**
     * \brief 从服务器获取 Thread 详情
     * @param threadId
     * @return
     */
    public EMAThreadInfo getThreadFromServer(String threadId, EMAError error) {
        return nativeGetThreadFromServer(threadId, error);
    }

    native EMAThreadInfo nativeGetThreadFromServer(String threadId, EMAError error);

    /**
     * \brief 加入 Thread
     * 群成员均可加入群组下的 Thread。
     * @param threadId
     */
    public EMAThreadInfo joinThread(String threadId, EMAError error) {
        return nativeJoinThread(threadId, error);
    }

    native EMAThreadInfo nativeJoinThread(String threadId, EMAError error);

    /**
     * \brief 销毁 Thread
     * 群主及群管理员有此权限。
     * @param threadId
     */
    public void destroyThread(String threadId, EMAError error) {
        nativeDestroyThread(threadId, error);
    }

    native void nativeDestroyThread(String threadId, EMAError error);

    /**
     * \brief 退出 Thread
     * Thread 成员均可进行此操作。
     * @param threadId
     */
    public void leaveThread(String threadId, EMAError error) {
        nativeLeaveThread(threadId, error);
    }

    native void nativeLeaveThread(String threadId, EMAError error);

    /**
     * \brief 修改 Thread 名称
     * 群主及群管理员有此权限。
     * Thread 创建者有此权限。
     * @param threadId
     * @param threadName
     */
    public void updateChatThreadName(String threadId, String threadName, EMAError error) {
        nativeChangeThreadName(threadId, threadName, error);
    }

    native void nativeChangeThreadName(String threadId, String threadName, EMAError error);

    /**
     * \brief 从 Thread 中删除成员。
     * 群主及群管理员有此权限。
     * @param threadId
     * @param member
     */
    public void removeMemberFromThread(String threadId, String member, EMAError error) {
        nativeRemoveMemberFromThread(threadId, member, error);
    }

    native void nativeRemoveMemberFromThread(String threadId, String member, EMAError error);

    /**
     * \brief 从 Thread 中删除成员。
     * 群主及群管理员有此权限。
     * @param threadId
     * @param members
     */
    public void removeMembersFromThread(String threadId, List<String> members, EMAError error) {
        nativeRemoveMembersFromThread(threadId, members, error);
    }

    native void nativeRemoveMembersFromThread(String threadId, List<String> members, EMAError error);

    /**
     * \brief 分页获取 Thread 成员列表
     * 群成员有此权限。
     * @param threadId
     * @param limit
     * @param cursor
     * @return
     */
    public EMCursorResult<String> fetchThreadMembers(String threadId, int limit, String cursor, EMAError error) {
        return nativeFetchThreadMembers(threadId, limit, cursor, error);
    }

    native EMCursorResult<String> nativeFetchThreadMembers(String threadId, int limit, String cursor, EMAError error);

    /**
     * \brief 分页从服务器端获取当前用户已加入的 Thread 列表
     * @param limit
     * @param cursor
     * @return
     */
    public EMCursorResult<EMAThreadInfo> getJoinedThreadsFromServer(int limit, String cursor, EMAError error) {
        return nativeGetJoinedThreadsFromServer(limit, cursor, error);
    }

    native EMCursorResult<EMAThreadInfo> nativeGetJoinedThreadsFromServer(int limit, String cursor, EMAError error);

    /**
     * \brief 分页从服务器端获取指定群组已加入的 Thread 列表
     * @param parentId 群组 ID
     * @param limit
     * @param cursor
     * @return
     */
    public EMCursorResult<EMAThreadInfo> getJoinedThreadsFromServer(String parentId, int limit, String cursor, EMAError error) {
        return nativeGetJoinedThreadsFromServer(parentId, limit, cursor, error);
    }

    native EMCursorResult<EMAThreadInfo> nativeGetJoinedThreadsFromServer(String parentId, int limit, String cursor, EMAError error);

    /**
     * \brief 分页从服务器端获取指定群组的 Thread 列表
     * @param parentId
     * @param limit
     * @param cursor
     * @return
     */
    public EMCursorResult<EMAThreadInfo> getThreadsFromServer(String parentId, int limit, String cursor, EMAError error) {
        return nativeGetThreadsFromServer(parentId, limit, cursor, error);
    }

    native EMCursorResult<EMAThreadInfo> nativeGetThreadsFromServer(String parentId, int limit, String cursor, EMAError error);

    /**
     * \brief 从服务器端获取指定 Thread 的最近的消息
     * @param threadIds
     * @param error
     * @return
     */
    public Map<String, EMAMessage> getThreadsLatestMessage(List<String> threadIds, EMAError error) {
        return nativeGetThreadsLatestMessage(threadIds, error);
    }

    native Map<String, EMAMessage> nativeGetThreadsLatestMessage(List<String> threadIds, EMAError error);
}
