package com.hyphenate.chat.adapter;


import com.hyphenate.chat.EMCursorResult;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class EMAReactionManager extends EMABase {
    private final Set<EMAReactionManagerListener> mListeners = new HashSet<>();

    public void addReaction(String messageId, String reaction, EMAError error) {
        nativeAddReaction(messageId, reaction, error);
    }

    public void removeReaction(String messageId, String reaction, EMAError error) {
        nativeRemoveReaction(messageId, reaction, error);
    }

    public Map<String, List<EMAMessageReaction>> getReactionList(List<String> messageIdList, String messageType, String groupId, EMAError error) {
        return nativeGetReactionList(messageIdList, messageType, groupId, error);
    }

    public EMCursorResult<EMAMessageReaction> getReactionDetail(String messageId, String reaction, String cursor, int pageSize, EMAError error) {
        return nativeGetReactionDetail(messageId, reaction, cursor, pageSize, error);
    }

    public void addListener(EMAReactionManagerListener listener) {
        mListeners.add(listener);
        nativeAddListener(listener);
    }

    public void removeListener(EMAReactionManagerListener listener) {
        mListeners.remove(listener);
        nativeRemoveListener(listener);
    }

    public void clearListeners() {
        mListeners.clear();
        nativeClearListeners();
    }

    native void nativeAddReaction(String messageId, String reaction, EMAError error);

    native void nativeRemoveReaction(String messageId, String reaction, EMAError error);

    native Map<String, List<EMAMessageReaction>> nativeGetReactionList(List<String> messageIdList, String messageType, String groupId, EMAError error);

    native EMCursorResult<EMAMessageReaction> nativeGetReactionDetail(String messageId, String reaction, String cursor, int pageSize, EMAError error);

    native void nativeAddListener(EMAReactionManagerListener listener);

    native void nativeRemoveListener(EMAReactionManagerListener listener);

    native void nativeClearListeners();
}
