package com.hyphenate.chat.adapter;

import static android.util.Base64.decode;
import static com.hyphenate.chat.adapter.EMAREncryptUtils.B64_ENCODE_FLAG.ONESDK_B64_NO_WRAP;

import android.util.Base64;

import com.hyphenate.util.EMLog;

import java.nio.ByteBuffer;
import java.security.Key;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.X509EncodedKeySpec;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;

import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;


/**
 * Created by linan on 17/6/6.
 */

public class EMAREncryptUtils {

    enum B64_ENCODE_FLAG {
        ONESDK_B64_DEFAULT,
        ONESDK_B64_NO_WRAP
    }

    public static final String TAG = "EMAREncryptUtils";

    private Cipher gcmEncryptCipher;

    public static byte[] generateAESKey(int keyLen) {
        try {
            KeyGenerator keyGenerator = KeyGenerator.getInstance("AES");
            keyGenerator.init(keyLen * 8);
            SecretKey secretKey = keyGenerator.generateKey();
            return secretKey.getEncoded();
        } catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static byte[] generateAESKey256() {
        try {
            KeyGenerator keyGenerator = KeyGenerator.getInstance("AES");
            keyGenerator.init(256);
            SecretKey secretKey = keyGenerator.generateKey();
            return secretKey.getEncoded();
        } catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static String b64Encode(byte[] data, int b64Flag) {
        return Base64.encodeToString(data, 0, data.length, b64Flag == ONESDK_B64_NO_WRAP.ordinal() ? Base64.NO_WRAP : Base64.DEFAULT);
    }

    public static byte[] b64Decode(String encryptedMsg) {
        return decode(encryptedMsg, Base64.DEFAULT);
    }

    public static byte[] b64Decode(String encryptedMsg, int b64Flag) {
        return decode(encryptedMsg, b64Flag == ONESDK_B64_NO_WRAP.ordinal() ? Base64.NO_WRAP : Base64.DEFAULT);
    }

    public void initAESgcm(byte[] keyBytes) {
        try {
            SecretKeySpec spec = new SecretKeySpec(keyBytes, "AES");
            SecureRandom secureRandom = new SecureRandom();
            byte[] iv = new byte[12]; // The initial vector must never be reused when using the same key
            secureRandom.nextBytes(iv);
            GCMParameterSpec parameterSpec = new GCMParameterSpec(128, iv);

            gcmEncryptCipher = Cipher.getInstance("AES/GCM/NoPadding");
            gcmEncryptCipher.init(Cipher.ENCRYPT_MODE, spec, parameterSpec);
            EMLog.d("encrypt", "init for AES gcm");
        } catch (Exception e) {
            e.printStackTrace();
            EMLog.d(TAG, Arrays.toString(e.getStackTrace()));
        }
    }

    public String aesGcmEncrypt(String plainMsg, int b64Flag) {
        try {
            byte[] stringBytes = plainMsg.getBytes("UTF-8");
            byte[] encryptedBytes = gcmEncryptCipher.doFinal(stringBytes);
            byte[] iv = gcmEncryptCipher.getIV();
            ByteBuffer byteBuffer = ByteBuffer.allocate(1 + iv.length + encryptedBytes.length);
            byteBuffer.put((byte) iv.length);
            byteBuffer.put(iv);
            byteBuffer.put(encryptedBytes);
            return b64Encode(byteBuffer.array(), b64Flag);
        } catch (Exception e) {
            e.printStackTrace();
            EMLog.d(TAG, Arrays.toString(e.getStackTrace()));
        }
        return null;
    }

    public String aesGcmDecrypt(String encryptedMsg, byte[] keyBytes, int b64Flag) {
        try {
            byte[] b64Out = b64Decode(encryptedMsg, b64Flag);
            ByteBuffer byteBuffer = ByteBuffer.wrap(b64Out);
            byte[] iv = new byte[byteBuffer.get()];
            byteBuffer.get(iv);

            byte[] cipherText = new byte[byteBuffer.remaining()];
            byteBuffer.get(cipherText);

            GCMParameterSpec parameterSpec = new GCMParameterSpec(128, iv);
            Cipher decipher = Cipher.getInstance("AES/GCM/NoPadding");
            decipher.init(Cipher.DECRYPT_MODE, new SecretKeySpec(keyBytes, "AES"), parameterSpec);
            byte[] decryptedBytes = decipher.doFinal(cipherText);
            return new String(decryptedBytes);
        } catch (Exception e) {
            e.printStackTrace();
            EMLog.d(TAG, Arrays.toString(e.getStackTrace()));
        }
        return null;
    }

    /**
     * publicKey is b64 encode string
     * data is raw data to be encrypted
     * return is b64 encode string
     */
    public static byte[] encryptByRSAPublicKey(final String key_, final byte[] data, AtomicBoolean success) {

        String key = key_;
        key = key.replace("-----BEGIN PUBLIC KEY-----", "");
        key = key.replace("-----END PUBLIC KEY-----", "");
        key = key.replace("\n", "");

        byte[] keyBytes = Base64.decode(key.getBytes(), Base64.NO_WRAP);
        try {
            X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(keyBytes);
            /**
             * java default implementation is RSA/ECB/PKCS1Padding,
             * but if you directly refer algorithm "RSA／ECB/PKCS1Padding" from KeyFactory,
             * it will report "KeyFactory RSA/ECB/PKCS1Padding implementation not found"
             */
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            Key publicKey = keyFactory.generatePublic(x509KeySpec);
            EMLog.d(TAG, "publicKey.getFormat:" + publicKey.getFormat());

            Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
            cipher.init(Cipher.ENCRYPT_MODE, publicKey);
            byte[] result = cipher.doFinal(data);
            success.set(true);
            return result;
        } catch (Exception e) {
            e.printStackTrace();
            EMLog.d(TAG, Arrays.toString(e.getStackTrace()));
        }
        return null;
    }

    /**
     * MessageDigest, default using MD5
     * @param type
     * @param data
     * @return
     */
    public static String messageDigest(int type, final byte[] data) {
        MessageDigest messageDigest = null;
        try{
            if(type == 1) {
                messageDigest = MessageDigest.getInstance("SHA-256");
            }else {
                messageDigest = MessageDigest.getInstance("MD5");
            }
        }catch(Exception e){
            e.printStackTrace();
        }
        byte[] digest = null;
        if (messageDigest != null) {
            digest = messageDigest.digest(data);
        }
        // to hex
        StringBuffer buff = new StringBuffer();
        if (digest != null) {
            for (int i = 0; i < digest.length; i++) {
                int num = ((int) digest[i]) & 0xff;
                if (num < 16)
                    buff.append("0");
                buff.append(Integer.toHexString(num));
            }
        }
        return buff.toString();
    }

}
