package com.hyphenate.chat.adapter;

import java.util.List;

/**
 * Created by linan on 17/4/17.
 */

public interface EMAMultiDeviceListenerInterface {

    /**
     * Multi-device contact event.
     * @param event
     * @param target
     * @param ext
     */
    void onContactEvent(int event, String target, String ext);

    /**
     * Multi-device group event.
     * @param event
     * @param target
     * @param username
     */
    void onGroupEvent(int event, String target, List<String> username);

    /**
     * Multi-device thread event.
     * @param event
     * @param target
     * @param username
     */
    void onThreadEvent(int event, String target, List<String> username);

    /**
     * Multi-device event of historical message deletion from the server.
     * @param conversation
     * @param deviceId
     */
    void onRoamDeleteEvent(String conversation,List<String> msgIdList,String deviceId,long beforeTimeStamp);

    /**
     * Multi-device conversation event.
     * @param event
     * @param conversationId
     * @param type
     */
    void onConversationEvent(int event, String conversationId, int type);

}
