/*
 *  * EaseMob CONFIDENTIAL
 * __________________
 * Copyright (C) 2017 EaseMob Technologies. All rights reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of EaseMob Technologies.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from EaseMob Technologies.
 */
package com.hyphenate.chat.adapter;

import com.hyphenate.chat.EMCursorResult;

import java.util.HashSet;
import java.util.List;
import java.util.Set;

/**
 * Easemob Adapter
 * @author linan
 *
 */
public class EMAContactManager extends EMABase {

    // used to keep reference of listener, JNI part will not track the reference
    // that's to avoid GC listeners.
	private Set<EMAContactListener> listeners = new HashSet<EMAContactListener>();

	public void inviteContact(String username, String message, EMAError error)
	{
		nativeInviteContact(username, message, error);
	}
	
	public void deleteContact(String username, EMAError error, boolean keepConversation)
	{
		nativeDeleteContact(username, error, keepConversation);
	}
	
	public List<String> getContactsFromServer(EMAError error) {
		return nativeGetContactsFromServer(error);
	}

	public List<String> getContactsFromDB(EMAError error) {
		return nativeGetContactsFromDB(error);
	}
	
    public void acceptInvitation(String username, EMAError error)
    {
    	nativeAcceptInvitation(username, error);
    }
    
    public void declineInvitation(String username, EMAError error)
    {
    	nativeDeclineInvitation(username, error);
    }
    
    public void setSupportRosterVersion(boolean supportRosterVersion)
    {
    	nativeSetSupportRosterVersion(supportRosterVersion);
    }
    
    public void registerContactListener(EMAContactListener listener)
    {
    	listeners.add(listener);
    	nativeRegisterContactListener(listener);
    }

    public void removeContactListener(EMAContactListener listener)
    {
    	listeners.remove(listener);
    	nativeRemoveContactListener(listener);
    }

    public List<String> getBlackListFromServer(EMAError error)
    {
    	return nativeGetBlackListFromServer(error);
    }

    public List<String> getBlackListFromDB(EMAError error)
    {
    	return nativeGetBlackListFromDB(error);	
    }

    public void saveBlackList(List<String> blacklist, EMAError error)
    {
    	nativeSaveBlackList(blacklist, error);
    }

    public void addToBlackList(String username, boolean both, EMAError error)
    {
    	nativeAddToBlackList(username, both, error);
    }

    public void removeFromBlackList(String username, EMAError error)
    {
    	nativeRemoveFromBlackList(username, error);
    }

    public List<String> getSelfIdsOnOtherPlatform(EMAError error)
    {
        return nativeGetSelfIdsOnOtherPlatform(error);
    }

    public void setContactRemark(String username, String remark, EMAError error){
        nativeSetContactRemark(username, remark, error);
    }
    public EMAContact fetchContactFromLocal(String username, EMAError error) {
      return   nativeFetchContactFromLocal(username, error);
    }
    public List<EMAContact> fetchAllContactsFromLocal(EMAError error) {
        return nativeFetchAllContactsFromLocal(error);
    }
    public List<EMAContact> fetchAllContactsFromServer(EMAError error) {
        return nativeFetchAllContactsFromServer(error);
    }
    public EMCursorResult<EMAContact> fetchAllContactsFromServer(int limit, String cursor, EMAError error) {
        return nativeFetchAllContactsFromServer_(limit, cursor, error);
    }

    public EMAContactManager() {
    }

    public EMAContactManager(EMAContactManager old) {
    	nativeInit(old);
    }
	
    native void nativeInviteContact(String username, String message, EMAError error);
    native void nativeDeleteContact(String username, EMAError error, boolean keepConveration);
    native List<String> nativeGetContactsFromServer(EMAError error);
    native List<String> nativeGetContactsFromDB(EMAError error);
    native void nativeAcceptInvitation(String username, EMAError error);
    native void nativeDeclineInvitation(String username, EMAError error);
    native void nativeSetSupportRosterVersion(boolean supportRosterVersion);
    native void nativeRegisterContactListener(EMAContactListener listener);
    native void nativeRemoveContactListener(EMAContactListener listener);
    native List<String> nativeGetBlackListFromServer(EMAError error);
    native List<String> nativeGetBlackListFromDB(EMAError error);
    native void nativeSaveBlackList(List<String> blacklist, EMAError error);
    native void nativeAddToBlackList(String username, boolean both, EMAError error);
    native void nativeRemoveFromBlackList(String username, EMAError error);
    native List<String> nativeGetSelfIdsOnOtherPlatform(EMAError error);
    native void nativeInit(EMAContactManager old);

    native void nativeSetContactRemark(String username, String remark, EMAError error);
    native EMAContact nativeFetchContactFromLocal(String username, EMAError error) ;
    native List<EMAContact> nativeFetchAllContactsFromLocal(EMAError error) ;
    native List<EMAContact> nativeFetchAllContactsFromServer(EMAError error) ;
    native EMCursorResult<EMAContact> nativeFetchAllContactsFromServer_(int limit, String cursor, EMAError error) ;
}
