package com.hyphenate.chat;

import android.os.AsyncTask;

import com.hyphenate.cloud.EMHttpClient;
import com.hyphenate.cloud.HttpClientManager;
import com.hyphenate.cloud.HttpResponse;
import com.hyphenate.util.EMLog;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

@Deprecated
class EMTranslator {

    private static EMTranslateParams mParams;

    static final String mGetLanguagePath = "/languages?api-version=3.0";
    static final String mTranslatePath = "/translate?api-version=3.0";

    interface TranslationCallback {
        void onResult(String Result, String ErrorText);
    }

    EMTranslator(EMTranslateParams params)
    {
        mParams = params;
        mParams.EndPoint = mParams.EndPoint.replaceAll("/$", "");
    }

    List<EMLanguage> getSupportedLanguages() {
        String url_str =  mParams.EndPoint + mGetLanguagePath;
        List<EMLanguage> result = new ArrayList<EMLanguage>();

        try {
            HttpResponse response = HttpClientManager.httpExecute(url_str, new HashMap<>(), "", EMHttpClient.GET);
            if(response.code == 200) {
                result = getLanguageListFromResponse(response.content);
            }
        } catch (Exception ex) {
            ex.printStackTrace();
        }

        return result;
    }


    void translate(String text, String languageCode, TranslationCallback callback) {
        new AsyncTask<String, Void, HttpResponse>(){
            @Override
            protected HttpResponse doInBackground(String... str) {
                try {
                    String url = mParams.EndPoint + mTranslatePath + "&to=" + languageCode;
                    JSONArray body = new JSONArray();
                    JSONObject obj = new JSONObject();
                    obj.put("Text", text);
                    body.put(obj);
                    HashMap<String, String> headers = new HashMap<>();
                    headers.put("Ocp-Apim-Subscription-Key", mParams.SubscriptionKey);
                    headers.put("Content-Type", "application/json; charset=UTF-8");
                    HttpResponse response = HttpClientManager.httpExecute(url,headers, body.toString(), EMHttpClient.POST);
                    return response;
                }catch (Exception exception) {
                    exception.printStackTrace();
                }
                return  null;
            }
            @Override
            protected void onPostExecute(HttpResponse response) {
                if (response != null) {
                    try {
                        int resCode = response.code;
                        if (resCode == 200) {
                            String responseInfo = response.content;
                            if (responseInfo != null && responseInfo.length() > 0) {
                                String result = getTranslationFromResponse(responseInfo);
                                String translatedText = getTranslatedText(result);
                                callback.onResult(translatedText, "");
                                return;
                            }
                        } else {
                            EMLog.d("EMTranslator", resCode + ":" + response.content);
                        }
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                callback.onResult("", "Fail to translation");
            }
        }.execute();
    }

    String getTranslatedText(String translationMessage) {
        String result = "";

        try {
            JSONObject mainObject = new JSONObject((translationMessage));

            Object translationObject = mainObject.getJSONArray("translations").get(0);
            if(translationObject instanceof JSONObject) {
                result =  ((JSONObject)translationObject).getString("text");
            }
        }catch (JSONException ex) {
            ex.printStackTrace();
        }

        return result;
    }

    private String getTranslationFromResponse(String response) {
        String result = "";

        try {
            JSONArray mainObject = new JSONArray((response));

            //get first translation
            result = mainObject.get(0).toString();
        }catch (JSONException ex) {
            ex.printStackTrace();
        }

        return result;
    }

    private List<EMLanguage> getLanguageListFromResponse(String response) {
        List<EMLanguage> result = new ArrayList<EMLanguage>();

        try {
            JSONObject mainObject = new JSONObject(response);
            JSONObject languageListObject = mainObject.getJSONObject("translation");

            Iterator<String> keys = languageListObject.keys();

            while(keys.hasNext()) {
                String key = keys.next();
                Object languageObject = (JSONObject) languageListObject.get(key);

                if (languageObject instanceof JSONObject) {
                    EMLanguage language = new EMLanguage();
                    language.LanguageCode = key;
                    language.LanguageName = ((JSONObject)languageObject).getString("name");
                    language.LanguageLocalName = ((JSONObject)languageObject).getString("nativeName");

                    result.add(language);
                }
            }

        } catch(Exception ex) {
            ex.printStackTrace();
        }

        return result;
    }
}
