package com.hyphenate.chat;

import com.hyphenate.chat.adapter.EMASilentModeParam;

/**
 * \~chinese
 * 离线推送参数实体类。
 *
 * \~english
 * The offline push parameter entity class.
 *
 */
public class EMSilentModeParam extends EMBase<EMASilentModeParam> {

    /**
     * \~chinese
     * 离线推送免打扰参数类型枚举类。
     *
     * \~english
     * The do-not-disturb parameter types for offline push.
     */
    public enum EMSilentModeParamType{
        /**
         * \~chinese
         * 离线推送通知类型。
         *
         * \~english
         * Offline push notification type.
         */
        REMIND_TYPE,
        /**
         * \~chinese
         * 离线推送免打扰时长。
         *
         * \~english
         * The do-not-disturb duration for offline push.
         */
        SILENT_MODE_DURATION,
        /**
         *  \~chinese
         *  离线推送免打扰时间段。
         *
         *  \~english
         *  The do-not-disturb time frame for offline push.
         */
        SILENT_MODE_INTERVAL
    }

    /**
     * \~chinese
     * 有参构造。
     * @param paramType 参数类型。
     *
     * \~english
     * Parameterized constructor.
     * 
     * @param paramType The parameter type.
     */
    public EMSilentModeParam(EMSilentModeParamType paramType){
        emaObject = new EMASilentModeParam();
        emaObject.setParamType(paramType.ordinal());
    }

    public EMSilentModeParam(EMASilentModeParam param){
        emaObject = param;
    }

    /**
     * \~chinese
     * 设置参数类型。
     * @param paramType 参数类型。
     *
     * \~english
     * Sets the parameter type.
     * 
     * @param paramType The parameter type.
     *
     */
    public EMSilentModeParam setParamType(EMSilentModeParamType paramType){
        emaObject.setParamType(paramType.ordinal());
        return this;
    }

    /**
     * \~chinese
     * 设置离线推送通知类型。
     * 
     * @param remindType 离线推送通知类型。
     *
     * \~english
     * Sets the offline push notification type.
     * 
     * @param remindType The offline push notification type.
     *
     */
    public EMSilentModeParam setRemindType(EMPushManager.EMPushRemindType remindType){
        emaObject.setRemindType(remindType.ordinal() + 1);
        return this;
    }

    /**
     * \~chinese
     * 设置离线推送免打扰时长。
     * 
     * @param silentDuration 离线推送免打扰时长，单位分钟。
     *
     * \~english
     * Sets the do-not-disturb duration for offline push.
     * 
     * @param silentDuration The do-not-disturb duration in minutes.
     *
     */
    public EMSilentModeParam setSilentModeDuration(int silentDuration){
        emaObject.setSilentDuration(silentDuration);
        return this;
    }

    /**
     * \~chinese
     * 设置离线推送免打扰时间段。
     * 
     * @param startTime 免打扰开始时间。
     * @param endTime 免打扰结束时间。
     *
     * \~english
     * Sets the do-not-disturb time frame for offline push.
     * 
     * @param startTime The start time of the do-not-disturb time frame.
     * @param endTime The end time of the do-not-disturb time frame.
     *
     */
    public EMSilentModeParam setSilentModeInterval(EMSilentModeTime startTime, EMSilentModeTime endTime){
        emaObject.setStartTime(startTime.emaObject);
        emaObject.setEndTime(endTime.emaObject);
        return this;
    }
}
