package com.hyphenate.chat;


import com.hyphenate.chat.adapter.EMAMessageReaction;

import java.util.List;

/**
 * \~chinese
 * 消息 Reaction 实体类，有如下属性：
 *
 *   Reaction：消息 Reaction。
 *   UserCount：添加了指定 Reaction 的用户数量。
 *   UserList：添加了指定 Reaction 的用户列表。
 *   isAddedBySelf 当前用户是否添加了该 Reaction。
 *
 * \~english
 * The message Reaction instance class, which has the following attributes:
 *
 *   Reaction: The message Reaction.
 *   UserCount: The count of users that added the Reaction.
 *   UserList: The list of users that added the Reaction.
 *   isAddedBySelf: Whether the current user added this Reaction.
 */
public class EMMessageReaction extends EMBase<EMAMessageReaction> {

    public EMMessageReaction(EMAMessageReaction messageReaction) {
        emaObject = messageReaction;
    }

    /**
     * \~chinese
     * 获取 Reaction 内容。
     * @return Reaction。
     *
     * \~english
     * Gets the Reaction.
     * @return The Reaction.
     */
    public String getReaction() {
        return emaObject.reaction();
    }

    /**
     * \~chinese
     * 获取添加了指定 Reaction 的用户数量。
     * @return 用户数量。
     *
     * \~english
     * Gets the count of users that added this Reaction.
     * @return The count of users that added the Reaction.
     */
    public int getUserCount() {
        return emaObject.count();
    }

    /**
     * \~chinese
     * 获取添加了指定 Reaction 的用户列表。
     *
     * @note
     *  只有通过 {@link #getReactionDetail(EMChatManager)} 接口获取的是全部用户的分页数据；其他相关接口如 {@link #getMessageReaction(EMMessage)}、{@link #getReactionList(EMChatManager)} 或者 {@link onReactionChanged(EMMessageListener)} 等都只包含前三个用户。
     *
     * @return 用户列表。
     *
     * \~english
     * Gets the list of users that added this Reaction.
     *
     * @note
     * {@link #getReactionDetail(EMChatManager)} can return the entire list of users that added this Reaction with pagination, whereas other methods such as {@link #getMessageReaction(EMMessage)}, {@link #getReactionList(EMChatManager)}, and {@link onReactionChanged(EMMessageListener)} can only return the first three users.
     * @return  The list of users that added this Reaction.
     */
    public List<String> getUserList() {
        return emaObject.userList();
    }

    /**
     * \~chinese
     * 获取当前用户是否添加过该 Reaction。
     *
     * @return 当前用户是否添加过指定 Reaction。
     *  - `true`：是；
     *  - `false`：否。
     *
     * \~english
     * Gets whether the current user has added the Reaction.
     *
     * @return  Whether the current user has added the Reaction.
     *  - `true`: Yes.
     *  - `false`: No.
     */
    public boolean isAddedBySelf() {
        return emaObject.state();
    }
}