package com.hyphenate.chat;

import com.hyphenate.chat.adapter.message.EMAMessagePinInfo;

/**
 * \~chinese
 * 消息置顶详情。
 *
 * \~english
 * The message pinning information.
 */
public class EMMessagePinInfo extends EMBase<EMAMessagePinInfo> {

    /**
     * \~chinese
     * 置顶消息的操作枚举类。
     *
     * \~english
     * The message pinning and unpinning operations.
     */
    public enum PinOperation {
        PIN,
        UNPIN
    }

    /**
     * \~chinese
     * 构造器。
     * \~english
     * Constructor.
     */
    protected EMMessagePinInfo() {
        emaObject = new EMAMessagePinInfo();
    }

    /**
     * \~chinese
     * 构造器。
     * @param emaObject emaObject
     * \~english
     * Constructor.
     * @param emaObject emaObject
     */
    protected EMMessagePinInfo(EMAMessagePinInfo emaObject) {
        this.emaObject = emaObject;
    }

    /**
     * \~chinese
     * 
     * 置顶消息的操作者的用户 ID.
     * 
     * @return 置顶消息的操作者的用户 ID。
     * \~english
     * 
     * The user ID of the operator that pins the message.
     * 
     * @return The user ID of the operator that pins the message.
     */
    public String operatorId() {
        if (emaObject != null) {
            return emaObject.pinnedBy();
        }
        return null;
    }
    /**
     * \~chinese
     * 置顶时间。
     * 
     * @return 置顶时间。
     * \~english
     * The time when the message is pinned.
     * @return When the message is pinned.
     */
    public long pinTime() {
        if (emaObject != null) {
            return emaObject.pinnedAt();
        }
        return 0;
    }
}
