/*
 *  * EaseMob CONFIDENTIAL
 * __________________
 * Copyright (C) 2017 EaseMob Technologies. All rights reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of EaseMob Technologies.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from EaseMob Technologies.
 */
package com.hyphenate;

/**
 *  \~chinese
 *  联系人监听器。
 *  监听联系人变化，包括添加好友的申请，对方删除好友的通知，对方同意好友请求，对方拒绝好友请求。
 *  
 *  示例如下：
 *      注册联系人监听：
 *      ```java
 *      EMClient.getInstance().contactManager().setContactListener(mContactListener);
 *      ```
 * 
 *      解注册联系人监听：
 *      ```
 *      EMClient.getInstance().contactManager().removeContactListener(mContactListener);
 *      ```
 *
 *  \~english
 *  The contact updates listener.
 * 
 *  Listen for the contact changes, including requests to add friends, notifications to delete friends,
 *  requests to accept friends, and requests to reject friends.
 * 
 *     Register listener：
 *     ```java
 *     EMClient.getInstance().contactManager().setContactListener(mContactListener);
 *     ```
 * 
 *     Unregister listener：
 *     ```java
 *     EMClient.getInstance().contactManager().removeContactListener(mContactListener);
 *     ```
 */
public interface EMContactListener {
    
    /**
     * \~chinese
     * 增加联系人时回调此方法。
     * @param username 增加的联系人。
     * 
     * \~english
     * Occurs when user is added as a contact by another user.
     * @param username   The new contact to be added.
     */
    void onContactAdded(String username);
    
    /**
     * \~chinese
     * 被删除联系人时回调此方法。
     * @param username 删除的联系人。

     *
     * \~english
     * Occurs when a user is removed from the contact list by another user.
     * @param username    The user who is removed from the contact list by another user.
     */
    void onContactDeleted(String username);

    /**
     * \~chinese
     * 收到好友邀请。
     * @param username 发起好友请求的用户。
     * @param reason   对方发起好友邀请时发出的文字性描述。
     *
     * \~english
     * Occurs when a user receives a friend request.
     * @param username    The user who initiated the friend request.
     * @param reason      The invitation message. 
     */
    void onContactInvited(String username, String reason);
    
    /**
     * \~chinese
     * 好友请求被同意。
     * @param username 发起好友请求的用户。
     *
     * \~english
     * Occurs when a friend request is approved.
     * @param username The user who initiated the friend request.
     */
    void onFriendRequestAccepted(String username);

    /**
     * \~chinese
     * 好友请求被拒绝。
     * @param username 发起好友请求的用户。
     *
     * \~english
     * Occurs when a friend request is declined.
     * @param username The user who initiated the friend request.
     */
    void onFriendRequestDeclined(String username);
}
