package com.hyphenate.push.platform.oppo;

import android.content.Context;

import com.heytap.msp.push.HeytapPushManager;
import com.heytap.msp.push.callback.ICallBackResultService;
import com.hyphenate.EMError;
import com.hyphenate.push.EMPushConfig;
import com.hyphenate.push.EMPushHelper;
import com.hyphenate.push.EMPushType;
import com.hyphenate.push.PushListener;
import com.hyphenate.push.platform.IPush;
import com.hyphenate.util.EMLog;

/**
 * Created by zhangsong on 19-2-20
 * <p>
 * 文档地址：https://open.oppomobile.com/wiki/doc#id=10196
 * <p>
 * 应用安装后默认未打开设置中的通知栏通知权限，需要手动打开。
 * <p>
 * 使用Oppo推送需要先在Oppo应用商店上架，该Demo包名被占用，所以使用了新包名：com.hyphenate.chatuidemo.push.
 * 打包时需要修改app/build.gradle中的applicationId和google-service.json中的包名
 */
public class EMOppoPush extends IPush {
    private static final String TAG = "EMOppoPush";

    @Override
    public EMPushType getPushType() {
        return EMPushType.OPPOPUSH;
    }

    @Override
    public void onRegister(Context context, EMPushConfig config, PushListener pushListener) {
        boolean support = HeytapPushManager.isSupportPush(context);
        if (!support) {
            // handle register error.
            EMPushHelper.getInstance().onErrorResponse(getPushType(), EMError.PUSH_NOT_SUPPORT);
            return;
        }

        HeytapPushManager.register(context, config.getOppoAppKey(), config.getOppoAppSecret(),
                new ICallBackResultService() {
                    @Override
                    public void onRegister(int responseCode, String registerID, String packageName ,String miniPackageName) {
                        if (responseCode == 0) {
                            EMPushHelper.getInstance().onReceiveToken(getPushType(), registerID);
                        } else {
                            // handle register error.
                            EMPushHelper.getInstance().onErrorResponse(getPushType(), responseCode);
                        }
                    }

                    @Override
                    public void onUnRegister(int responseCode, String packageName ,String miniPackageName) {

                    }

                    @Override
                    public void onSetPushTime(int responseCode, String pushTime) {

                    }

                    @Override
                    public void onGetPushStatus(int responseCode, int status) {

                    }

                    @Override
                    public void onGetNotificationStatus(int responseCode, int status) {

                    }

                    @Override
                    public void onError(int i, String s, String packageName ,String miniPackageName) {
                        EMLog.e(TAG, "Oppo init failed: " + i + " " + s + packageName + " " + miniPackageName);
                    }
                });
    }

    @Override
    public void onUnregister(Context context) {
    }

    @Override
    public String onGetNotifierName(EMPushConfig config) {
        return config.getOppoAppKey();
    }
}
