package com.hyphenate.push.platform.mi;

import android.content.Context;
import android.text.TextUtils;

import com.hyphenate.push.EMPushConfig;
import com.hyphenate.push.EMPushHelper;
import com.hyphenate.push.EMPushType;
import com.hyphenate.push.PushListener;
import com.hyphenate.push.platform.IPush;
import com.xiaomi.mipush.sdk.MiPushClient;

/**
 * Created by zhangsong on 19-2-20
 * <p>
 * 文档地址：https://dev.mi.com/console/doc/detail?pId=41
 */
public class EMMiPush extends IPush {
    private static final String TAG = "EMMiPush";

    @Override
    public EMPushType getPushType() {
        return EMPushType.MIPUSH;
    }

    @Override
    public void onRegister(Context context, EMPushConfig config, PushListener pushListener) {
        String regId = MiPushClient.getRegId(context);
        if (TextUtils.isEmpty(regId)) {
            MiPushClient.registerPush(context, config.getMiAppId(), config.getMiAppKey());
        } else {
            EMPushHelper.getInstance().onReceiveToken(getPushType(), regId);
        }
    }

    @Override
    public void onUnregister(Context context) {
    }

    @Override
    public String onGetNotifierName(EMPushConfig config) {
        return config.getMiAppId();
    }
}
