/*
 *  * EaseMob CONFIDENTIAL
 * __________________
 * Copyright (C) 2017 EaseMob Technologies. All rights reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of EaseMob Technologies.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from EaseMob Technologies.
 */
package com.hyphenate.chat.adapter.message;

import android.net.Uri;


public class EMAVoiceMessageBody extends EMAFileMessageBody {

	/**
	 * @param localPath
	 * @param duration
	 */
	public EMAVoiceMessageBody(String localPath, int duration) {
		super(localPath, EMAMessageBodyType_VOICE);
		nativeInit(localPath, duration);
	}

	public EMAVoiceMessageBody(Uri localPath, int duration) {
		super(localPath, EMAMessageBodyType_VOICE);
		nativeInit(localPath != null ? localPath.toString() : "", duration);
	}

	public EMAVoiceMessageBody(EMAVoiceMessageBody body) {
		super("", EMAMessageBodyType_VOICE);
		nativeInit(body);
	}
	
	// used by jni_util.cpp: getJObject
	private EMAVoiceMessageBody(){
		super("", EMAMessageBodyType_VOICE);
		nativeInit("", 0);
	}
	
	public int duration() {
		return nativeDuration();
	}
	native int nativeDuration();
	
	public void setDuration(int duration) {
		nativeSetDuration(duration);
	}
	native void nativeSetDuration(int duration);
	
	@Override
	public void finalize() throws Throwable {
		nativeFinalize();
		super.finalize();
	}
	
	native void nativeInit(String localPath, int duration);
	native void nativeInit(EMAVoiceMessageBody body);
	native void nativeFinalize();
	
}
