package com.hyphenate.chat.adapter.message;

import android.net.Uri;

import java.util.List;

public class EMACombineMessageBody extends EMAFileMessageBody{

    public EMACombineMessageBody() {
        super(Uri.parse(""), EMAMessageBodyTYPE_COMBINE);
        nativeInit();
    }

    public EMACombineMessageBody(EMACombineMessageBody body) {
        super(body);
    }

    public void setTitle(String title) {
        nativeSetTitle(title);
    }
    native void nativeSetTitle(String title);

    public String getTitle() {
        return nativeGetTitle();
    }
    native String nativeGetTitle();

    public void setSummary(String summary) {
        nativeSetSummary(summary);
    }
    native void nativeSetSummary(String summary) ;

    public String getSummary() {
        return nativeGetSummary();
    }
    native String nativeGetSummary();

    public void setCompatibleText(String compatibleText) {
        nativeSetCompatibleText(compatibleText);
    }
    native void nativeSetCompatibleText(String compatibleText);

    public String getCompatibleText() {
        return nativeGetCompatibleText();
    }
    native String nativeGetCompatibleText();

    public void setMessageList(List<String> messageList) {
        nativeSetMessageList(messageList);
    }
    native void nativeSetMessageList(List<String> messageList);

    native void nativeInit();
    native void nativeFinalize();
}
