package com.hyphenate.chat;

import com.hyphenate.chat.adapter.EMAMessageStatistics;

public class EMMessageStatistics extends EMBase<EMAMessageStatistics>{

    public EMMessageStatistics(EMAMessageStatistics message) {
        emaObject = message;
    }
    /**
     * \~chinese
     * 获取消息的 ID。
     *
     * @return 消息 ID。
     *
     * \~english
     * Gets the message ID.
     *
     * @return The message ID.
     */
    public String getMsgId() {
        return emaObject.getMsgId();
    }

    /**
     * \~chinese
     * 获取消息接收者的用户 ID。
     *
     * @return  接收者的用户 ID。
     *
     * \~english
     * Gets the user ID of the message recipient.
     *
     * @return The user ID of the message recipient.
     */
    public String getTo() {
        return emaObject.getTo();
    }

    /**
     * \~chinese
     * 获取消息发送方的用户 ID。
     *
     * @return 用户 ID。
     *
     * \~english
     * Gets the user ID of the message sender.
     *
     * @return The user ID of the message sender.
     */
    public String getFrom() {
        return emaObject.getFrom();
    }

    /**
     * \~chinese
     * 获取消息类型。
     *
     * @return  消息类型。
     *
     * \~english
     * Gets the message type.
     *
     * @return The message type.
     */
    public EMMessage.Type getType() {
        return emaObject.getType();
    }

    /**
     * \~chinese
     * 获取聊天类型。
     *
     * @return 聊天类型。
     *
     * \~english
     * Gets the chat type.
     *
     * @return The chat type.
     */
    public EMMessage.ChatType getChatType() {
        return emaObject.getChatType();
    }

    /**
     * \~chinese
     * 获取消息的服务器时间戳。
     *
     * 该时间戳为服务器接收消息的时间，单位为毫秒。
     *
     * @return  服务器接收消息的时间戳。
     *
     * \~english
     * Gets the Unix timestamp when the server receives the message.
     *
     * The Unix timestamp is in the unit of millisecond.
     *
     * @return The Unix timestamp when the server receives the message.
     */
    public long getMsgTime() {
        return emaObject.getMsgTime();
    }

    /**
     * \~chinese
     * 获取消息方向。
     * - SEND：该消息是当前用户发送出去的；
     * - RECEIVE：该消息是当前用户接收到的。
     *
     * @return 发送或接收，详见 {@link com.hyphenate.chat.EMMessage.Direct}。
     *
     * \~english
     * Gets the message direction:
     * - `SEND`: The message is sent from the local client.
     * - `RECEIVE`: The message is received by the local client.
     *
     * @return The message direction. See {@link com.hyphenate.chat.EMMessage.Direct}.
     */
    public EMMessage.Direct direct() {
        return emaObject.direct();
    }

    /**
     * \~chinese
     * 获取消息体的流量大小。
     *
     * 流量的单位为字节。
     *
     * @return 消息体的流量大小。
     *
     * \~english
     * Gets the amount of traffic for the message body.
     *
     * The traffic is measured in bytes.
     *
     * @return The traffic for the message body.
     */
    public long getMsgSize() {
        return emaObject.getMsgSize();
    }

    /**
     * \~chinese
     * 获取消息附件的流量大小。
     *
     * 流量的单位为字节。
     *
     * @return 附件的流量大小。
     *
     * \~english
     * Gets the amount of traffic for the message attachment.
     *
     * The traffic is measured in bytes.
     *
     * @return The traffic for the message attachment.
     */
    public long getAttachmentSize() {
        return emaObject.getAttachmentSize();
    }

    /**
     * \~chinese
     * 获取缩略图的流量大小。
     *
     * 流量的单位为字节。
     *
     * @return 缩略图的流量大小。
     *
     * \~english
     * Gets the amount of traffic for the thumbnail.
     *
     * The traffic is measured in bytes.
     *
     * @return The traffic for the thumbnail.
     */
    public long getThumbnailSize() {
        return emaObject.getThumbnailSize();
    }

    @Override
    public String toString() {
        return "EMMessageStatistics{" +
                "msgId: "+getMsgId()+
                " to: "+getTo()+
                " from: "+getFrom()+
                " type: "+getType().name()+
                " chatType: "+getChatType().name()+
                " msgTime: "+getMsgTime()+
                " direct: "+direct().name()+
                " msgSize: "+getMsgSize()+
                " attachmentSize: "+getAttachmentSize()+
                " thumbnailSize: "+getThumbnailSize()+
                "}";
    }
}
