/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.util;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.telephony.TelephonyManager;
import com.hyphenate.util.EMLog;

@SuppressLint(value={"MissingPermission"})
public class NetUtils {
    private static final String TAG = "net";
    private static final int LOW_SPEED_UPLOAD_BUF_SIZE = 1024;
    private static final int HIGH_SPEED_UPLOAD_BUF_SIZE = 10240;
    private static final int MAX_SPEED_UPLOAD_BUF_SIZE = 102400;
    private static final int LOW_SPEED_DOWNLOAD_BUF_SIZE = 2024;
    private static final int HIGH_SPEED_DOWNLOAD_BUF_SIZE = 30720;
    private static final int MAX_SPEED_DOWNLOAD_BUF_SIZE = 102400;

    public static boolean hasNetwork(Context context) {
        if (context != null) {
            block4: {
                Context context2;
                context2 = ((ConnectivityManager)context2.getSystemService("connectivity")).getActiveNetworkInfo();
                if (context2 == null) break block4;
                try {
                    return context2.isAvailable();
                }
                catch (Exception exception) {
                    EMLog.e(TAG, exception.getMessage());
                }
            }
            return false;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Types getNetworkTypes(Context context) {
        Exception exception2;
        Object object;
        block14: {
            Types types;
            int n;
            block13: {
                object = Types.NONE;
                try {
                    ConnectivityManager connectivityManager;
                    block15: {
                        block16: {
                            Types types2;
                            block18: {
                                boolean bl;
                                boolean bl2;
                                block20: {
                                    boolean bl3;
                                    block19: {
                                        boolean bl4;
                                        block17: {
                                            connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
                                            if (Build.VERSION.SDK_INT < 23) break block15;
                                            ConnectivityManager connectivityManager2 = connectivityManager;
                                            connectivityManager = connectivityManager2.getNetworkCapabilities(connectivityManager2.getActiveNetwork());
                                            if (connectivityManager == null) break block16;
                                            ConnectivityManager connectivityManager3 = connectivityManager;
                                            bl4 = connectivityManager3.hasTransport(1);
                                            bl2 = connectivityManager3.hasTransport(2);
                                            bl3 = connectivityManager3.hasTransport(3);
                                            bl = connectivityManager3.hasTransport(4);
                                            if (!connectivityManager.hasTransport(0)) break block17;
                                            types2 = Types.MOBILE;
                                            break block18;
                                        }
                                        if (!bl4) break block19;
                                        types2 = Types.WIFI;
                                        break block18;
                                    }
                                    if (!bl3) break block20;
                                    types2 = Types.ETHERNET;
                                    break block18;
                                }
                                if (!bl2 && !bl) break block16;
                                types2 = Types.OTHERS;
                            }
                            object = types2;
                        }
                        EMLog.i(TAG, "Network info: " + object);
                        return object;
                    }
                    connectivityManager = connectivityManager.getActiveNetworkInfo();
                    String string = TAG;
                    StringBuilder stringBuilder = new StringBuilder().append("Active Network info: ");
                    String string2 = connectivityManager == null ? "null" : connectivityManager.toString();
                    EMLog.i(string, stringBuilder.append(string2).toString());
                    if (connectivityManager == null) return object;
                    if (!connectivityManager.isAvailable()) return object;
                    if (!connectivityManager.isConnected()) return object;
                    n = connectivityManager.getType();
                    if (n != 1) break block13;
                }
                catch (Exception exception2) {
                    break block14;
                }
                types = Types.WIFI;
                return types;
            }
            if (n == 0) {
                types = Types.MOBILE;
                return types;
            } else if (n == 9) {
                types = Types.ETHERNET;
                return types;
            } else {
                if (n != 7) {
                    if (n != 17) return object;
                }
                types = Types.OTHERS;
            }
            return types;
        }
        EMLog.e(TAG, exception2.getMessage());
        return object;
    }

    @TargetApi(value=13)
    public static boolean hasDataConnection(Context context) {
        return NetUtils.getNetworkTypes(context) != Types.NONE;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isWifiConnected(Context context) {
        Exception exception2;
        block5: {
            Context context2;
            try {
                context2 = (ConnectivityManager)context.getSystemService("connectivity");
                if (Build.VERSION.SDK_INT >= 23) {
                    Context context3 = context2;
                    context2 = context3.getNetworkCapabilities(context3.getActiveNetwork());
                    if (context2 != null) return context2.hasTransport(1);
                    return false;
                }
            }
            catch (Exception exception2) {
                break block5;
            }
            if ((context2 = context2.getNetworkInfo(1)) == null) return false;
            {
                if (!context2.isAvailable()) return false;
                if (!context2.isConnected()) return false;
                return true;
            }
        }
        EMLog.e(TAG, exception2.getMessage());
        return false;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isMobileConnected(Context context) {
        Exception exception2;
        block5: {
            Context context2;
            block4: {
                try {
                    context2 = (ConnectivityManager)context.getSystemService("connectivity");
                    if (Build.VERSION.SDK_INT < 23) break block4;
                    Context context3 = context2;
                    context2 = context3.getNetworkCapabilities(context3.getActiveNetwork());
                    if (context2 == null) return false;
                }
                catch (Exception exception2) {
                    break block5;
                }
                if (!context2.hasTransport(0)) return false;
                return true;
            }
            if ((context2 = context2.getNetworkInfo(0)) == null) return false;
            {
                if (!context2.isAvailable()) return false;
                if (!context2.isConnected()) return false;
                return true;
            }
        }
        EMLog.e(TAG, exception2.getMessage());
        return false;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isEthernetConnected(Context context) {
        Exception exception2;
        block5: {
            Context context2;
            block4: {
                try {
                    context2 = (ConnectivityManager)context.getSystemService("connectivity");
                    if (Build.VERSION.SDK_INT < 23) break block4;
                    Context context3 = context2;
                    context2 = context3.getNetworkCapabilities(context3.getActiveNetwork());
                    if (context2 == null) return false;
                }
                catch (Exception exception2) {
                    break block5;
                }
                if (!context2.hasTransport(3)) return false;
                return true;
            }
            if ((context2 = context2.getNetworkInfo(9)) == null) return false;
            {
                if (!context2.isAvailable()) return false;
                if (!context2.isConnected()) return false;
                return true;
            }
        }
        EMLog.e(TAG, exception2.getMessage());
        return false;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isOthersConnected(Context context) {
        Exception exception2;
        block7: {
            int n;
            Context context2;
            block6: {
                block8: {
                    try {
                        context2 = (ConnectivityManager)context.getSystemService("connectivity");
                        n = Build.VERSION.SDK_INT;
                        if (n < 23) break block6;
                    }
                    catch (Exception exception2) {
                        break block7;
                    }
                    {
                        Context context3 = context2;
                        context2 = context3.getNetworkCapabilities(context3.getActiveNetwork());
                        if (context2 != null) break block8;
                        return false;
                    }
                }
                boolean bl = context2.hasTransport(4);
                if (context2.hasTransport(2)) return true;
                if (bl) return true;
                return false;
            }
            NetworkInfo networkInfo = context2.getNetworkInfo(7);
            NetworkInfo networkInfo2 = null;
            if (n >= 21) {
                networkInfo2 = context2.getNetworkInfo(17);
            }
            if (networkInfo != null && networkInfo.isAvailable()) {
                if (networkInfo.isConnected()) return true;
            }
            if (networkInfo2 == null) return false;
            if (!networkInfo2.isAvailable()) return false;
            if (!networkInfo2.isConnected()) return false;
            return true;
        }
        EMLog.e(TAG, exception2.getMessage());
        return false;
    }

    public static int getUploadBufSize(Context context) {
        Context context2 = ((ConnectivityManager)context.getSystemService("connectivity")).getActiveNetworkInfo();
        if (context2 != null && context2.getType() == 1) {
            return 102400;
        }
        if (context2 != null && context2.getType() == 9) {
            return 102400;
        }
        if (context2 != null && NetUtils.isConnectionFast(context2.getType(), context2.getSubtype())) {
            return 10240;
        }
        return 1024;
    }

    public static int getDownloadBufSize(Context context) {
        Context context2 = ((ConnectivityManager)context.getSystemService("connectivity")).getActiveNetworkInfo();
        if (context2 != null && context2.getType() == 1) {
            return 102400;
        }
        if (Build.VERSION.SDK_INT >= 13 && context2 != null && context2.getType() == 9) {
            return 102400;
        }
        if (context2 != null && NetUtils.isConnectionFast(context2.getType(), context2.getSubtype())) {
            return 30720;
        }
        return 2024;
    }

    /*
     * WARNING - void declaration
     */
    private static boolean isConnectionFast(int type, int subType) {
        int n;
        if (type == 1) {
            return true;
        }
        int n2 = Build.VERSION.SDK_INT;
        if (n2 >= 13 && n == 9) {
            return true;
        }
        if (n == 0) {
            void var1_1;
            switch (var1_1) {
                default: {
                    if (n2 >= 11 && (var1_1 == 14 || var1_1 == 13)) {
                        return true;
                    }
                    return n2 >= 9 && var1_1 == 12;
                }
                case 10: {
                    return true;
                }
                case 9: {
                    return true;
                }
                case 8: {
                    return true;
                }
                case 7: {
                    return false;
                }
                case 6: {
                    return true;
                }
                case 5: {
                    return true;
                }
                case 4: {
                    return false;
                }
                case 3: {
                    return true;
                }
                case 2: {
                    return false;
                }
                case 1: 
            }
            return false;
        }
        return false;
    }

    public static String getNetworkType(Context context) {
        NetworkInfo networkInfo = ((ConnectivityManager)context.getSystemService("connectivity")).getActiveNetworkInfo();
        if (networkInfo != null && networkInfo.isAvailable()) {
            Context context2;
            int n = networkInfo.getType();
            if (Build.VERSION.SDK_INT >= 13 && n == 9) {
                return "ETHERNET";
            }
            if (n == 1) {
                return "WIFI";
            }
            switch (((TelephonyManager)context2.getSystemService("phone")).getNetworkType()) {
                default: {
                    return "unkonw network";
                }
                case 13: {
                    return "4G";
                }
                case 3: 
                case 5: 
                case 6: 
                case 8: 
                case 9: 
                case 10: 
                case 12: 
                case 14: 
                case 15: {
                    return "3G";
                }
                case 1: 
                case 2: 
                case 4: 
                case 7: 
                case 11: 
            }
            return "2G";
        }
        return "no network";
    }

    public static enum Types {
        NONE,
        WIFI,
        MOBILE,
        ETHERNET,
        OTHERS;

    }
}

