/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.util;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.media.ExifInterface;
import android.media.ThumbnailUtils;
import android.net.Uri;
import android.os.Build;
import android.os.ParcelFileDescriptor;
import android.support.annotation.RequiresApi;
import android.text.TextUtils;
import com.hyphenate.util.EMFileHelper;
import com.hyphenate.util.EMLog;
import com.hyphenate.util.PathUtil;
import com.hyphenate.util.UriUtils;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;

public class ImageUtils {
    private static final String TAG = "ImageUtils";
    public static final int SCALE_IMAGE_WIDTH = 640;
    public static final int SCALE_IMAGE_HEIGHT = 960;

    public static Bitmap getRoundedCornerBitmap(Bitmap bitmap) {
        return ImageUtils.getRoundedCornerBitmap(bitmap, 6.0f);
    }

    /*
     * WARNING - void declaration
     */
    public static Bitmap getRoundedCornerBitmap(Bitmap bitmap, float radius) {
        void var1_3;
        RectF rectF;
        Rect rect;
        Paint paint;
        Canvas canvas;
        Bitmap bitmap2;
        Bitmap bitmap3 = Bitmap.createBitmap((int)bitmap.getWidth(), (int)bitmap2.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Bitmap bitmap4 = bitmap3;
        Canvas canvas2 = canvas;
        canvas2(bitmap4);
        bitmap4 = paint;
        Canvas canvas3 = canvas2;
        Canvas canvas4 = canvas2;
        Bitmap bitmap5 = bitmap4;
        bitmap5();
        canvas2 = rect;
        Bitmap bitmap6 = bitmap2;
        int n = bitmap6.getWidth();
        int n2 = bitmap6.getHeight();
        rect = new Rect(0, 0, n, n2);
        RectF rectF2 = rectF;
        rectF = new RectF((Rect)canvas2);
        bitmap5.setAntiAlias(true);
        canvas4.drawARGB(0, 0, 0, 0);
        bitmap4.setColor(-12434878);
        void v9 = var1_3;
        canvas3.drawRoundRect(rectF2, (float)v9, (float)v9, (Paint)bitmap4);
        paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_IN));
        Canvas canvas5 = canvas2;
        canvas.drawBitmap(bitmap2, (Rect)canvas5, (Rect)canvas5, (Paint)bitmap4);
        return bitmap3;
    }

    /*
     * WARNING - void declaration
     */
    public static Bitmap getVideoThumbnail(String videoPath, int width, int height, int kind) {
        void var2_2;
        void var1_1;
        void var3_3;
        String string = ThumbnailUtils.createVideoThumbnail((String)videoPath, (int)var3_3);
        EMLog.d("getVideoThumbnail", "video thumb width:" + string.getWidth());
        EMLog.d("getVideoThumbnail", "video thumb height:" + string.getHeight());
        return ThumbnailUtils.extractThumbnail((Bitmap)string, (int)var1_1, (int)var2_2, (int)2);
    }

    /*
     * WARNING - void declaration
     */
    public static String saveVideoThumb(File videoFile, int width, int height, int kind) {
        FileOutputStream fileOutputStream;
        Object object;
        File file;
        void var3_5;
        void var2_3;
        void var1_1;
        Bitmap bitmap = ImageUtils.getVideoThumbnail(videoFile.getAbsolutePath(), (int)var1_1, (int)var2_3, (int)var3_5);
        File file2 = file;
        try {
            new File(PathUtil.getInstance().getVideoPath(), "th" + ((File)object).getName()).createNewFile();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        object = null;
        FileOutputStream fileOutputStream2 = fileOutputStream;
        try {
            fileOutputStream = new FileOutputStream(file2);
            object = fileOutputStream2;
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        bitmap.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)object);
        if (object != null) {
            try {
                ((OutputStream)object).flush();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        if (object != null) {
            try {
                ((FileOutputStream)object).close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return file2.getAbsolutePath();
    }

    /*
     * WARNING - void declaration
     */
    public static Bitmap decodeScaleImage(String imagePath, int reqWidth, int reqHeight) {
        String string;
        void var2_4;
        void var1_2;
        String string2 = imagePath;
        BitmapFactory.Options options = ImageUtils.getBitmapOptions(string2);
        int n = ImageUtils.calculateInSampleSize(options, (int)var1_2, (int)var2_4);
        EMLog.d("img", "original wid" + options.outWidth + " original height:" + options.outHeight + " sample:" + n);
        options.inSampleSize = n;
        options.inJustDecodeBounds = false;
        Bitmap bitmap = BitmapFactory.decodeFile((String)string2, (BitmapFactory.Options)options);
        int n2 = ImageUtils.readPictureDegree(string);
        if (bitmap != null && n2 != 0) {
            Bitmap bitmap2 = ImageUtils.rotateImageView(n2, bitmap);
            bitmap.recycle();
            return bitmap2;
        }
        return bitmap;
    }

    /*
     * WARNING - void declaration
     */
    @RequiresApi(api=24)
    public static Bitmap decodeScaleImage(Context context, Uri imageUri, int reqWidth, int reqHeight) throws IOException {
        void var3_5;
        void var2_3;
        void var1_2;
        Context context2;
        BitmapFactory.Options options = ImageUtils.getBitmapOptions(context2, (Uri)var1_2);
        int n = ImageUtils.calculateInSampleSize(options, (int)var2_3, (int)var3_5);
        EMLog.d("img", "original wid" + options.outWidth + " original height:" + options.outHeight + " sample:" + n);
        options.inSampleSize = n;
        options.inJustDecodeBounds = false;
        Bitmap bitmap = ImageUtils.getBitmapByUri(context, (Uri)var1_2, options);
        int n2 = ImageUtils.readPictureDegree(context2, (Uri)var1_2);
        if (bitmap != null && n2 != 0) {
            Bitmap bitmap2 = ImageUtils.rotateImageView(n2, bitmap);
            bitmap.recycle();
            return bitmap2;
        }
        return bitmap;
    }

    /*
     * WARNING - void declaration
     */
    public static Bitmap decodeScaleImage(Context context, int drawableId, int reqWidth, int reqHeight) {
        void var3_3;
        void var2_2;
        void var1_1;
        Context context2;
        BitmapFactory.Options options;
        BitmapFactory.Options options2 = options;
        options2();
        options2.inJustDecodeBounds = true;
        BitmapFactory.decodeResource((Resources)context2.getResources(), (int)var1_1, (BitmapFactory.Options)options2);
        options.inSampleSize = ImageUtils.calculateInSampleSize(options, (int)var2_2, (int)var3_3);
        options.inJustDecodeBounds = false;
        return BitmapFactory.decodeResource((Resources)context.getResources(), (int)var1_1, (BitmapFactory.Options)options2);
    }

    /*
     * WARNING - void declaration
     */
    public static int calculateInSampleSize(BitmapFactory.Options options, int reqWidth, int reqHeight) {
        void var1_2;
        int n;
        BitmapFactory.Options options2;
        int n2 = options.outHeight;
        int n3 = options2.outWidth;
        int n4 = 1;
        if (n2 > n || n3 > var1_2) {
            n4 = (n = Math.round((float)n2 / (float)n)) > (n3 = Math.round((float)n3 / (float)var1_2)) ? n : n3;
        }
        return n4;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getThumbnailImage(String imagePath, int thumbnailSize) {
        String string;
        FileOutputStream fileOutputStream;
        Exception exception2;
        File file;
        block4: {
            FileOutputStream fileOutputStream2;
            void var1_1;
            void v0 = var1_1;
            Bitmap bitmap = ImageUtils.decodeScaleImage(imagePath, (int)v0, (int)v0);
            try {
                file = File.createTempFile("image", ".jpg");
            }
            catch (Exception exception2) {}
            fileOutputStream = fileOutputStream2;
            fileOutputStream2 = new FileOutputStream(file);
            if (bitmap == null) break block4;
            bitmap.compress(Bitmap.CompressFormat.JPEG, 60, (OutputStream)fileOutputStream);
        }
        fileOutputStream.close();
        EMLog.d("img", "generate thumbnail image at:" + file.getAbsolutePath() + " size:" + file.length());
        return file.getAbsolutePath();
        exception2.printStackTrace();
        return string;
    }

    /*
     * WARNING - void declaration
     */
    public static String getFilename(Context context, String fileUri) {
        void var1_1;
        Context context2;
        if (TextUtils.isEmpty((CharSequence)fileUri)) {
            return "";
        }
        if (!EMFileHelper.getInstance().isFileExist(context2, Uri.parse((String)var1_1))) {
            return "";
        }
        return EMFileHelper.getInstance().getFilename((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static long getFileLength(Context context, String fileUri) {
        void var1_1;
        if (TextUtils.isEmpty((CharSequence)fileUri)) {
            return 0L;
        }
        return EMFileHelper.getInstance().getFileLength((String)var1_1);
    }

    public static String getScaledImageByUri(Context context, String localPath) {
        Context context2;
        String string;
        if (TextUtils.isEmpty((CharSequence)localPath)) {
            return string;
        }
        EMLog.d("img", "original localPath: " + string);
        Uri uri = Uri.parse((String)string);
        if (!EMFileHelper.getInstance().isFileExist(context2, string)) {
            return string;
        }
        String string2 = EMFileHelper.getInstance().getFilePath(context2, uri);
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            return ImageUtils.getScaledImage(context2, string2);
        }
        string2 = null;
        if (Build.VERSION.SDK_INT >= 24) {
            string2 = ImageUtils.getScaledImage(context2, uri);
        }
        if (string2 != null) {
            string = string2.toString();
        }
        return string;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getScaledImage(Context appContext, String imagePath) {
        FileOutputStream fileOutputStream;
        Exception exception2;
        Object object;
        void var1_1;
        block6: {
            FileOutputStream fileOutputStream2;
            File file;
            File file2 = file;
            if (!new File((String)var1_1).exists()) {
                return var1_1;
            }
            long l = file2.length();
            EMLog.d("img", "original img size:" + l);
            if (l <= 102400L) {
                EMLog.d("img", "use original small image");
                return var1_1;
            }
            Bitmap bitmap = ImageUtils.decodeScaleImage((String)var1_1, 640, 960);
            try {
                Context context = object;
                object = ".jpg";
                object = File.createTempFile("image", (String)object, context.getFilesDir());
            }
            catch (Exception exception2) {}
            fileOutputStream = fileOutputStream2;
            fileOutputStream2 = new FileOutputStream((File)object);
            if (bitmap == null) break block6;
            bitmap.compress(Bitmap.CompressFormat.JPEG, 70, (OutputStream)fileOutputStream);
        }
        fileOutputStream.close();
        EMLog.d("img", "compared to small fle" + ((File)object).getAbsolutePath() + " size:" + ((File)object).length());
        return ((File)object).getAbsolutePath();
        exception2.printStackTrace();
        return var1_1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @RequiresApi(api=24)
    public static Uri getScaledImage(Context appContext, Uri imageUri) {
        FileOutputStream fileOutputStream;
        Exception exception2;
        Object object;
        block7: {
            FileOutputStream fileOutputStream2;
            Bitmap bitmap;
            if (imageUri == null) {
                return bitmap;
            }
            try {
                if (EMFileHelper.getInstance().getFileLength((Uri)bitmap) <= 102400L) {
                    EMLog.d("img", "use original small image");
                    return bitmap;
                }
                bitmap = ImageUtils.decodeScaleImage((Context)object, (Uri)bitmap, 640, 960);
                Context context = object;
                object = ".jpg";
                object = File.createTempFile("image", (String)object, context.getFilesDir());
            }
            catch (Exception exception2) {}
            fileOutputStream = fileOutputStream2;
            fileOutputStream2 = new FileOutputStream((File)object);
            if (bitmap == null) break block7;
            bitmap.compress(Bitmap.CompressFormat.JPEG, 70, (OutputStream)fileOutputStream);
        }
        fileOutputStream.close();
        EMLog.d("img", "compared to small fle" + ((File)object).getAbsolutePath() + " size:" + ((File)object).length());
        return Uri.fromFile((File)object);
        exception2.printStackTrace();
        return null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Uri checkDegreeAndRestoreImage(Context context, Uri imageUri) {
        block11: {
            block10: {
                block12: {
                    try {
                        var2_2 = EMFileHelper.getInstance().getFilePath(var0 /* !! */ , (Uri)var1_1);
                        var3_3 = 0;
                    }
                    catch (Exception v0) {
                        break block10;
                    }
                    var4_5 = v1;
                    new BitmapFactory.Options().inJustDecodeBounds = false;
                    if (TextUtils.isEmpty((CharSequence)var2_2)) break block12;
                    v2 = var2_2;
                    var2_2 = BitmapFactory.decodeFile((String)v2, (BitmapFactory.Options)var4_5);
                    v3 = ImageUtils.readPictureDegree(v2);
lbl13:
                    // 2 sources

                    while (true) {
                        var3_3 = v3;
                        ** GOTO lbl25
                        break;
                    }
                }
                v4 = var0 /* !! */ .getContentResolver().openFileDescriptor((Uri)var1_1, "r");
                BitmapFactory.decodeFileDescriptor((FileDescriptor)v4.getFileDescriptor(), null, (BitmapFactory.Options)var4_5);
                {
                    v4.close();
                    var2_2 = ImageUtils.getBitmapByUri(var0 /* !! */ , (Uri)var1_1, var4_5);
                    if (Build.VERSION.SDK_INT >= 24) {
                        v3 = ImageUtils.readPictureDegree(var0 /* !! */ , (Uri)var1_1);
                        ** continue;
                    }
lbl25:
                    // 3 sources

                    if (var2_2 == null || var3_3 == 0) break block11;
                    var3_4 = ImageUtils.rotateImageView(var3_3, (Bitmap)var2_2);
                }
                {
                    var2_2.recycle();
                    v5 = var0 /* !! */ ;
                    var0 /* !! */  = ".jpg";
                    var0 /* !! */  = File.createTempFile("image-" + System.currentTimeMillis(), (String)var0 /* !! */ , v5.getFilesDir());
                }
                var2_2 = v6;
                {
                    v6 = new FileOutputStream((File)var0 /* !! */ );
                    if (var3_4 == null) ** GOTO lbl-1000
                    var3_4.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)var2_2);
                }
lbl-1000:
                // 2 sources

                {
                    var2_2.close();
                    return Uri.fromFile((File)var0 /* !! */ );
                }
            }
            v0.printStackTrace();
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getScaledImage(Context appContext, String imagePath, int i) {
        void var1_1;
        File file;
        File file2 = file;
        if (new File((String)var1_1).exists()) {
            long l = file2.length();
            EMLog.d("img", "original img size:" + l);
            if (l > 102400L) {
                Exception exception2;
                FileOutputStream fileOutputStream;
                File file3;
                block7: {
                    FileOutputStream fileOutputStream2;
                    File file4;
                    Bitmap bitmap = ImageUtils.decodeScaleImage((String)var1_1, 640, 960);
                    file3 = file4;
                    try {
                        void var2_2;
                        file4 = new File(fileOutputStream.getExternalCacheDir(), "eaemobTemp" + (int)var2_2 + ".jpg");
                    }
                    catch (Exception exception2) {}
                    fileOutputStream = fileOutputStream2;
                    fileOutputStream2 = new FileOutputStream(file3);
                    if (bitmap == null) break block7;
                    bitmap.compress(Bitmap.CompressFormat.JPEG, 60, (OutputStream)fileOutputStream);
                }
                fileOutputStream.close();
                EMLog.d("img", "compared to small fle" + file3.getAbsolutePath() + " size:" + file3.length());
                return file3.getAbsolutePath();
                exception2.printStackTrace();
            }
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static Bitmap mergeImages(int targetWidth, int targetHeight, List<Bitmap> images) {
        void var2_2;
        Canvas canvas;
        int n;
        int n2;
        Bitmap bitmap = Bitmap.createBitmap((int)n2, (int)n, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas2 = canvas;
        new Canvas(bitmap).drawColor(-3355444);
        EMLog.d("img", "merge images to size:" + n2 + "*" + n + " with images:" + var2_2.size());
        n = images.size() <= 4 ? 2 : 3;
        int n3 = n2;
        n2 = 0;
        int n4 = (n3 - 4) / n;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                int n5 = n4;
                Bitmap bitmap2 = Bitmap.createScaledBitmap((Bitmap)((Bitmap)var2_2.get(n2)), (int)n5, (int)n5, (boolean)true);
                Bitmap bitmap3 = ImageUtils.getRoundedCornerBitmap(bitmap2, 2.0f);
                bitmap2.recycle();
                float f = j * n4 + (j + 2);
                canvas2.drawBitmap(bitmap3, f, (float)(i * n4 + (i + 2)), null);
                bitmap3.recycle();
                if (++n2 != var2_2.size()) continue;
                return bitmap;
            }
        }
        return bitmap;
    }

    public static int readPictureDegree(String path) {
        int n = 0;
        try {
            String string;
            int n2 = new ExifInterface(string).getAttributeInt("Orientation", 1);
            if (n2 != 3) {
                if (n2 != 6) {
                    if (n2 == 8) {
                        n = 270;
                    }
                } else {
                    n = 90;
                }
            } else {
                n = 180;
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return n;
    }

    @RequiresApi(api=24)
    public static int readPictureDegree(Context context, Uri imageUri) {
        ParcelFileDescriptor parcelFileDescriptor;
        int n;
        block8: {
            n = 0;
            parcelFileDescriptor = context.getContentResolver().openFileDescriptor((Uri)parcelFileDescriptor, "r");
            int n2 = new ExifInterface(parcelFileDescriptor.getFileDescriptor()).getAttributeInt("Orientation", 1);
            if (n2 != 3) {
                if (n2 != 6) {
                    if (n2 == 8) {
                        n = 270;
                    }
                } else {
                    n = 90;
                }
                break block8;
            }
            n = 180;
        }
        try {
            parcelFileDescriptor.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return n;
    }

    public static Bitmap rotateImageView(int angle, Bitmap bitmap) {
        int n;
        Matrix matrix;
        Bitmap bitmap2 = bitmap;
        Matrix matrix2 = matrix;
        matrix2();
        matrix.postRotate((float)n);
        n = bitmap2.getWidth();
        int n2 = bitmap2.getHeight();
        return Bitmap.createBitmap((Bitmap)bitmap2, (int)0, (int)0, (int)n, (int)n2, (Matrix)matrix2, (boolean)true);
    }

    /*
     * WARNING - void declaration
     */
    public static BitmapFactory.Options getBitmapOptions(Context context, String fileUri) {
        void var1_2;
        Context context2;
        if (TextUtils.isEmpty((CharSequence)fileUri)) {
            return null;
        }
        if (!EMFileHelper.getInstance().isFileExist(context2, (String)var1_2)) {
            return null;
        }
        String string = EMFileHelper.getInstance().getFilePath(context2, (String)var1_2);
        if (!TextUtils.isEmpty((CharSequence)string)) {
            return ImageUtils.getBitmapOptions(string);
        }
        try {
            return ImageUtils.getBitmapOptions(context2, Uri.parse((String)var1_2));
        }
        catch (IOException iOException) {
            EMLog.e("img", "get bitmap options fail by " + iOException.getMessage());
            return null;
        }
    }

    public static BitmapFactory.Options getBitmapOptions(String imagePath) {
        String string;
        BitmapFactory.Options options;
        BitmapFactory.Options options2 = options;
        String string2 = string;
        BitmapFactory.Options options3 = options2;
        options3();
        options3.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)string2, (BitmapFactory.Options)options3);
        ImageUtils.checkBitmapOrientation(ImageUtils.readPictureDegree(string2), options2);
        return options;
    }

    /*
     * WARNING - void declaration
     */
    public static BitmapFactory.Options getBitmapOptions(Context context, Uri uri) throws IOException {
        void var1_1;
        BitmapFactory.Options options;
        BitmapFactory.Options options2 = options;
        new BitmapFactory.Options().inJustDecodeBounds = true;
        ParcelFileDescriptor parcelFileDescriptor = context.getContentResolver().openFileDescriptor((Uri)var1_1, "r");
        BitmapFactory.decodeFileDescriptor((FileDescriptor)parcelFileDescriptor.getFileDescriptor(), null, (BitmapFactory.Options)options2);
        parcelFileDescriptor.close();
        if (Build.VERSION.SDK_INT >= 24) {
            Context context2;
            ImageUtils.checkBitmapOrientation(ImageUtils.readPictureDegree(context2, (Uri)var1_1), options2);
        }
        return options2;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isGifFile(Context context, String imagePath) {
        if (!TextUtils.isEmpty((CharSequence)imagePath)) {
            void var1_1;
            Object object;
            object = UriUtils.getMimeType(object, Uri.parse((String)var1_1));
            boolean bl = "image/gif".equalsIgnoreCase((String)object);
            EMLog.e(TAG, "isGif:" + bl + ", mimeType:" + (String)object + ", imagePath :" + (String)var1_1);
            return bl;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private static void checkBitmapOrientation(int degree, BitmapFactory.Options options) {
        int n;
        if (degree == 90 || n == 270) {
            void var1_1;
            void v0 = var1_1;
            n = v0.outHeight;
            v0.outHeight = v0.outWidth;
            v0.outWidth = n;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static Bitmap getBitmapByUri(Context context, Uri uri, BitmapFactory.Options options) throws IOException {
        void var2_2;
        void var1_1;
        Context context2 = context.getContentResolver().openFileDescriptor((Uri)var1_1, "r");
        Bitmap bitmap = BitmapFactory.decodeFileDescriptor((FileDescriptor)context2.getFileDescriptor(), null, (BitmapFactory.Options)var2_2);
        context2.close();
        return bitmap;
    }
}

