/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.notification;

import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Build;
import android.support.annotation.IdRes;
import android.support.v4.app.NotificationCompat;
import android.text.TextUtils;
import java.lang.ref.SoftReference;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;

public class EMNotificationBuilder {
    private Context appContext;
    private boolean sound;
    private boolean vibrate;
    private String channelId;
    private String channelName;
    private int channelLevel;
    private boolean autoCancel = true;
    private String title;
    private String content;
    private SoftReference<Bitmap> iconBitmapRef;
    private EMNotificationDefaultStyle style;
    private PendingIntent pendingIntent;
    private int smallIcon;
    private String ticker;
    private PendingIntent fullScreenIntent;
    private int badgeNum;

    /*
     * WARNING - void declaration
     */
    public EMNotificationBuilder(Context context) {
        EMNotificationDefaultStyle eMNotificationDefaultStyle;
        EMNotificationDefaultStyle eMNotificationDefaultStyle2 = eMNotificationDefaultStyle;
        eMNotificationDefaultStyle = new EMNotificationDefaultStyle();
        this.style = eMNotificationDefaultStyle2;
        this.smallIcon = 17301651;
        if (context != null) {
            void var1_1;
            this.appContext = var1_1.getApplicationContext();
            return;
        }
        throw new IllegalArgumentException("context cannot is null");
    }

    /*
     * WARNING - void declaration
     */
    private void createNotificationChannel(Context context, boolean vibrate, String channelId, String channelName, int channelLevel) {
        if (Build.VERSION.SDK_INT >= 26) {
            void var1_1;
            void var2_2;
            void var4_5;
            void var3_4;
            NotificationChannel notificationChannel;
            int n;
            int n2 = 3;
            if (n < 0 || n > 5) {
                n = n2;
            }
            EMNotificationBuilder eMNotificationBuilder = eMNotificationBuilder2;
            EMNotificationBuilder eMNotificationBuilder2 = notificationChannel;
            notificationChannel = new NotificationChannel((String)var3_4, (CharSequence)var4_5, n);
            if (!eMNotificationBuilder.sound) {
                eMNotificationBuilder2.setSound(null, null);
            }
            if (var2_2 != false) {
                EMNotificationBuilder eMNotificationBuilder3 = eMNotificationBuilder2;
                eMNotificationBuilder3.enableVibration(true);
                long[] lArray = new long[5];
                long[] lArray2 = lArray;
                lArray[0] = 100L;
                lArray[1] = 200L;
                lArray[2] = 300L;
                lArray[3] = 400L;
                lArray[4] = 500L;
                eMNotificationBuilder3.setVibrationPattern(lArray2);
            } else {
                eMNotificationBuilder2.enableVibration(false);
            }
            ((NotificationManager)var1_1.getSystemService("notification")).createNotificationChannel((NotificationChannel)eMNotificationBuilder2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public EMNotificationBuilder setTitle(String title) {
        void var1_1;
        this.title = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public EMNotificationBuilder setContent(String content) {
        void var1_1;
        this.content = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public EMNotificationBuilder setIcon(@IdRes int res) {
        void var1_1;
        Bitmap bitmap = BitmapFactory.decodeResource((Resources)this.appContext.getResources(), (int)var1_1);
        if (bitmap != null) {
            SoftReference<Bitmap> softReference;
            SoftReference<Bitmap> softReference2 = softReference;
            softReference = new SoftReference<Bitmap>(bitmap);
            this.iconBitmapRef = softReference2;
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public EMNotificationBuilder setIcon(Bitmap iconBitmap) {
        if (iconBitmap != null) {
            void var1_1;
            SoftReference<void> softReference;
            SoftReference<void> softReference2 = softReference;
            softReference = new SoftReference<void>(var1_1);
            this.iconBitmapRef = softReference2;
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public EMNotificationBuilder setSmallIcon(@IdRes int smallIcon) {
        void var1_1;
        this.smallIcon = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public EMNotificationBuilder setStyle(EMNotificationDefaultStyle style) {
        void var1_1;
        this.style = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public EMNotificationBuilder setPendingIntent(PendingIntent pendingIntent) {
        void var1_1;
        this.pendingIntent = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public EMNotificationBuilder setFullScreenIntent(PendingIntent fullScreenIntent) {
        void var1_1;
        this.fullScreenIntent = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public EMNotificationBuilder setSound(boolean enable) {
        void var1_1;
        this.sound = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public EMNotificationBuilder setVibrate(boolean enable) {
        void var1_1;
        this.vibrate = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public EMNotificationBuilder setLevel(int level) {
        void var1_1;
        this.channelLevel = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public EMNotificationBuilder setTicker(String ticker) {
        void var1_1;
        this.ticker = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public EMNotificationBuilder setChannelId(String channelId) {
        if (!TextUtils.isEmpty((CharSequence)channelId)) {
            void var1_1;
            this.channelId = var1_1;
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public EMNotificationBuilder setChannelName(String channelName) {
        if (!TextUtils.isEmpty((CharSequence)channelName)) {
            void var1_1;
            this.channelName = var1_1;
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public EMNotificationBuilder setAutoCancel(boolean autoCancel) {
        void var1_1;
        this.autoCancel = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public EMNotificationBuilder setBadgeNum(int badgeNum) {
        void var1_1;
        this.badgeNum = var1_1;
        return this;
    }

    public Notification build() {
        int n;
        SoftReference<Bitmap> softReference;
        Method method;
        NotificationCompat.Builder builder;
        if (((EMNotificationBuilder)this_).channelId == null) {
            ((EMNotificationBuilder)this_).channelId = "chat";
        }
        if (((EMNotificationBuilder)this_).channelName == null) {
            ((EMNotificationBuilder)this_).channelName = "\u6d88\u606f";
        }
        boolean bl = ((EMNotificationBuilder)this_).vibrate;
        String string = ((EMNotificationBuilder)this_).channelId;
        String string2 = ((EMNotificationBuilder)this_).channelName;
        int n2 = ((EMNotificationBuilder)this_).channelLevel;
        ((EMNotificationBuilder)this_).createNotificationChannel(((EMNotificationBuilder)this_).appContext, bl, string, string2, n2);
        bl = ((EMNotificationBuilder)this_).sound;
        boolean bl2 = ((EMNotificationBuilder)this_).vibrate;
        int n3 = bl2 ? 2 : (int)(bl ? 1 : 0);
        if (bl && bl2) {
            n3 = -1;
        }
        NotificationCompat.Builder builder2 = builder;
        builder = new NotificationCompat.Builder(((EMNotificationBuilder)this_).appContext);
        try {
            method = NotificationCompat.Builder.class.getDeclaredMethod("setChannelId", String.class);
        }
        catch (Exception exception) {}
        NotificationCompat.Builder builder3 = builder2;
        ((AccessibleObject)method).setAccessible(true);
        String string3 = ((EMNotificationBuilder)this_).channelId;
        method.invoke((Object)builder3, string3);
        builder2.setSmallIcon(((EMNotificationBuilder)this_).smallIcon);
        if (!((EMNotificationBuilder)this_).sound) {
            builder2.setSound(null);
        }
        if (n3 != 0) {
            builder2.setDefaults(n3);
        }
        if ((softReference = ((EMNotificationBuilder)this_).iconBitmapRef) != null && softReference.get() != null) {
            builder2.setLargeIcon(((EMNotificationBuilder)this_).iconBitmapRef.get());
        }
        if ((n = ((EMNotificationBuilder)this_).badgeNum) > 0) {
            builder2.setNumber(n);
        }
        builder2.setTicker((CharSequence)((EMNotificationBuilder)this_).ticker).setPriority(((EMNotificationBuilder)this_).channelLevel - 3).setVisibility(1).setAutoCancel(((EMNotificationBuilder)this_).autoCancel).setContentTitle((CharSequence)((EMNotificationBuilder)this_).title).setContentText((CharSequence)((EMNotificationBuilder)this_).content).setContentIntent(((EMNotificationBuilder)this_).pendingIntent).setWhen(System.currentTimeMillis());
        Object object = ((EMNotificationBuilder)this_).style;
        if (object instanceof EMNotificationBigTextStyle) {
            object = ((EMNotificationBigTextStyle)object).getBigTxt();
            builder2.setStyle((NotificationCompat.Style)new NotificationCompat.BigTextStyle().bigText((CharSequence)object));
        } else if (object instanceof EMNotificationBigPicStyle) {
            object = ((EMNotificationBigPicStyle)object).getBigPic();
            builder2.setStyle((NotificationCompat.Style)new NotificationCompat.BigPictureStyle().bigPicture((Bitmap)object));
        }
        object = ((EMNotificationBuilder)this_).fullScreenIntent;
        if (object != null) {
            builder2.setFullScreenIntent((PendingIntent)object, true);
        }
        if (((EMNotificationBuilder)this_).vibrate) {
            long[] lArray = new long[5];
            Object this_ = lArray;
            lArray[0] = 100L;
            lArray[1] = 200L;
            lArray[2] = 300L;
            lArray[3] = 400L;
            lArray[4] = 500L;
            builder2.setVibrate((long[])this_);
        } else {
            builder2.setVibrate(null);
        }
        Notification notification = builder2.build();
        builder2.setPublicVersion(notification);
        return notification;
    }

    public static class EMNotificationDefaultStyle {
    }

    public static class EMNotificationBigTextStyle
    extends EMNotificationDefaultStyle {
        private String bigTxt;

        public String getBigTxt() {
            return this.bigTxt;
        }

        /*
         * WARNING - void declaration
         */
        public EMNotificationBigTextStyle setBigTxt(String bigTxt) {
            void var1_1;
            this.bigTxt = var1_1;
            return this;
        }
    }

    public static class EMNotificationBigPicStyle
    extends EMNotificationDefaultStyle {
        private SoftReference<Bitmap> bitmapRef;

        public Bitmap getBigPic() {
            SoftReference<Bitmap> softReference = this.bitmapRef;
            if (softReference != null && softReference.get() != null) {
                return this.bitmapRef.get();
            }
            return null;
        }

        /*
         * WARNING - void declaration
         */
        public EMNotificationBigPicStyle setBigPic(Bitmap bigPic) {
            if (bigPic != null) {
                void var1_1;
                SoftReference<void> softReference;
                SoftReference<void> softReference2 = softReference;
                softReference = new SoftReference<void>(var1_1);
                this.bitmapRef = softReference2;
            }
            return this;
        }
    }
}

