package com.hyphenate.push;

import android.text.TextUtils;

/**
 * \~chinese
 * 推送类型枚举类。
 *
 * \~english
 * The push types.

 */
public enum EMPushType {
    FCM("FCM"), /** \~chinese 谷歌推送。  \~english The FCM push. */
    MIPUSH("MI"), /** \~chinese 小米推送。  \~english The Mi push. */
    HMSPUSH("HUAWEI"),/** \~chinese 华为推送。  \~english The HUAWEI push. */
    MEIZUPUSH("MEIZU"),/** \~chinese 魅族推送。  \~english The MEIZU push. */
    OPPOPUSH("OPPO"),/** \~chinese OPPO 推送。  \~english The OPPO push. */
    VIVOPUSH("VIVO"),/** \~chinese VIVO 推送。  \~english The VIVO push. */
    HONORPUSH("HONOR"),/** \~chinese 荣耀推送。  \~english The HONOR push. */
    NORMAL("NORMAL");/** \~chinese 默认 Chat 服务的推送类型。  \~english The NORMAL push, which is the push of chat service. */

    private String name;

    EMPushType(String name) {
        this.name = name;
    }

    /**
     * \~chinese
     * 获取推送类型名称。
     * @return 推送类型名称。
     *
     * \~english
     * Gets the push type name.
     * @return  The push type name.
     */
    public String getName() {
        return name;
    }

    /**
     * \~chinese
     * 获取推送类型。
     * @param name  推送类型名称。
     * @return  推送类型。
     *
     * \~english
     * Gets the push type.
     * @param name  The push type name.
     * @return  The push type.
     */
    public static EMPushType getType(String name) {
        if (TextUtils.isEmpty(name)) {
            return NORMAL;
        } else {
            EMPushType[] var1 = values();
            int var2 = var1.length;

            for (int var3 = 0; var3 < var2; ++var3) {
                EMPushType type = var1[var3];
                if (type.getName().equals(name)) {
                    return type;
                }
            }

            return NORMAL;
        }
    }
}
