package com.hyphenate.chat.adapter;

public abstract class EMAThreadManagerListener extends EMABase implements EMAThreadManagerListenerInterface {

    public EMAThreadManagerListener() {
        nativeInit();
    }

    @Override
    public void finalize() throws Throwable {
        nativeFinalize();
        super.finalize();
    }

    native void nativeInit();
    native void nativeFinalize();

    /**
     * \brief Thread 被修改的通知事件
     * @param event
     */
    public void onThreadNameUpdated(EMAThreadInfo event) {}

    /**
     * \brief Callback user when user is kicked out from a Thread or the Thread is destroyed.
     * @param event
     * @param reason See {@link com.hyphenate.chat.adapter.EMAThreadInfo.LeaveReason}
     */
    public void onLeaveThread(EMAThreadInfo event, int reason) {}

    /**
     * \brief Thread 加入新成员事件
     * @param event
     */
    public void onMemberJoined(EMAThreadInfo event) {}

    /**
     * \brief Thread 成员主动退出事件
     * @param event
     */
    public void onMemberExited(EMAThreadInfo event) {}

    /**
     * \brief Thread 变化通知
     * @param event
     */
    public void onThreadNotifyChange(EMAThreadInfo event) {}

}
