package com.hyphenate.chat.adapter;


import com.hyphenate.chat.EMMessage;

import java.util.List;

public class EMAFetchMessageOption extends EMABase {
    public EMAFetchMessageOption() {
        nativeInit();
    }

    public void setSave(boolean save) {
        nativeSetSave(save);
    }

    public void setDirection(EMAConversation.EMASearchDirection direction) {
        nativeSetDirection(direction.ordinal());
    }

    public void setFrom(String from) {
        nativeSetFrom(from);
    }

    public void setFromIds(List<String> fromIds) {
        nativeSetFromIds(fromIds);
    }


    public void setMsgTypes(List<EMMessage.Type> msgTypes) {
        nativeSetMsgTypes(msgTypes);
    }

    public void setStartTime(long startTime) {
        nativeSetStartTime(startTime);
    }

    public void setEndTime(long endTime) {
        nativeSetEndTime(endTime);
    }

    @Override
    public void finalize() throws Throwable {
        nativeFinalize();
        super.finalize();
    }

    native void nativeSetSave(boolean save);
    native void nativeSetDirection(int ordinal);
    native void nativeSetFrom(String from);
    native void nativeSetFromIds(List<String> fromIds);
    native void nativeSetMsgTypes(List<EMMessage.Type> msgTypes);
    native void nativeSetStartTime(long startTime);
    native void nativeSetEndTime(long endTime);


    native void nativeInit();

    native void nativeFinalize();
}
