/*
 *  * EaseMob CONFIDENTIAL
 * __________________
 * Copyright (C) 2017 EaseMob Technologies. All rights reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of EaseMob Technologies.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from EaseMob Technologies.
 */
package com.hyphenate.chat.adapter;

import com.hyphenate.chat.adapter.message.EMAMessage;
import com.hyphenate.chat.adapter.message.EMAMessagePinInfo;

import java.util.List;

public interface EMAChatManagerListenerInterface {
    void onReceiveMessages(List<EMAMessage> message);
    void onReceiveCmdMessages(List<EMAMessage> cmdMessage);
    void onMessageStatusChanged(EMAMessage message, EMAError error);
    void onMessageAttachmentsStatusChanged(EMAMessage message, EMAError error);
    void onReceiveHasReadAcks(List<EMAMessage> message);
    void onReceiveRecallMessages(List<EMAMessage> message);
    void onReceiveRecallMessagesWithExt(List<EMARecallTuple> recallList);
    void onReceiveHasDeliveredAcks(List<EMAMessage> message);
    void onReceiveReadAckForConversation(String fromUsername, String toUsername);
    void onUpdateConversationList(List<EMAConversation> conversations);
    void onReceivePrivateMessages(List<EMAMessage> messages);
    void onReceiveReadAcksForGroupMessage(List<EMAGroupReadAck> acks);
    void onUpdateGroupAcks();
    void onMessageIdChanged(String convId, String oldId, String newId);
    void onMessageContentChanged(EMAMessage message,String operatorId,long operationTime);
    void onMessagePinChanged(String messageId, String conversationId, int pinOperation, EMAMessagePinInfo pinInfo);
}
