/************************************************************
 *  * EaseMob CONFIDENTIAL
 * __________________
 * Copyright (C) 2013-2014 EaseMob Technologies. All rights reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of EaseMob Technologies.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from EaseMob Technologies.
 */
package com.hyphenate.chat;

import android.os.Parcel;
import android.os.Parcelable;

import com.hyphenate.chat.adapter.EMAContact;


/**
 * \~chinese
 * `EMContact` 代表联系人对象。
 * <p>
 * \~english
 * `EMContact` is the object of contact.
 */
public class EMContact implements Parcelable {

    /**
     * \~chinese
     * 此用户的唯一标示名, 即用户的 ID。
     * <p>
     * \~english
     * The user ID assigned from the app. It identifies the user and should be unique in the app.
     */
    protected String username;
    protected String remark;
    private EMAContact emaContact;

    protected EMContact() {
        emaContact = new EMAContact();
    }

    protected EMContact(EMAContact emaContact) {
        this.emaContact = emaContact;
    }


    /**
     * \~chinese
     * 由用户 ID 构造 `EMContact` 对象。
     * <p>
     * \~english
     * Creates the `EMContact` object for the user ID.
     *
     * @param username The user ID.
     */
    public EMContact(String username) {
        this.username = username;
        emaContact = new EMAContact();
        emaContact.setUsername(username);
    }

    /**
     * \~chinese
     *
     * @param username 用户 ID。
     *
     * \~english
     * @param username The user ID.
     */
    public void setUsername(String username) {
        this.username = username;
        if (emaContact != null) {
            emaContact.setUsername(username);
        }
    }

    /**
     * \~chinese
     * 
     * 获取此联系人的用户 ID。
     *
     * @return 联系人的用户 ID。
     *
     * \~english
     * 
     * Gets the user ID of the contact.
     * 
     * @return The user ID of the contact.
     */
    public String getUsername() {

        if (emaContact == null) {
            return username;
        }
        return emaContact.getUsername();
    }


    /**
     * \~chinese
     * 
     * 设置该联系人的备注。
     *
     * @param remark 联系人备注。
     *
     * \~english
     * 
     * Sets the remarks of the contact.
     * 
     * @param remark The remarks of the contact.
     */
    public void setRemark(String remark) {
        this.remark = remark;
        if (emaContact != null) {
            emaContact.setRemark(remark);
        }
    }
    
    /**
     * \~chinese
     * 
     * 获取该联系人的备注。
     *
     * @return 联系人备注。
     *
     * \~english
     * 
     * Gets the remarks of the contact.
     * 
     * @return The remarks of the contact.
     */ 
    public String getRemark() {
        if (emaContact == null) {
            return remark;
        }
        return emaContact.getRemark();
    }

    @Override
    public String toString() {
        return "EMContact{" +
                "username='" + getUsername() + '\'' +
                ", remark='" + getRemark() + '\'' +
                '}';
    }

    protected EMContact(Parcel in) {
        username = in.readString();
        remark = in.readString();
    }

    public static final Creator<EMContact> CREATOR = new Creator<EMContact>() {
        @Override
        public EMContact createFromParcel(Parcel in) {
            return new EMContact(in);
        }

        @Override
        public EMContact[] newArray(int size) {
            return new EMContact[size];
        }
    };

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(username);
        dest.writeString(remark);
    }
}
