/*
 *  * EaseMob CONFIDENTIAL
 * __________________
 * Copyright (C) 2017 EaseMob Technologies. All rights reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of EaseMob Technologies.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from EaseMob Technologies.
 */
package com.hyphenate.chat.adapter;

import com.hyphenate.chat.adapter.message.EMAMessage;

import java.util.List;

public class EMAConversation extends EMABase {


	public enum  EMAConversationType {
        CHAT,               //single chat
        GROUPCHAT,          //group chat
        CHATROOM,           //chatroom chat
	}
	public enum EMASearchDirection {
		UP,
		DOWN
	}

	public EMAConversation(EMAConversation conversation) {
		nativeInit(conversation);
	}

	public final static int EMAConversationType_CHAT = 0;
	public final static int EMAConversationType_GROUPCHAT = 1;
	public final static int EMAConversationType_CHATROOM = 2;

	public String conversationId() {
		return nativeConversationId();
	}
	public EMAConversationType _getType() {
		int t = nativeConversationType();
		if (t == EMAConversationType_CHAT) {
			return EMAConversationType.CHAT;
		}
		if (t == EMAConversationType_GROUPCHAT) {
			return EMAConversationType.GROUPCHAT;
		}
		if (t == EMAConversationType_CHATROOM) {
			return EMAConversationType.CHATROOM;
		}
		return EMAConversationType.CHAT;
	}
	public boolean _removeMessage(String msgId) {
		return nativeRemoveMessage(msgId);
	}

	public boolean _removeMessage(long startTime,long endTime) {
		return nativeRemoveMessage(startTime,endTime);
	}
	
	public boolean removeMessage(EMAMessage msg) {
		return nativeRemoveMessage(msg);
	}
	
	public boolean insertMessage(EMAMessage msg) {
		return nativeInsertMessage(msg);
	}
	
	public boolean appendMessage(EMAMessage msg) {
		return nativeInsertMessage(msg);
	}
	
	public boolean updateMessage(EMAMessage msg) {
		return nativeUpdateMessage(msg);
	}
	
	public boolean clearAllMessages() {
		return nativeClearAllMessages();
	}
	
	public boolean markMessageAsRead(String msgId, boolean isRead) {
		return nativeMarkMessageAsRead(msgId, isRead);
	}
	public boolean markAllMessagesAsRead(boolean isRead) {
		return nativeMarkAllMessagesAsRead(isRead);
	}
	public int unreadMessagesCount() {
		return nativeUnreadMessagesCount();
	}
	public int messagesCount() {
		return nativeMessagesCount();
	}
	public boolean isChatThread() {
		return nativeIsThread();
	}
	public void setIsThread(boolean isThread) {
		nativeSetIsThread(isThread);
	}
	public boolean isPinned() {
		return nativeIsPinned();
	}

	public void setPin(boolean isPinned) {
		nativeSetPin(isPinned);
	}

	public long getPinnedTime() {
		return nativeGetPinnedTime();
	}

	public EMAMessage loadMessage(String msgId) {
		return nativeLoadMessage(msgId);
	}
	public EMAMessage latestMessage() {
		return nativeLatestMessage();
	}
	public EMAMessage latestMessageFromOthers() { return nativeLatestMessageFromOthers(); }
	public List<EMAMessage> loadMoreMessages(String refMsgId, int maxCount, EMASearchDirection direction) {
		return nativeLoadMoreMessages(refMsgId, maxCount, direction.ordinal());
	}
	public List<EMAMessage> searchMessages(long timeStamp, int maxCount, EMASearchDirection direction) {
		return nativeSearchMessages(timeStamp, maxCount, direction.ordinal());
	}
	public List<EMAMessage> searchMessages(int type, long timeStamp, int maxCount, String from, EMASearchDirection direction) {
		return nativeSearchMessages(type, timeStamp, maxCount, from, direction.ordinal());
	}
	public List<EMAMessage> searchMessages(String keywords, long timeStamp, int maxCount, String from, EMASearchDirection direction) {
		return nativeSearchMessages(keywords, timeStamp, maxCount, from, direction.ordinal());
	}
	public List<EMAMessage> searchMessages(String keywords, long timeStamp, int maxCount, String from, int direction,int scope) {
		return nativeSearchMessages(keywords, timeStamp, maxCount, from, direction,scope);
	}

	public List<EMAMessage> searchMessages(String keywords, long timeStamp, int maxCount, List<String> senders, int direction,int scope) {
		return nativeSearchMessages(keywords, timeStamp, maxCount, senders, direction,scope);
	}

	public List<EMAMessage> searchMessages(long startTimeStamp, long endTimeStamp, int maxCount) {
		return nativeSearchMessages(startTimeStamp, endTimeStamp, maxCount);
	}
	public List<EMAMessage> searchCustomMessages(String keywords, long timeStamp, int maxCount, String from, EMASearchDirection direction) {
		return nativeSearchCustomMessages(keywords, timeStamp, maxCount, from, direction.ordinal());
	}
	public String extField() {
		return nativeExtField();
	}
	public boolean _setExtField(String ext) {
		return nativeSetExtField(ext);
	}

	public long marks() {
		return nativeMarkTypes();
	}

	public List<EMAMessage> pinnedMessages() {
		return nativePinnedMessages();
	}

	public int remindType() {
		return nativeRemindType();
	}

	public int messagesCount(long startTime, long endTime) {
		return nativeMessagesCountWithTime(startTime, endTime);
	}

	//-------------------- native --------------------
	native String nativeConversationId();
	native int nativeConversationType();
	native boolean nativeRemoveMessage(String msgId);
	native boolean nativeRemoveMessage(EMAMessage msg);
	native boolean nativeRemoveMessage(long startTime,long endTime);
	native boolean nativeInsertMessage(EMAMessage msg);
	native boolean nativeAppendMessage(EMAMessage msg);
	native boolean nativeUpdateMessage(EMAMessage msg);
	native boolean nativeClearAllMessages();
	native void nativeClearCachedMessages();
	native boolean nativeMarkMessageAsRead(String msgId, boolean isRead);
	native boolean nativeMarkAllMessagesAsRead(boolean isRead);
	native int nativeUnreadMessagesCount();
	native int nativeMessagesCount();
	native int nativeMessagesCountWithTime(long startTime, long endTime);
	native boolean nativeIsThread();
	native void nativeSetIsThread(boolean isThread);
	native boolean nativeIsPinned();
	native void nativeSetPin(boolean isPinned);
	native long nativeGetPinnedTime();
	native EMAMessage nativeLoadMessage(String msgId);
	native EMAMessage nativeLatestMessage();
	native EMAMessage nativeLatestMessageFromOthers();
	native List<EMAMessage> nativeLoadMoreMessages(String refMsgId, int count, int direction);
	native List<EMAMessage> nativeSearchMessages(long timeStamp, int count, int direction);
	native List<EMAMessage> nativeSearchMessages(int type, long timeStamp, int count, String from, int direction);
	native List<EMAMessage> nativeSearchMessages(String keywords, long timeStamp, int count, String from, int direction);
	native List<EMAMessage> nativeSearchMessages(String keywords, long timeStamp, int count, String from, int direction,int scope);
	native List<EMAMessage> nativeSearchMessages(String keywords, long timeStamp, int count, List<String> senders, int direction,int scope);
	native List<EMAMessage> nativeSearchMessages(long startTimeStamp, long endTimeStamp, int maxCount);
	native List<EMAMessage> nativeSearchCustomMessages(String keywords, long timeStamp, int count, String from, int direction);
	native String nativeExtField();
	native boolean nativeSetExtField(String ext);
	native long nativeMarkTypes();
	native List<EMAMessage> nativePinnedMessages() ;
	native int nativeRemindType();

	public EMAConversation() {
		nativeInit();
	}
	
	@Override
	public void finalize() throws Throwable {
		nativeFinalize();
		super.finalize();
	}
	
	native void nativeInit();
	native void nativeInit(EMAConversation conversation);
	native void nativeFinalize();
}
