/*
 *  * EaseMob CONFIDENTIAL
 * __________________
 * Copyright (C) 2017 EaseMob Technologies. All rights reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of EaseMob Technologies.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from EaseMob Technologies.
 */
package com.hyphenate.chat.adapter;

import com.hyphenate.chat.adapter.message.EMAMessage;

import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public class EMAChatConfig extends EMABase {
	
	public void init(String resourcePath, String workPath, String appKey, String appId) {
		nativeInit(resourcePath, workPath, appKey, appId);
	}
	
	public String getResourcePath() {
		return nativegetResourcePath();
	}	
	native String nativegetResourcePath();
	
	public String getWorkPath() {
		return nativegetWorkPath();
	}
	native String nativegetWorkPath();
	
	public String getAppKey() {
		return nativegetAppKey();
	}
	native String nativegetAppKey();
	
	public void setAppKey(String appkey) {
		nativesetAppKey(appkey);
	}	
	native void nativesetAppKey(String appkey);

	public String getAppId() {
		return nativeGetAppId();
	}
	native String nativeGetAppId();

	public void setAppId(String appId) {
		nativeSetAppId(appId);
	}
	native void nativeSetAppId(String appId);

	public void setAppPackageName(String name) {
		nativeSetAppPackageName(name);
	}
	native void nativeSetAppPackageName(String name);
	
	public void setIsSandboxMode(boolean b) {
		nativesetIsSandboxMode(b);
	}
	native void nativesetIsSandboxMode(boolean b);
	
	public boolean getIsSandboxMode() {
		return nativegetIsSandboxMode();
	}
	native boolean nativegetIsSandboxMode();
	
	public void setEnableConsoleLog(boolean b) {
		nativesetEnableConsoleLog(b);
	}
	native void nativesetEnableConsoleLog(boolean b);
	
	public boolean getEnableConsoleLog() {
		return nativegetEnableConsoleLog();
	}
	native boolean nativegetEnableConsoleLog();

	
	public void setAutoLogin(boolean b) {
		nativesetAutoLogin(b);
	}
	native void nativesetAutoLogin(boolean b);
	
	public boolean getAutoLogin() {
		return nativegetAutoLogin();
	}
	native boolean nativegetAutoLogin();
	
	public void setAutoAccept(boolean b) {
		nativesetAutoAccept(b);
	}
	native void nativesetAutoAccept(boolean b);
	
	public boolean getAutoAccept() {
		return nativegetAutoAccept();
	}
	native boolean nativegetAutoAccept();
	
	public void setRequireReadAck(boolean b) {
		nativesetRequireReadAck(b);
	}
	native void nativesetRequireReadAck(boolean b);
	
	public boolean getRequireReadAck() {
		return nativegetRequireReadAck();
	}	
	native boolean nativegetRequireReadAck();
	
	public void setRequireDeliveryAck(boolean b) {
		nativesetRequireDeliveryAck(b);
	}
	native void nativesetRequireDeliveryAck(boolean b);
	
	public boolean getRequireDeliveryAck() {
		return nativegetRequireDeliveryAck();
	}
	native boolean nativegetRequireDeliveryAck();

	public void setAutoConversationLoaded(boolean b) {
		nativesetAutoConversationLoaded(b);
	}
	native void nativesetAutoConversationLoaded(boolean b);
	
	public boolean getAutoConversationLoaded() {
		return nativegetAutoConversationLoaded();
	}
	native boolean nativegetAutoConversationLoaded();
	
	public void setDeleteMessageAsExitGroup(boolean b) {
		nativesetDeleteMessageAsExitGroup(b);
	}
	native void nativesetDeleteMessageAsExitGroup(boolean b);
	
	public boolean getDeleteMessageAsExitGroup() {
		return nativegetDeleteMessageAsExitGroup();
	}
	native boolean nativegetDeleteMessageAsExitGroup();
	
	public void setAutoAcceptGroupInvitation(boolean b) {
	    nativesetAutoAcceptGroupInvitation(b);
	}
	native void nativesetAutoAcceptGroupInvitation(boolean b);

	public boolean getAutoAcceptGroupInvitation() {
	    return nativegetAutoAcceptGroupInvitation();
	}
	native boolean nativegetAutoAcceptGroupInvitation();
	
	public void setIsChatroomOwnerLeaveAllowed(boolean b) {
		nativesetIsChatroomOwnerLeaveAllowed(b);
	}
	native void nativesetIsChatroomOwnerLeaveAllowed(boolean b);
	
	public boolean getIsChatroomOwnerLeaveAllowed() {
		return nativegetIsChatroomOwnerLeaveAllowed();
	}
	native boolean nativegetIsChatroomOwnerLeaveAllowed();

	public void setDeleteMessageAsExitChatRoom(boolean b) {
		nativesetDeleteMessageAsExitChatRoom(b);
	}
	native void nativesetDeleteMessageAsExitChatRoom(boolean b);

	public boolean getDeleteMessageAsExitChatRoom() {
		return nativegetDeleteMessageAsExitChatRoom();
	}
	native boolean nativegetDeleteMessageAsExitChatRoom();
	
	public boolean isGcmEnabled(){
	    return nativeIsGcmEnabled();
	}
    native boolean nativeIsGcmEnabled();
	
	public void setChatServer(String address) {
		nativesetChatServer(address);
	}
	native void nativesetChatServer(String address);
	
	public void setChatPort(int port) {
	    nativesetChatPort(port);
	}
	native void nativesetChatPort(int port);
	
	public void setWebSocketServer(String wsServer) {
		nativesetWebSocketServer(wsServer);
	}
	native void nativesetWebSocketServer(String wsServer);

	public String getWebSocketServer() {
		return nativegetWebSocketServer();
	}
	native String nativegetWebSocketServer();

	public void setWebSocketPort(int port) {
		nativesetWebSocketPort(port);
	}
	native void nativesetWebSocketPort(int port);

	public int getWebSocketPort() {
		return nativegetWebSocketPort();
	}
	native int nativegetWebSocketPort();

	public void setRestServer(String resturl) {
		nativesetRestServer(resturl);
	}
	native void nativesetRestServer(String resturl);

	public void setRtcServer(String rtcurl) {
		nativesetRtcServer(rtcurl);
	}
	native void nativesetRtcServer(String rtcurl);
	
	public void setChatDomain(String domain) {
		nativesetChatDomain(domain);
	}
	native void nativesetChatDomain(String domain);
	
	public void setGroupDomain(String domain) {
		nativesetGroupDomain(domain);
	}
	native void nativesetGroupDomain(String domain);
	
	public void enableDnsConfig(boolean b) {
		nativeenableDnsConfig(b);
	}
	native void nativeenableDnsConfig(boolean b);

	public boolean isEnableDnsConfig() {
		return nativeisEnableDnsConfig();
	}
	native boolean nativeisEnableDnsConfig();
	
	public String getChatAddress() {
		return nativegetChatAddress();
	}
	native String nativegetChatAddress();
	

	public String getRestServer() {
		return nativegetRestServer();
	}
	native String nativegetRestServer();
	
	public String getChatDomain() {
		return nativegetChatDomain();
	}
	native String nativegetChatDomain();
	
	public String getGroupDomain() {
		return nativegetGroupDomain();
	}
	native String nativegetGroupDomain();
	
	public boolean useHttps() {
		return false;
//		return nativeuserHttps();
	}
	native boolean nativeuseHttps();
	
	// native part EMDNSManager, rest base url
	public String getBaseUrl(boolean withAppkey, boolean next) {
		return nativegetBaseUrl(withAppkey, next);
	}
	native String nativegetBaseUrl(boolean withAppkey, boolean next);
	
	// native part EMDNSManager
	public String getNextAvailableBaseUrl() {
		return nativegetNextAvailableBaseUrl();
	}
	native String nativegetNextAvailableBaseUrl();
	
	public String getAccessToken() {
		return getAccessToken(false);
	}
	
	public String getAccessToken(boolean getFromServer) {
		return nativegetAccessToken(getFromServer);
	}
	native String nativegetAccessToken(boolean getFromServer);
	
	public long getTokenSaveTime() {
		return nativegetTokenSaveTime();
	}
	native long nativegetTokenSaveTime();
	
    public void importMessages(List<EMAMessage> msgs) {
    	nativeImportMessages(msgs);
    }    
    native void nativeImportMessages(List<EMAMessage> msgs);
    public void setLogPath(String path) {
    	nativesetLogPath(path);
    }
    native void nativesetLogPath(String path);
    
    public void setDownloadPath(String path) {
        nativesetDownloadPath(path);
    }
    native void nativesetDownloadPath(String path);

	public String getDownloadPath() {
		return nativegetDownloadPath();
	}
	native String nativegetDownloadPath();
   
	@Override
	public void finalize() throws Throwable {
		nativeFinalize();
		super.finalize();
	}
	
	native void nativeInit(String resourcePath, String workPath, String appKey, String appId);
	native void nativeFinalize();

	public void retrieveDNSConfig() {
		nativeretrieveDNSConfig();
	}
	native void nativeretrieveDNSConfig();
	
	public void uploadLog(EMACallback callback) {
	    nativeUploadLog(callback);
	}
	native void nativeUploadLog(EMACallback callback);

	public void setDebugMode(boolean debug) {
	    nativeSetDebugMode(debug);
	}
	native void nativeSetDebugMode(boolean debug);

	public void importGroup(String id, int style, String owner, String subject, String description, List<String> allMembers, boolean isBlocked, int maxUsers) {
	    nativeImportGroup(id, style, owner, subject, description, allMembers, isBlocked, maxUsers);
	}
	native void nativeImportGroup(String id, int style, String owner, String subject, String description, List<String> allMembers, boolean isBlocked, int maxUsers);

	public void importChatRoom(String username, String ownerName, String subject, String description, List<String> members, int maxUsers) {
	    nativeImportChatRoom(username, ownerName, subject, description, members, maxUsers);
	}
	native void nativeImportChatRoom(String username, String ownerName, String subject, String description, List<String> members, int maxUsers);
	
	public void importConversation(String convId, int type, String ext) {
	    nativeImportConversation(convId, type, ext);
	}
	native void nativeImportConversation(String convId, int type, String ext);
	
	public void importBlackList(List<String> blacklist) {
	    nativeImportBlackList(blacklist);
	}
	native void nativeImportBlackList(List<String> blacklist);
	
	public void setNetCallback(EMANetCallback callback) {
	    nativeSetCallbackNet(callback);
	}
	native void nativeSetCallbackNet(EMANetCallback callback);
	
	public void updateConversationUnreadCount(String conversationId, int count) {
	    nativeUpdateConversationUnreadCount(conversationId, count);
	}
	native void nativeUpdateConversationUnreadCount(String conversationId, int count);
	
	public void importContacts(List<String> contacts) {
	    nativeImportContacts(contacts);
	}
	native void nativeImportContacts(List<String> contacts);
	
	public void reloadAll() {
	    nativeReloadAll();
	}
	native void nativeReloadAll();
	
	public static void logD(String tag, String msg) {
	    nativeLogD(tag, msg);
	}
	static native void nativeLogD(String tag, String msg);
	
	public static void logE(String tag, String msg) {
	    nativeLogE(tag, msg);
	}
	native static void nativeLogE(String tag, String msg);

	public static void logI(String tag, String msg) {
	    nativeLogI(tag, msg);
	}
	native static void nativeLogI(String tag, String msg);

	public static void logV(String tag, String msg) {
	    nativeLogV(tag, msg);
	}
	native static void nativeLogV(String tag, String msg);
	    
	public static void logW(String tag, String msg) {
	    nativeLogW(tag, msg);
	}
	native static void nativeLogW(String tag, String msg);

	public void setSDKVersion(String sdkVersion) {
	    nativeSetSDKVersion(sdkVersion);
	}
	native void nativeSetSDKVersion(String sdkVersion);

	public void setOSVersion(String OSVersion) {
		nativeSetOSVersion(OSVersion);
	}
	native void nativeSetOSVersion(String OSVersion);
	
	public void setUseAws(boolean useAws) {
	    nativeSetUseAws(useAws);
	}
	native void nativeSetUseAws(boolean useAws);

	public boolean getUseAws() {
		return nativeGetUseAws();
	}
	native boolean nativeGetUseAws();
	
	public void setSortMessageByServerTime(boolean sortByServerTime) {
	    nativeSetSortMessageByServerTime(sortByServerTime);
	}
	native void nativeSetSortMessageByServerTime(boolean sortByServerTime);
	
	public boolean getSortMessageByServerTime() {
	    return nativeGetSortMessageByServerTime();
	}
	native boolean nativeGetSortMessageByServerTime();

	public String getGaoDeDiscoverKey() {
		return nativeGetGaoDeDiscoverKey();
	}
	native String nativeGetGaoDeDiscoverKey();

	public String getGaoDeLocationKey() {
		return nativeGetGaoDeLocationKey();
	}
	native String nativeGetGaoDeLocationKey();

	public boolean hasHeartBeatCustomizedParams() {
		return nativeHasHeartBeatCustomizedParams();
	}
	native boolean nativeHasHeartBeatCustomizedParams();

	public EMAHeartBeatCustomizedParams getWifiHeartBeatCustomizedParams() {
		AtomicInteger min = new AtomicInteger();
		AtomicInteger max = new AtomicInteger();
		AtomicInteger _default = new AtomicInteger();
		nativeGetWifiHeartBeatCustomizedParams(min, max, _default);
		EMAHeartBeatCustomizedParams params = new EMAHeartBeatCustomizedParams();
		params.minInterval = min.get();
		params.maxInterval = max.get();
		params.defaultInterval = _default.get();
		return params;
	}
	native void nativeGetWifiHeartBeatCustomizedParams(AtomicInteger minInterval, AtomicInteger maxInterval, AtomicInteger defaultInterval);

	public EMAHeartBeatCustomizedParams getMobileHeartBeatCustomizedParams() {
		AtomicInteger min = new AtomicInteger();
		AtomicInteger max = new AtomicInteger();
		AtomicInteger _default = new AtomicInteger();
		nativeGetMobileHeartBeatCustomizedParams(min, max, _default);
		EMAHeartBeatCustomizedParams params = new EMAHeartBeatCustomizedParams();
		params.minInterval = min.get();
		params.maxInterval = max.get();
		params.defaultInterval = _default.get();
		return params;
	}
	native void nativeGetMobileHeartBeatCustomizedParams(AtomicInteger minInterval, AtomicInteger maxInterval, AtomicInteger defaultInterval);

	public void setUseHttps(boolean useHttps) {
		nativeSetUseHttps(useHttps);
	}
	native void nativeSetUseHttps(boolean useHttps);

	public void setUsingHttpsOnly(boolean usingHttpsOnly) {
		nativeSetUsingHttpsOnly(usingHttpsOnly);
	}
	native void nativeSetUsingHttpsOnly(boolean usingHttpsOnly);

	public boolean getUsingHttpsOnly() {
		return nativeGetUsingHttpsOnly();
	}
	native boolean nativeGetUsingHttpsOnly();

    public void setDeviceUuid(String uuid) {
        nativesetDeviceUuid(uuid);
    }
    native void nativesetDeviceUuid(String uuid);

    public void setDid(String did) {
        nativesetDid(did);
    }


	native void nativesetDid(String did);

    public void setServiceId(String serviceId) {
		nativesetServiceId(serviceId);
    }
    native void nativesetServiceId(String serviceId);

	public void setDeviceName(String deviceName) {
		nativesetDeviceName(deviceName);
	}
	native void nativesetDeviceName(String deviceName);

	public String getDeviceName() {
		return nativeGetDeviceName();
	}
	native String nativeGetDeviceName();

	public void setLoginCustomExt(String ext){nativesetDeviceReason(ext);}
	native void nativesetDeviceReason(String ext);
	public String getLoginInfoCustomExt(){return nativeGetDeviceReason();}
	native String nativeGetDeviceReason();

	public void setDnsUrl(String dnsUrl) {
		nativeSetDnsUrl(dnsUrl);
	}
 	native void nativeSetDnsUrl(String dnsUrl);

	public String getDnsUrl() {
		return nativeGetDnsUrl();
	}
 	native String nativeGetDnsUrl();

	public boolean getUsingSQLCipher() {
		return nativeGetUsingSQLCipher();
	}
	native boolean nativeGetUsingSQLCipher();

	public void setTransferAttachments(boolean serverTransfer) {
		nativeSetTransferAttachments(serverTransfer);
	}
	native void nativeSetTransferAttachments(boolean serverTransfer);
	public boolean getTransferAttachments() {
		return nativeGetTransferAttachments();
	}
	native boolean nativeGetTransferAttachments();

	public void setAutodownloadThumbnail(boolean autodownload) {
		nativeSetAutodownloadThumbnail(autodownload);
	}
	native void nativeSetAutodownloadThumbnail(boolean autodownload);
	public boolean getAutodownloadThumbnail() {
		return nativeGetAutodownloadThumbnail();
	}
	native boolean nativeGetAutodownloadThumbnail();

	public void setUseRtcConfig(boolean useRtcConfig) {
		nativeSetUseRtcConfig(useRtcConfig);
	}
	native void nativeSetUseRtcConfig(boolean useRtcConfig);

	public boolean getUseRtcConfig() { return  nativeGetUseRtcConfig();}
	native boolean nativeGetUseRtcConfig();

    public void setRtcConfigUrl(String rtcConfigUrl) {
        nativeSetRtcConfigUrl(rtcConfigUrl);
    }
    native void nativeSetRtcConfigUrl(String rtcConfigUrl);

    public String getRtcConfigUrl(){ return  nativeGetRtcConfigUrl();}
    native String nativeGetRtcConfigUrl();

	public boolean isNewLoginOnDevice() { return nativeIsNewLoginOnDevice(); }
	native boolean nativeIsNewLoginOnDevice();

	public void setAreaCode(int code) {
		nativeSetAreaCode(code);
	}
	native void nativeSetAreaCode(int code);
  
	public boolean isEnableStatistics() {
		return nativeIsEnableStatistics();
	}

	native boolean nativeIsEnableStatistics();

	public void setEnableStatistics(boolean enable) {
		nativeSetEnableStatistics(enable);
	}

	native void nativeSetEnableStatistics(boolean enable);

	public void setCustomOSPlatform(int platform) {
		nativeCustomOSPlatform(platform);
	}

	native void nativeCustomOSPlatform(int platform);

	public int  getCustomOSPlatform() {
		return nativeGetCustomOSPlatform();
	}

	native int nativeGetCustomOSPlatform();

	public boolean isLoadEmptyConversations() {
		return nativeIsLoadEmptyConversations();
	}
	native boolean nativeIsLoadEmptyConversations();

	public void setLoadEmptyConversations(boolean isLoadEmptyConversations) {
		nativeSetLoadEmptyConversations(isLoadEmptyConversations);
	}
	native void nativeSetLoadEmptyConversations(boolean isLoadEmptyConversations);

	public boolean isUseReplacedMessageContents() {
		return nativeIsUseReplacedMessageContents();
	}

	native boolean nativeIsUseReplacedMessageContents() ;

	public void setUseReplacedMessageContents(boolean useReplacedMessageContents) {
		nativeSetUseReplacedMessageContents(useReplacedMessageContents);
	}

	native void nativeSetUseReplacedMessageContents(boolean useReplacedMessageContents) ;

	public void setCallbackSendMessageInMessageListener(boolean whetherCallback) {
		nativeSetCallbackSendMessageInMessageListener(whetherCallback);
	}

	native void nativeSetCallbackSendMessageInMessageListener(boolean whetherCallback) ;

	public  boolean isCallbackSendMessageInMessageListener() {
		return nativeIsCallbackSendMessageInMessageListener();
	}

	native boolean nativeIsCallbackSendMessageInMessageListener();
	public boolean regardImportedMsgAsRead() {return nativeRegardImportedMsgAsRead(); }
	native boolean nativeRegardImportedMsgAsRead();

	public void setRegardImportedMsgAsRead(boolean regardImportedMsgAsRead) {
		nativeSetRegardImportedMsgAsRead(regardImportedMsgAsRead);
	}
	native void nativeSetRegardImportedMsgAsRead(boolean regardImportedMsgAsRead);

	public void setEnableTLSConnection(boolean enableTLSConnection) {
		nativeSetEnableTLSConnection(enableTLSConnection);
	}

	native void nativeSetEnableTLSConnection(boolean enableTLSConnection);

	public boolean isEnableTLSConnection() {
		return nativeIsEnableTLSConnection();
	}

	native boolean nativeIsEnableTLSConnection();

	public void setEnableCrashReport(boolean enableCrashReport) {
		nativeSetEnableCrashReport(enableCrashReport);
	}
	native void nativeSetEnableCrashReport(boolean enableCrashReport);

	public boolean isEnableCrashReport() {
		return nativeIsEnableCrashReport();
	}
	native boolean nativeIsEnableCrashReport();

	public void setUIKitVersion(String uikitVersion) {
		nativeSetUIKitVersion(uikitVersion);
	}
	native void nativeSetUIKitVersion(String uikitVersion);

	public String getUIKitVersion() {
		return nativeGetUIKitVersion();
	}
	native String nativeGetUIKitVersion();

	public int getSDKPlatform() {

		return nativeGetSDKPlatform();
	}
	native int nativeGetSDKPlatform();

	public void setSDKPlatform(int ordinal) {
		nativeSetSDKPlatform(ordinal);
	}
	native void nativeSetSDKPlatform(int ordinal);
}
