/*
 *  * EaseMob CONFIDENTIAL
 * __________________
 * Copyright (C) 2017 EaseMob Technologies. All rights reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of EaseMob Technologies.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from EaseMob Technologies.
 */
package com.hyphenate;

/**
 *  \~chinese
 * 带参数的回调函数。
 * 不带参数的回调函数见 {@link EMCallBack}。
 *
 * @param <T> 参数类型。
 *
 *  \~english
 * The callback function with a parameter.
 * For the callback function without a parameter, see {@link EMCallBack}.
 *
 * @param <T> value     The parameter type.
 */
public interface EMValueCallBack<T>
{
	/**
     * \~chinese
	 * 回调函数成功执行，返回参数的值。
	 *
	 * @param value     value 的 class 类型是 T。
     *
     * \~english
	 * Occurs when the callback function executes successfully with a value returned.
     *
	 * @param value     The class type of value is T. 
	 * 
	 */
    void onSuccess(T value);

    /**
     * \~chinese
     * 请求失败时的回调函数。
     *
     * @param error     错误代码，详见 {@link EMError}。
     * @param errorMsg  错误信息。
     *
     * \~english
     * Occurs when the request fails.
     *
     * @param error     The error code. See {@link EMError}.
     * @param errorMsg  A description of the issue that caused this call to fail.
     */
    void onError(final int error, final String errorMsg);

	/**
	 *  \~chinese
	 *  刷新进度的回调函数。
	 *
	 *  @param progress       进度信息。
	 *  @param status         包含文件描述的进度信息，如果 SDK 没有提供，结果可能是 ""，或者 null。
	 *
	 *  \~english
	 *  Occurs when the progress updates.
	 *
	 *  @param progress       The progress information.
	 *  @param status         A description of the progress. Might be an empty string "" or null if the SDK does not return the information.
	 *
	 */
	default void onProgress(int progress, String status) {}
}
